/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.kie.workbench.common.dmn.client.widgets.codecompletion.MonacoFEELInitializer;

public class FEELSyntaxLightValidator {
    private static final Character[] FORBIDDEN_CHARS = new Character[]{Character.valueOf('!'), Character.valueOf('@'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('^'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf('\u00b0'), Character.valueOf('\u00a7'), Character.valueOf('\u2190'), Character.valueOf('\u2192'), Character.valueOf('\u2193'), Character.valueOf('\u00a2'), Character.valueOf('\u00b5'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('|'), Character.valueOf('\\'), Character.valueOf('='), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(';'), Character.valueOf(':'), Character.valueOf(','), Character.valueOf('\u00b6'), Character.valueOf('\u00ab'), Character.valueOf('\u00bb'), Character.valueOf('\u201d'), Character.valueOf('\u201c')};
    private static final Character[] ALLOWED_SEPARATORS = new Character[]{Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('/'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+')};
    private static final Character[] FORBIDDEN_CHARS_AS_INITIAL = (Character[])Stream.concat(Stream.of(FORBIDDEN_CHARS), Stream.of(ALLOWED_SEPARATORS)).toArray(Character[]::new);
    private static final Function<Character, String> CHAR_TO_STRING_MAPPER = c -> Character.toString(c.charValue());

    public static boolean isVariableNameValid(String variableName) {
        return FEELSyntaxLightValidator.notEmpty(variableName) && FEELSyntaxLightValidator.firstCharacterIsValid(variableName) && FEELSyntaxLightValidator.firstWordIsNotReservedKeyword(variableName) && FEELSyntaxLightValidator.doesNotContainForbiddenChars(variableName);
    }

    private static boolean notEmpty(String variableName) {
        return variableName != null && !variableName.trim().isEmpty();
    }

    private static boolean firstCharacterIsValid(String variableName) {
        char firstLetter = variableName.charAt(0);
        return FEELSyntaxLightValidator.firstLetterIsNotADigit(firstLetter) && FEELSyntaxLightValidator.containsNone(Character.valueOf(firstLetter), FORBIDDEN_CHARS_AS_INITIAL);
    }

    private static boolean firstLetterIsNotADigit(char firstLetter) {
        return !Character.isDigit(firstLetter);
    }

    private static boolean firstWordIsNotReservedKeyword(String variableName) {
        return FEELSyntaxLightValidator.containsNone(variableName.split(FEELSyntaxLightValidator.buildSeparatorRegex())[0], MonacoFEELInitializer.FEEL_RESERVED_KEYWORDS.toArray());
    }

    private static String buildSeparatorRegex() {
        return "[" + FEELSyntaxLightValidator.getSeparatorSequence() + "]";
    }

    private static String getSeparatorSequence() {
        return Stream.of(ALLOWED_SEPARATORS).map(CHAR_TO_STRING_MAPPER).reduce(" ", (separatorSequence, separator) -> separatorSequence + separator);
    }

    private static boolean doesNotContainForbiddenChars(String variableName) {
        String variableNameWithoutInitial = variableName.substring(1);
        return Stream.of(FORBIDDEN_CHARS).map(CHAR_TO_STRING_MAPPER).noneMatch(variableNameWithoutInitial::contains);
    }

    private static <T> boolean containsNone(T inputStr, T[] items) {
        return Arrays.stream(items).noneMatch(inputStr::equals);
    }
}

