/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.converters;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.appformer.kogito.bridge.client.resource.interop.ResourceListOptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNIncludedNodeFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.converters.DMNMarshallerImportsHelperKogitoImpl;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.DMNClientDiagramServiceImpl;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.PMMLMarshallerService;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12.JSITImport;
import org.kie.workbench.common.kogito.webapp.base.client.workarounds.KogitoResourceContentService;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNMarshallerImportsHelperKogitoImplTest {
    @Mock
    private DMNClientDiagramServiceImpl dmnClientDiagramServiceMock;
    @Mock
    private DMNDiagramUtils dmnDiagramUtilsMock;
    @Mock
    private DMNIncludedNodeFactory dmnIncludedNodeFactoryMock;
    @Mock
    private KogitoResourceContentService kogitoResourceContentServiceMock;
    @Mock
    private Metadata metadataMock;
    @Mock
    private PMMLMarshallerService pmmlMarshallerServiceMock;
    @Mock
    private ServiceCallback serviceCallbackMock;
    @Captor
    private ArgumentCaptor<List<IncludedModel>> modelsCapture;
    private static final String DMN_FILE = "test-dmn.dmn";
    private static final String DMN_PATH = "dmntest/test-dmn.dmn";
    private static final String DMN_CONTENT = "<xml> xml DMN content </xml>";
    private static final String PMML_FILE = "test-pmml.pmml";
    private static final String PMML_PATH = "dmnpmml/test-pmml.pmml";
    private static final String PMML_CONTENT = "<xml> xml PMML content </xml>";
    private static final String TEXT_FILE = "test-file.txt";
    private static final String TEXT_PATH = "invalidfile/test-file.txt";
    private DMNMarshallerImportsHelperKogitoImpl dmnMarshallerImportsHelperKogitoImpl;
    private Promises promises;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.dmnMarshallerImportsHelperKogitoImpl = new DMNMarshallerImportsHelperKogitoImpl(this.kogitoResourceContentServiceMock, this.dmnClientDiagramServiceMock, this.promises, this.dmnDiagramUtilsMock, this.dmnIncludedNodeFactoryMock, this.pmmlMarshallerServiceMock);
    }

    @Test
    public void loadModelsDMNFile() {
        Mockito.when((Object)this.kogitoResourceContentServiceMock.getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class))).thenReturn((Object)this.promises.resolve((Object)new String[]{DMN_PATH}));
        Mockito.when((Object)this.kogitoResourceContentServiceMock.loadFile(DMN_PATH)).thenReturn((Object)this.promises.resolve((Object)DMN_CONTENT));
        this.dmnMarshallerImportsHelperKogitoImpl.loadModels(this.serviceCallbackMock);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class));
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).loadFile((String)Matchers.eq((Object)DMN_PATH));
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.dmnClientDiagramServiceMock, (VerificationMode)Mockito.times((int)1))).transform((String)Matchers.eq((Object)DMN_CONTENT), (ServiceCallback)Matchers.isA(ServiceCallback.class));
    }

    @Test
    public void loadModelsPMMLFile() {
        Mockito.when((Object)this.kogitoResourceContentServiceMock.getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class))).thenReturn((Object)this.promises.resolve((Object)new String[]{PMML_PATH}));
        Mockito.when((Object)this.kogitoResourceContentServiceMock.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        Mockito.when((Object)this.pmmlMarshallerServiceMock.getDocumentMetadata(PMML_PATH, PMML_CONTENT)).thenReturn((Object)this.promises.resolve((Object)new PMMLDocumentMetadata(PMML_PATH, PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList())));
        this.dmnMarshallerImportsHelperKogitoImpl.loadModels(this.serviceCallbackMock);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class));
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).loadFile((String)Matchers.eq((Object)PMML_PATH));
        ((PMMLMarshallerService)Mockito.verify((Object)this.pmmlMarshallerServiceMock, (VerificationMode)Mockito.times((int)1))).getDocumentMetadata((String)Matchers.eq((Object)PMML_PATH), (String)Matchers.eq((Object)PMML_CONTENT));
        ((ServiceCallback)Mockito.verify((Object)this.serviceCallbackMock, (VerificationMode)Mockito.times((int)1))).onSuccess(this.modelsCapture.capture());
        Assert.assertEquals((long)1L, (long)((List)this.modelsCapture.getValue()).size());
        Assert.assertEquals((Object)PMML_FILE, (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getPath());
        Assert.assertEquals((Object)PMML_FILE, (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getModelName());
        Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)((IncludedModel)((List)this.modelsCapture.getValue()).get(0)).getImportType());
        Assert.assertEquals((long)0L, (long)((PMMLIncludedModel)((List)this.modelsCapture.getValue()).get(0)).getModelCount().intValue());
    }

    @Test
    public void loadModelsInvalidFile() {
        Mockito.when((Object)this.kogitoResourceContentServiceMock.getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class))).thenReturn((Object)this.promises.resolve((Object)new String[]{TEXT_PATH}));
        this.dmnMarshallerImportsHelperKogitoImpl.loadModels(this.serviceCallbackMock);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"*.{dmn,pmml}"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class));
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.never())).loadFile((String)Matchers.any());
        ((PMMLMarshallerService)Mockito.verify((Object)this.pmmlMarshallerServiceMock, (VerificationMode)Mockito.never())).getDocumentMetadata((String)Matchers.any(), (String)Matchers.any());
        ((DMNClientDiagramServiceImpl)Mockito.verify((Object)this.dmnClientDiagramServiceMock, (VerificationMode)Mockito.never())).transform((String)Matchers.any(), (ServiceCallback)Matchers.any());
    }

    @Test
    public void getPMMLDocumentsAsync_EmptyImports() {
        Promise returnPromise = this.dmnMarshallerImportsHelperKogitoImpl.getPMMLDocumentsAsync(this.metadataMock, Collections.emptyList());
        returnPromise.then(p0 -> {
            Assert.assertEquals((long)0L, (long)p0.size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getPMMLDocumentsAsyncNoPMMLFiles() {
        Mockito.when((Object)this.kogitoResourceContentServiceMock.getFilteredItems((String)Matchers.eq((Object)"*.pmml"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class))).thenReturn((Object)this.promises.resolve((Object)new String[0]));
        ArrayList<Object> imports = new ArrayList<Object>();
        imports.add(Mockito.mock(JSITImport.class));
        Promise returnPromise = this.dmnMarshallerImportsHelperKogitoImpl.getPMMLDocumentsAsync(this.metadataMock, imports);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"*.pmml"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class));
        returnPromise.then(p0 -> {
            Assert.assertEquals((long)0L, (long)p0.size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getPMMLDocumentsAsync() {
        Mockito.when((Object)this.kogitoResourceContentServiceMock.getFilteredItems((String)Matchers.eq((Object)"*.pmml"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class))).thenReturn((Object)this.promises.resolve((Object)new String[]{PMML_PATH}));
        Mockito.when((Object)this.kogitoResourceContentServiceMock.loadFile(PMML_PATH)).thenReturn((Object)this.promises.resolve((Object)PMML_CONTENT));
        Mockito.when((Object)this.pmmlMarshallerServiceMock.getDocumentMetadata(PMML_PATH, PMML_CONTENT)).thenReturn((Object)this.promises.resolve((Object)new PMMLDocumentMetadata(PMML_PATH, PMML_FILE, DMNImportTypes.PMML.getDefaultNamespace(), Collections.emptyList())));
        ArrayList<JSITImport> imports = new ArrayList<JSITImport>();
        JSITImport jsImportMock = (JSITImport)Mockito.mock(JSITImport.class);
        Mockito.when((Object)jsImportMock.getLocationURI()).thenReturn((Object)PMML_FILE);
        imports.add(jsImportMock);
        Promise returnPromise = this.dmnMarshallerImportsHelperKogitoImpl.getPMMLDocumentsAsync(this.metadataMock, imports);
        ((KogitoResourceContentService)Mockito.verify((Object)this.kogitoResourceContentServiceMock, (VerificationMode)Mockito.times((int)1))).getFilteredItems((String)Matchers.eq((Object)"*.pmml"), (ResourceListOptions)Matchers.isA(ResourceListOptions.class));
        returnPromise.then(def -> {
            Assert.assertEquals((long)1L, (long)def.size());
            Assert.assertEquals((Object)PMML_PATH, (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getPath());
            Assert.assertEquals((Object)PMML_FILE, (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getName());
            Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)((PMMLDocumentMetadata)def.get(jsImportMock)).getImportType());
            Assert.assertEquals((long)0L, (long)((PMMLDocumentMetadata)def.get(jsImportMock)).getModels().size());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }
}

