/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import elemental2.promise.Promise;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.editors.included.DMNImportTypes;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.PMMLMarshallerService;
import org.uberfire.client.promise.Promises;
import org.uberfire.promise.SyncPromises;

public class PMMLMarshallerServiceTest {
    private static final String FILENAME = "fileName.pmml";
    private static final String PATH = "test/fileName.pmml";
    private static final String CONTENT = "<xml>content</xml>";
    private Promises promises;
    private PMMLMarshallerService pmmlMarshallerService;

    @Before
    public void setup() {
        this.promises = new SyncPromises();
        this.pmmlMarshallerService = new PMMLMarshallerService(this.promises);
    }

    @Test
    public void getDocumentMetadata() {
        Promise returnPromise = this.pmmlMarshallerService.getDocumentMetadata(PATH, CONTENT);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(pmmlDocumentMetadata -> {
            Assert.assertNotNull((Object)pmmlDocumentMetadata);
            Assert.assertEquals((Object)PATH, (Object)pmmlDocumentMetadata.getPath());
            Assert.assertEquals((Object)FILENAME, (Object)pmmlDocumentMetadata.getName());
            Assert.assertEquals((Object)DMNImportTypes.PMML.getDefaultNamespace(), (Object)pmmlDocumentMetadata.getImportType());
            return this.promises.resolve();
        }).catch_(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void getDocumentMetadataNullFile() {
        this.getDocumentMetadataInvalidContent(null, CONTENT, "PMML fileName required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataEmptyFile() {
        this.getDocumentMetadataInvalidContent("", CONTENT, "PMML fileName required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataNullContent() {
        this.getDocumentMetadataInvalidContent(PATH, null, "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    @Test
    public void getDocumentMetadataEmptyContent() {
        this.getDocumentMetadataInvalidContent(PATH, "", "PMML file test/fileName.pmml content required to be marshalled is empty or null");
    }

    public void getDocumentMetadataInvalidContent(String pmmlFile, String pmmlFileContent, String expectedMessage) {
        Promise returnPromise = this.pmmlMarshallerService.getDocumentMetadata(pmmlFile, pmmlFileContent);
        Assert.assertNotNull((Object)returnPromise);
        returnPromise.then(i -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        }).catch_(error -> {
            Assert.assertEquals((Object)expectedMessage, (Object)error);
            return this.promises.resolve();
        });
    }
}

