/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import com.google.gwt.core.client.GWT;
import elemental2.promise.Promise;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.client.marshaller.DMNMarshallerService;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramParsingException;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.kogito.api.editor.DiagramType;
import org.kie.workbench.common.stunner.kogito.api.editor.impl.KogitoDiagramResourceImpl;
import org.kie.workbench.common.stunner.kogito.client.service.AbstractKogitoClientDiagramService;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.client.promise.Promises;
import org.uberfire.commons.uuid.UUID;

@ApplicationScoped
public class DMNClientDiagramServiceImpl
extends AbstractKogitoClientDiagramService {
    private static final String ROOT = "default://master@system/stunner/diagrams";
    private FactoryManager factoryManager;
    private DefinitionManager definitionManager;
    private Promises promises;
    private DMNMarshallerService marshallerService;

    public DMNClientDiagramServiceImpl() {
    }

    @Inject
    public DMNClientDiagramServiceImpl(FactoryManager factoryManager, DefinitionManager definitionManager, Promises promises, DMNMarshallerService marshallerService) {
        this.factoryManager = factoryManager;
        this.definitionManager = definitionManager;
        this.promises = promises;
        this.marshallerService = marshallerService;
    }

    public void transform(String fileName, String xml, ServiceCallback<Diagram> callback) {
        if (Objects.isNull(xml) || xml.isEmpty()) {
            this.doNewDiagram(fileName, callback);
        } else {
            this.doTransformation(fileName, xml, callback);
        }
    }

    public String generateDefaultId() {
        return UUID.uuid();
    }

    public void transform(String xml, ServiceCallback<Diagram> callback) {
        this.transform(UUID.uuid(), xml, callback);
    }

    void doNewDiagram(String fileName, ServiceCallback<Diagram> callback) {
        try {
            String title = this.createDiagramTitleFromFilePath(fileName);
            Metadata metadata = this.buildMetadataInstance(fileName);
            String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
            String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
            Diagram diagram = this.factoryManager.newDiagram(title, defSetId, metadata);
            this.marshallerService.setOnDiagramLoad(callback);
            this.marshallerService.registerDiagramInstance(diagram, title, shapeSetId);
            callback.onSuccess((Object)diagram);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Metadata buildMetadataInstance(String fileName) {
        String defSetId = BindableAdapterUtils.getDefinitionSetId(DMNDefinitionSet.class);
        String shapeSetId = BindableAdapterUtils.getShapeSetId(DMNShapeSet.class);
        return new MetadataImpl.MetadataImplBuilder(defSetId, this.definitionManager).setRoot(PathFactory.newPath((String)".", (String)ROOT)).setPath(PathFactory.newPath((String)".", (String)("default://master@system/stunner/diagrams/" + fileName))).setShapeSetId(shapeSetId).build();
    }

    void doTransformation(String fileName, String xml, ServiceCallback<Diagram> callback) {
        Metadata metadata = this.buildMetadataInstance(fileName);
        try {
            this.marshallerService.unmarshall(metadata, xml, callback);
        }
        catch (Exception e) {
            GWT.log((String)e.getMessage(), (Throwable)e);
            callback.onError(new ClientRuntimeError((Throwable)new DiagramParsingException(metadata, xml)));
        }
    }

    public Promise<String> transform(KogitoDiagramResourceImpl resource) {
        if (resource.getType() != DiagramType.PROJECT_DIAGRAM) {
            return this.promises.resolve((Object)resource.xmlDiagram().orElse("Diagram type cannot be " + resource.getType()));
        }
        return this.promises.create((resolveOnchangeFn, rejectOnchangeFn) -> {
            Optional projectDiagram = resource.projectDiagram();
            if (projectDiagram.isPresent()) {
                this.marshallerService.marshall((Diagram)projectDiagram.get(), (ServiceCallback)new ServiceCallback<String>(){

                    public void onSuccess(String xml) {
                        resolveOnchangeFn.onInvoke((Object)xml);
                    }

                    public void onError(ClientRuntimeError e) {
                        rejectOnchangeFn.onInvoke((Object)e);
                    }
                });
            } else {
                rejectOnchangeFn.onInvoke((Object)new IllegalStateException("Diagram instance is not present"));
            }
        });
    }
}

