/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.uberfire.client.views.pfly.widgets.MomentTimeZone;

@ApplicationScoped
public class TimeZonesProvider {
    private final List<DMNSimpleTimeZone> TIME_ZONES = new ArrayList<DMNSimpleTimeZone>();

    public List<DMNSimpleTimeZone> getTimeZones() {
        if (this.TIME_ZONES.isEmpty()) {
            this.TIME_ZONES.addAll(this.buildTimeZones());
        }
        return this.TIME_ZONES;
    }

    private List<DMNSimpleTimeZone> buildTimeZones() {
        String[] names;
        ArrayList<DMNSimpleTimeZone> timeZones = new ArrayList<DMNSimpleTimeZone>();
        for (String name : names = this.getNames()) {
            double offset = this.getOffset(name);
            String offsetString = this.getOffsetString(name);
            timeZones.add(new DMNSimpleTimeZone(name, offset, offsetString));
        }
        return timeZones;
    }

    protected String[] getNames() {
        return MomentTimeZone.Builder.tz().names();
    }

    protected double getOffset(String timeZoneName) {
        return MomentTimeZone.Builder.tz((String)timeZoneName).utcOffset() / 60.0;
    }

    protected String getOffsetString(String timeZoneName) {
        return MomentTimeZone.Builder.tz((String)timeZoneName).format("Z");
    }
}

