/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.tour;

import javax.inject.Inject;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourBridge;
import org.appformer.kogito.bridge.client.guided.tour.GuidedTourObserver;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGraphObserver;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.observers.GuidedTourGridObserver;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.GraphElementsPositionProviderFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.providers.HTMLElementsPositionProviderFactory;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.tour.tutorial.DMNTutorial;

public class GuidedTourBridgeInitializer {
    private final GuidedTourGraphObserver graphObserver;
    private final GuidedTourGridObserver gridObserver;
    private final GraphElementsPositionProviderFactory graphPositionUtils;
    private final HTMLElementsPositionProviderFactory htmlPositionUtils;
    private final GuidedTourBridge monitorBridge;
    private final DMNTutorial dmnTutorial;

    @Inject
    public GuidedTourBridgeInitializer(GuidedTourGraphObserver graphObserver, GuidedTourGridObserver gridObserver, GraphElementsPositionProviderFactory graphPositionUtils, HTMLElementsPositionProviderFactory htmlPositionUtils, GuidedTourBridge monitorBridge, DMNTutorial dmnTutorial) {
        this.graphObserver = graphObserver;
        this.gridObserver = gridObserver;
        this.graphPositionUtils = graphPositionUtils;
        this.htmlPositionUtils = htmlPositionUtils;
        this.monitorBridge = monitorBridge;
        this.dmnTutorial = dmnTutorial;
    }

    public void init() {
        this.registerPositionProviders();
        this.registerObservers();
        this.registerTutorials();
    }

    private void registerPositionProviders() {
        this.monitorBridge.registerPositionProvider("DMNEditorGraph", this.graphPositionUtils.createPositionProvider());
        this.monitorBridge.registerPositionProvider("DMNEditorHTMLElement", this.htmlPositionUtils.createPositionProvider());
    }

    private void registerObservers() {
        this.monitorBridge.registerObserver((GuidedTourObserver)this.graphObserver);
        this.monitorBridge.registerObserver((GuidedTourObserver)this.gridObserver);
    }

    private void registerTutorials() {
        this.monitorBridge.registerTutorial(this.dmnTutorial.getTutorial());
    }
}

