/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.common.client.services;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.PMMLDocumentMetadata;
import org.kie.workbench.common.dmn.api.editors.included.PMMLIncludedModel;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.api.editors.types.DataObject;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.client.marshaller.included.DMNMarshallerImportsClientHelper;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELListParser;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELRangeParser;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.FEELSyntaxLightValidator;
import org.kie.workbench.common.dmn.webapp.kogito.common.client.services.TimeZonesProvider;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNClientServicesProxyImpl
implements DMNClientServicesProxy {
    private final DMNMarshallerImportsClientHelper kogitoImportsHelper;
    private final TimeZonesProvider timeZonesProvider;

    @Inject
    public DMNClientServicesProxyImpl(TimeZonesProvider timeZonesProvider, DMNMarshallerImportsClientHelper kogitoImportsHelper) {
        this.timeZonesProvider = timeZonesProvider;
        this.kogitoImportsHelper = kogitoImportsHelper;
    }

    public void loadModels(Path path, ServiceCallback<List<IncludedModel>> callback) {
        this.kogitoImportsHelper.loadModels(callback);
    }

    public void loadNodesFromImports(List<DMNIncludedModel> includedModels, ServiceCallback<List<DMNIncludedNode>> callback) {
        this.kogitoImportsHelper.loadNodesFromModels(includedModels, callback);
    }

    public void loadPMMLDocumentsFromImports(Path path, List<PMMLIncludedModel> includedModels, ServiceCallback<List<PMMLDocumentMetadata>> callback) {
        this.kogitoImportsHelper.getPMMLDocumentsMetadataFromFiles(includedModels, callback);
    }

    public void loadItemDefinitionsByNamespace(String modelName, String namespace, ServiceCallback<List<ItemDefinition>> callback) {
        this.kogitoImportsHelper.getImportedItemDefinitionsByNamespaceAsync(modelName, namespace, callback);
    }

    public void parseFEELList(String source, ServiceCallback<List<String>> callback) {
        callback.onSuccess(FEELListParser.parse(source));
    }

    public void parseRangeValue(String source, ServiceCallback<RangeValue> callback) {
        callback.onSuccess((Object)FEELRangeParser.parse(source));
    }

    public void isValidVariableName(String source, ServiceCallback<Boolean> callback) {
        callback.onSuccess((Object)FEELSyntaxLightValidator.isVariableNameValid(source));
    }

    public void getTimeZones(ServiceCallback<List<DMNSimpleTimeZone>> callback) {
        callback.onSuccess(this.timeZonesProvider.getTimeZones());
    }

    public void loadDataObjects(ServiceCallback<List<DataObject>> callback) {
        callback.onSuccess(Collections.emptyList());
    }
}

