/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.errai.ioc.client.IOCClientTestCase;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.DMNTest;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.DMNUnmarshallerTestBootstrap;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.MultipleAssertionsError;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.tests.EmptyDiagramTest;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.tests.InputDataTest;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;

public class DMNMarshallerKogitoUnmarshallerTest
extends IOCClientTestCase {
    private static final Logger LOGGER = Logger.getLogger(DMNMarshallerKogitoUnmarshallerTest.class.getName());

    public String getModuleName() {
        return "org.kie.workbench.common.dmn.webapp.kogito.marshaller.DMNMarshallerKogitoUnmarshallerTest";
    }

    public void testUnmarshall() {
        LOGGER.info("Entering testUnmarshall()...");
        DMNUnmarshallerTestBootstrap bootstrap = new DMNUnmarshallerTestBootstrap();
        bootstrap.bootstrap(() -> {
            KogitoClientDiagramService service = this.setupService();
            List<DMNTest> tests = this.getTests();
            HashMap errors = new HashMap();
            for (DMNTest test : tests) {
                try {
                    test.run(service);
                }
                catch (AssertionError ae) {
                    errors.put(test.getClass(), ae);
                }
                catch (Exception e) {
                    e.fillInStackTrace();
                    DMNMarshallerKogitoUnmarshallerTest.fail((String)e.getMessage());
                }
            }
            if (!errors.isEmpty()) {
                throw new MultipleAssertionsError(errors);
            }
        });
        LOGGER.info("Exiting testUnmarshall()...");
    }

    private List<DMNTest> getTests() {
        ArrayList<DMNTest> tests = new ArrayList<DMNTest>();
        tests.add(new EmptyDiagramTest());
        tests.add(new InputDataTest());
        return tests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KogitoClientDiagramService setupService() {
        LOGGER.info("Entering setupService()...");
        try {
            KogitoClientDiagramService service;
            SyncBeanDef beanDef = IOC.getBeanManager().lookupBean(KogitoClientDiagramService.class, new Annotation[0]);
            KogitoClientDiagramService kogitoClientDiagramService = service = (KogitoClientDiagramService)beanDef.getInstance();
            return kogitoClientDiagramService;
        }
        catch (Exception e) {
            e.fillInStackTrace();
            LOGGER.severe("Exception in setupService()...[" + e.getMessage() + "]");
        }
        finally {
            LOGGER.info("Exiting  setupService()...");
        }
        throw new IllegalStateException("Unable to instantiate KogitoClientDiagramService");
    }
}

