/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.ScriptInjector;
import com.google.gwt.user.client.Command;
import java.util.logging.Logger;
import jsinterop.base.JsPropertyMap;
import junit.framework.TestCase;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.MainJs;

public class DMNUnmarshallerTestBootstrap {
    private static final Logger LOGGER = Logger.getLogger(DMNUnmarshallerTestBootstrap.class.getName());

    public void bootstrap(Runnable tests) {
        LOGGER.info("Entering bootstrap()...");
        Step step8 = new Step(() -> {
            JsPropertyMap constructorsMap = MainJs.getConstructorsMap();
            MainJs.initializeJsInteropConstructors((JsPropertyMap)constructorsMap);
            tests.run();
        });
        Step step7 = new Step(() -> this.injectJavaScript("MainJs.js", step8));
        Step step6 = new Step(() -> this.injectJavaScript("KIE.js", step7));
        Step step5 = new Step(() -> this.injectJavaScript("DMN12.js", step6));
        Step step4 = new Step(() -> this.injectJavaScript("DMNDI12.js", step5));
        Step step3 = new Step(() -> this.injectJavaScript("DI.js", step4));
        Step step2 = new Step(() -> this.injectJavaScript("DC.js", step3));
        Step step1 = new Step(() -> this.injectJavaScript("Jsonix-all.js", step2));
        step1.onSuccess(null);
        LOGGER.info("Exiting bootstrap()...");
    }

    private void injectJavaScript(String uri, Step callback) {
        LOGGER.info("Attempting to inject: " + uri);
        ScriptInjector.fromUrl((String)uri).setWindow(ScriptInjector.TOP_WINDOW).setCallback((Callback)callback).inject();
    }

    private static class Step
    implements Callback<Void, Exception> {
        private final Command success;

        private Step(Command success) {
            this.success = success;
        }

        public void onFailure(Exception reason) {
            TestCase.fail((String)reason.getMessage());
        }

        public void onSuccess(Void result) {
            this.success.execute();
        }
    }
}

