/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.tests;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.DMNTest;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;

public abstract class BaseDMNTest
implements DMNTest {
    private static final Logger LOGGER = Logger.getLogger(BaseDMNTest.class.getName());

    protected void test(KogitoClientDiagramService service, String xml) {
        LOGGER.info("Running " + this.getTestName() + "...");
        try {
            service.transform(xml, (ServiceCallback)new ServiceCallback<Diagram>(){

                public void onSuccess(Diagram diagram) {
                    BaseDMNTest.this.logDiagramBasics(diagram);
                    BaseDMNTest.this.doAssertions(diagram);
                }

                public void onError(ClientRuntimeError error) {
                    LOGGER.info(error.getMessage());
                    TestCase.fail((String)error.getMessage());
                }
            });
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
    }

    protected void logDiagramBasics(Diagram diagram) {
        StringBuilder sb = new StringBuilder("\n");
        sb.append("-> Name: " + diagram.getName()).append("\n");
        sb.append("-> DefinitionSetId: " + diagram.getMetadata().getDefinitionSetId()).append("\n");
        sb.append("-> Nodes").append("\n");
        for (Object node : diagram.getGraph().nodes()) {
            sb.append("---> Node: " + node).append("\n");
        }
        LOGGER.info(sb.toString());
    }
}

