/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.tests;

import junit.framework.TestCase;
import org.kie.workbench.common.dmn.api.definition.model.DMNDiagram;
import org.kie.workbench.common.dmn.api.definition.model.InformationItemPrimary;
import org.kie.workbench.common.dmn.api.definition.model.InputData;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.resources.xml.UnmarshallerXMLTests;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.tests.BaseDMNTest;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.kogito.client.service.KogitoClientDiagramService;

public class InputDataTest
extends BaseDMNTest {
    private static final String INPUT_DATA_UUID = "_F60D7991-B11F-4760-87B7-4F105E52C611";
    private static final String INPUT_DATA_NAME = "InputData-1";
    private static final String INPUT_DATA_VARIABLE_UUID = "_CCCEBA75-272F-4EAE-9DDF-C1C923E62B1D";

    @Override
    public String getTestName() {
        return this.getClass().getName();
    }

    @Override
    public void run(KogitoClientDiagramService service) throws AssertionError {
        this.test(service, UnmarshallerXMLTests.INSTANCE.inputData().getText());
    }

    @Override
    public void doAssertions(Diagram diagram) throws AssertionError {
        TestCase.assertNotNull((Object)diagram);
        Node dmnDiagramNode = GraphUtils.getFirstNode((Graph)diagram.getGraph(), DMNDiagram.class);
        TestCase.assertNotNull((String)"DMNDiagram node is not null", (Object)dmnDiagramNode);
        TestCase.assertEquals((String)"DMNDiagram has one outgoing edge", (int)1, (int)dmnDiagramNode.getOutEdges().size());
        Node dmnInputDataNode = GraphUtils.getFirstNode((Graph)diagram.getGraph(), InputData.class);
        TestCase.assertNotNull((String)"InputData node is not null", (Object)dmnInputDataNode);
        TestCase.assertEquals((String)"InputData has one incoming edge", (int)1, (int)dmnInputDataNode.getInEdges().size());
        InputData inputData = (InputData)((Definition)dmnInputDataNode.getContent()).getDefinition();
        TestCase.assertEquals((String)"InputData UUID", (String)INPUT_DATA_UUID, (String)inputData.getId().getValue());
        TestCase.assertEquals((String)"InputData name", (String)INPUT_DATA_NAME, (String)inputData.getName().getValue());
        TestCase.assertEquals((String)"DMNDiagram is connected to InputData (source)", (String)dmnDiagramNode.getUUID(), (String)((Edge)dmnDiagramNode.getOutEdges().get(0)).getSourceNode().getUUID());
        TestCase.assertEquals((String)"DMNDiagram is connected to InputData (target)", (String)dmnInputDataNode.getUUID(), (String)((Edge)dmnDiagramNode.getOutEdges().get(0)).getTargetNode().getUUID());
        TestCase.assertEquals((String)"InputData is connected to DMNDiagram (source)", (String)dmnDiagramNode.getUUID(), (String)((Edge)dmnInputDataNode.getInEdges().get(0)).getSourceNode().getUUID());
        TestCase.assertEquals((String)"InputData is connected to DMNDiagram (target)", (String)dmnInputDataNode.getUUID(), (String)((Edge)dmnInputDataNode.getInEdges().get(0)).getTargetNode().getUUID());
        InformationItemPrimary variable = inputData.getVariable();
        TestCase.assertNotNull((String)"InputData variable is not null", (Object)variable);
        TestCase.assertEquals((String)"InputData variable UUID", (String)INPUT_DATA_VARIABLE_UUID, (String)variable.getId().getValue());
        TestCase.assertEquals((String)"InputData variable name", (String)"", (String)variable.getName().getValue());
        TestCase.assertEquals((String)"InputData width (DimensionSet)", (Object)100.0, (Object)inputData.getDimensionsSet().getWidth().getValue());
        TestCase.assertEquals((String)"InputData height (DimensionSet)", (Object)50.0, (Object)inputData.getDimensionsSet().getHeight().getValue());
        TestCase.assertEquals((String)"InputData fill colour (BackgroundSet)", (String)"#ffffff", (String)inputData.getBackgroundSet().getBgColour().getValue());
        TestCase.assertEquals((String)"InputData border colour (BackgroundSet)", (String)"#000000", (String)inputData.getBackgroundSet().getBorderColour().getValue());
        TestCase.assertEquals((String)"InputData font colour (FontSet)", (String)"#000000", (String)inputData.getFontSet().getFontColour().getValue());
        Definition inputDataDefinition = (Definition)dmnInputDataNode.getContent();
        TestCase.assertTrue((String)"InputData definition is instance of View", (boolean)(inputDataDefinition instanceof View));
        View inputDataView = (View)inputDataDefinition;
        TestCase.assertEquals((String)"InputData width (View)", (Object)100.0, (Object)inputDataView.getBounds().getWidth());
        TestCase.assertEquals((String)"InputData height (View)", (Object)50.0, (Object)inputDataView.getBounds().getHeight());
        TestCase.assertEquals((String)"InputData x (View)", (Object)252.0, (Object)inputDataView.getBounds().getX());
        TestCase.assertEquals((String)"InputData y (View)", (Object)150.0, (Object)inputDataView.getBounds().getY());
    }
}

