
package org.kie.workbench.common.dmn.webapp.kogito.marshaller.js.model.dmn12;

import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JSIName;
import org.kie.workbench.common.dmn.webapp.kogito.marshaller.mapper.JsUtils;


/**
 * JSInterop adapter for <code>TTextAnnotation</code>
 * 
 */
@JsType(namespace = JsPackage.GLOBAL, name = "JsInterop__ConstructorAPI__DMN12__org__kie__workbench__common__dmn__webapp__kogito__marshaller__js__model__dmn12__JSITTextAnnotation", isNative = true)
public class JSITTextAnnotation
    extends JSITArtifact
{

    @JsOverlay
    public final static String TYPE = "DMN12.TTextAnnotation";

    @JsOverlay
    public static boolean instanceOf(final Object instance) {
        return TYPE.equals(JsUtils.getTypeName(instance));
    }

    /**
     * Getter for specific <code>JSIName</code>
     * 
     * @return
     *     Getter for specific <code>JSIName</code>
     */
    @JsOverlay
    public static JSIName getJSIName() {
        JSIName toReturn = new JSIName();
        toReturn.setNamespaceURI("http://www.omg.org/spec/DMN/20180521/MODEL/");
        toReturn.setLocalPart("tTextAnnotation");
        toReturn.setPrefix("");
        toReturn.setKey("{http://www.omg.org/spec/DMN/20180521/MODEL/}");
        toReturn.setString("{http://www.omg.org/spec/DMN/20180521/MODEL/}tTextAnnotation");
        return toReturn;
    }

    /**
     * Native getter for <b>TYPE_NAME</b>
     * 
     * @return
     *     The <b>TYPE_NAME</b> JSON property
     */
    @JsProperty(name = "TYPE_NAME")
    public native String getTYPE_NAME();

    /**
     * Native getter for <b>text</b>
     * 
     * @return
     *     The <b>text</b> JSON property
     */
    @JsProperty(name = "text")
    public native String getText();

    /**
     * Setter for <b>text</b>
     * 
     * @param textParam
     *      <b>text</b> to set.
     */
    @JsProperty(name = "text")
    public final native void setText(String textParam);

    /**
     * Native getter for <b>textFormat</b>
     * 
     * @return
     *     The <b>textFormat</b> JSON property
     */
    @JsProperty(name = "textFormat")
    public native String getTextFormat();

    /**
     * Setter for <b>textFormat</b>
     * 
     * @param textFormatParam
     *      <b>textFormat</b> to set.
     */
    @JsProperty(name = "textFormat")
    public final native void setTextFormat(String textFormatParam);

}
