/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.builders;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpression;
import gwt.jsonix.marshallers.xjc.plugin.utils.BuilderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import org.apache.commons.lang3.StringUtils;
import org.hisrc.jsonix.settings.LogLevelSetting;

public class ContainerObjectBuilder {
    private ContainerObjectBuilder() {
    }

    public static List<JDefinedClass> generateJSInteropContainerObjects(Map<String, String> packageModuleMap, Map<String, Map<String, JClass>> topLevelElementsMap, JCodeModel jCodeModel) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, "Generating  JSInterop containers objects ...");
        ArrayList<JDefinedClass> toReturn = new ArrayList<JDefinedClass>();
        for (Map.Entry<String, String> entry : packageModuleMap.entrySet()) {
            ContainerObjectBuilder.addPackageContainerObject(entry.getKey(), entry.getValue(), jCodeModel, topLevelElementsMap.get(entry.getKey()), toReturn);
        }
        return toReturn;
    }

    protected static void addPackageContainerObject(String packageName, String containerObjectName, JCodeModel jCodeModel, Map<String, JClass> topLevelElementsMap, List<JDefinedClass> toPopulate) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Looking for JSInterop container object %1$s for package %2$s ...", containerObjectName, packageName));
        toPopulate.add(ContainerObjectBuilder.getContainerObject(packageName, containerObjectName, jCodeModel, topLevelElementsMap));
    }

    protected static JDefinedClass getContainerObject(String packageName, String containerObjectName, JCodeModel jCodeModel, Map<String, JClass> topLevelElementsMap) throws JClassAlreadyExistsException {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Creating  JSInterop container object %1$s for package %2$s ...", containerObjectName, packageName));
        JDefinedClass toReturn = jCodeModel._class(packageName + "." + containerObjectName);
        toReturn.annotate(jCodeModel.ref(JsType.class)).param("isNative", true).param("namespace", (JExpression)jCodeModel.ref(JsPackage.class).staticRef("GLOBAL"));
        JDocComment comment = toReturn.javadoc();
        comment.append((Object)("JSInterop container for <code>" + packageName + "</code>"));
        ContainerObjectBuilder.addNameProperty(jCodeModel, toReturn);
        for (Map.Entry<String, JClass> topLevelElementEntry : topLevelElementsMap.entrySet()) {
            ContainerObjectBuilder.addElementProperty(jCodeModel, toReturn, topLevelElementEntry.getKey(), topLevelElementEntry.getValue());
        }
        return toReturn;
    }

    protected static void addNameProperty(JCodeModel jCodeModel, JDefinedClass toPopulate) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add getName property to object %1$s.%2$s ...", toPopulate._package().name(), toPopulate.name()));
        JClass parameterRef = jCodeModel.ref(String.class);
        BuilderUtils.addNativeGetter(jCodeModel, toPopulate, parameterRef, "Name", "name");
    }

    protected static void addElementProperty(JCodeModel jCodeModel, JDefinedClass toPopulate, String elementName, JClass elementClass) {
        BuilderUtils.log(LogLevelSetting.DEBUG, String.format("Add %1$s accessors to object %2$s.%3$s ...", elementName, toPopulate._package().name(), toPopulate.name()));
        String publicName = StringUtils.capitalize((String)elementName);
        BuilderUtils.addNativeGetter(jCodeModel, toPopulate, elementClass, publicName, elementName);
        BuilderUtils.addNativeSetter(jCodeModel, toPopulate, elementClass, publicName, elementName);
    }
}

