/*
 * Decompiled with CFR 0.152.
 */
package gwt.jsonix.marshallers.xjc.plugin.utils;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.FileCodeWriter;
import com.sun.codemodel.writer.FilterCodeWriter;
import com.sun.tools.xjc.model.Model;
import gwt.jsonix.marshallers.xjc.plugin.GWTSettings;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsProperty;
import org.hisrc.jsonix.settings.LogLevelSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderUtils {
    public static final String CALLBACKS = "callbacks";
    public static final String MAIN_JS = "MainJs";
    public static final String MARSHALL_CALLBACK = "MarshallCallback";
    public static final String UNMARSHALL_CALLBACK = "UnmarshallCallback";

    private BuilderUtils() {
    }

    public static CodeWriter createCodeWriter(Model model, GWTSettings settings) throws IOException {
        try {
            File targetDir = settings.getJsinteropDirectory() != null ? settings.getJsinteropDirectory() : model.options.targetDir;
            return new FileCodeWriter(targetDir, model.options.readOnly, model.options.encoding);
        }
        catch (IOException e) {
            throw new IOException("Failed to FileCodeWriter", e);
        }
    }

    public static void writeJSInteropCode(JCodeModel jCodeModel, CodeWriter baseCodeWriter) throws IOException {
        BuilderUtils.log(LogLevelSetting.DEBUG, MessageFormat.format("Writing JSInterop with [{0}].", baseCodeWriter));
        try {
            FilterCodeWriter codeWriter = new FilterCodeWriter(baseCodeWriter);
            jCodeModel.build((CodeWriter)codeWriter);
        }
        catch (IOException e) {
            throw new IOException("Unable to write files: " + e.getMessage(), e);
        }
    }

    public static JAnnotationUse addListGetterForJsArrayLike(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        String getterMethodName = "get" + publicPropertyName;
        int mod = 9;
        JClass listPropertyRef = jCodeModel.ref(List.class).narrow(propertyRef);
        JMethod getterMethod = jDefinedClass.method(9, (JType)listPropertyRef, getterMethodName);
        JDocComment getterComment = getterMethod.javadoc();
        JCommentPart getterCommentReturnPart = getterComment.addReturn();
        JBlock body = getterMethod.body();
        getterComment.append((Object)("READ-ONLY getter for <b>" + privatePropertyName + "</b> as a {@link List}"));
        getterCommentReturnPart.add((Object)("The <b>" + privatePropertyName + "</b> mapped as a {@link List}"));
        BuilderUtils.addCheckNullForJsArrayLike(publicPropertyName, jsUtilsClass, body);
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        JInvocation getUnwrappedElementsArrayInvocation = jsUtilsClass.staticInvoke("getUnwrappedElementsArray").arg((JExpression)nativeGetterInvocation);
        JInvocation list = jsUtilsClass.staticInvoke("toList").arg((JExpression)getUnwrappedElementsArrayInvocation);
        body._return((JExpression)list);
        return getterMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addListGetterForArray(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JType propertyRef, String publicPropertyName, String privatePropertyName) {
        String getterMethodName = "get" + publicPropertyName;
        int mod = 9;
        JClass listPropertyRef = jCodeModel.ref(List.class).narrow(propertyRef);
        JClass arrayListField = jCodeModel.ref(ArrayList.class).narrow(propertyRef);
        JMethod getterMethod = jDefinedClass.method(9, (JType)listPropertyRef, getterMethodName);
        JDocComment getterComment = getterMethod.javadoc();
        JCommentPart getterCommentReturnPart = getterComment.addReturn();
        JBlock body = getterMethod.body();
        getterComment.append((Object)("READ-ONLY getter for <b>" + privatePropertyName + "</b> as a {@link List}"));
        getterCommentReturnPart.add((Object)("The <b>" + privatePropertyName + "</b> mapped as a {@link List}"));
        BuilderUtils.addCheckNullForArray(publicPropertyName, propertyRef, body);
        JVar originalArray = body.decl((JType)propertyRef.array(), "original", (JExpression)JExpr.invoke((String)("getNative" + publicPropertyName)));
        JVar listToReturn = body.decl(8, (JType)listPropertyRef, "toReturn", (JExpression)JExpr._new((JClass)arrayListField));
        JForLoop loop = body._for();
        JVar iVar = loop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        loop.test(iVar.lt((JExpression)JExpr.ref((JExpression)originalArray, (String)"length")));
        loop.update(iVar.incr());
        JBlock loopBody = loop.body();
        loopBody.add((JStatement)listToReturn.invoke("add").arg((JExpression)originalArray.component((JExpression)iVar)));
        body._return((JExpression)listToReturn);
        return getterMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addListSetterForJsArrayLike(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        String setterMethodName = "set" + publicPropertyName;
        int mod = 9;
        JClass listPropertyRef = jCodeModel.ref(List.class).narrow(propertyRef);
        JMethod setterMethod = jDefinedClass.method(9, Void.TYPE, setterMethodName);
        String parameterName = privatePropertyName + "Param";
        JVar setterParam = setterMethod.param((JType)listPropertyRef, parameterName);
        JDocComment setterComment = setterMethod.javadoc();
        JCommentPart setterCommentReturnPart = setterComment.addParam(parameterName);
        JBlock body = setterMethod.body();
        setterComment.append((Object)("Setter for <b>" + privatePropertyName + "</b> as a {@link List}"));
        setterCommentReturnPart.add((Object)("The <b>" + privatePropertyName + "</b> mapped as a {@link List}"));
        JInvocation toJsArrayLikeInvocation = jsUtilsClass.staticInvoke("toJsArrayLike").arg((JExpression)setterParam);
        body.invoke("setNative" + publicPropertyName).arg((JExpression)toJsArrayLikeInvocation);
        return setterMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addListSetterForArray(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JType propertyRef, String publicPropertyName, String privatePropertyName) {
        String setterMethodName = "set" + publicPropertyName;
        int mod = 9;
        JClass listPropertyRef = jCodeModel.ref(List.class).narrow(propertyRef);
        JMethod setterMethod = jDefinedClass.method(9, Void.TYPE, setterMethodName);
        String parameterName = privatePropertyName + "Param";
        JVar setterParam = setterMethod.param((JType)listPropertyRef, parameterName);
        JDocComment setterComment = setterMethod.javadoc();
        JCommentPart setterCommentReturnPart = setterComment.addParam(parameterName);
        JBlock body = setterMethod.body();
        setterComment.append((Object)("Setter for <b>" + privatePropertyName + "</b> as a {@link List}"));
        setterCommentReturnPart.add((Object)("The <b>" + privatePropertyName + "</b> mapped as a {@link List}"));
        JArray jsArray = JExpr.newArray((JType)propertyRef, (JExpression)setterParam.invoke("size"));
        JVar toSetArray = body.decl((JType)propertyRef.array(), "toSet", (JExpression)jsArray);
        JForLoop loop = body._for();
        JVar iVar = loop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        loop.test(iVar.lt((JExpression)toSetArray.ref("length")));
        loop.update(iVar.incr());
        JBlock loopBody = loop.body();
        loopBody.assign((JAssignmentTarget)toSetArray.component((JExpression)iVar), (JExpression)setterParam.invoke("get").arg((JExpression)iVar));
        body.invoke("setNative" + publicPropertyName).arg((JExpression)toSetArray);
        return setterMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addAddMethodForJsArrayLike(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        JVar elementParam;
        JType typeParam;
        String getterMethodName = "add" + publicPropertyName;
        int mod = 9;
        JMethod addMethod = jDefinedClass.method(9, Void.TYPE, getterMethodName);
        if (!propertyRef.unboxify().isPrimitive()) {
            typeParam = addMethod.generify("D", propertyRef);
            elementParam = addMethod.param(8, typeParam, "element");
        } else {
            typeParam = propertyRef.unboxify();
            elementParam = addMethod.param(8, typeParam, "element");
        }
        JDocComment addMethodComment = addMethod.javadoc();
        JBlock body = addMethod.body();
        addMethodComment.append((Object)("Appends the specified element to the end of <b>" + privatePropertyName + "</b>"));
        addMethodComment.addParam("element to be appended to <b>" + privatePropertyName + "</b>");
        BuilderUtils.addCheckNullForJsArrayLike(publicPropertyName, jsUtilsClass, body);
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        JInvocation getAddInvocation = jsUtilsClass.staticInvoke("add").arg((JExpression)nativeGetterInvocation).arg((JExpression)elementParam);
        body.add((JStatement)getAddInvocation);
        return addMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addAddMethodForArray(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JType propertyRef, String publicPropertyName, String privatePropertyName) {
        String getterMethodName = "add" + publicPropertyName;
        int mod = 9;
        JMethod addMethod = jDefinedClass.method(9, Void.TYPE, getterMethodName);
        JVar elementParam = addMethod.param(8, propertyRef, "element");
        JDocComment addMethodComment = addMethod.javadoc();
        JBlock body = addMethod.body();
        addMethodComment.append((Object)("Appends the specified element to the end of <b>" + privatePropertyName + "</b>"));
        addMethodComment.addParam("element to be appended to <b>" + privatePropertyName + "</b>");
        BuilderUtils.addCheckNullForArray(publicPropertyName, propertyRef, body);
        JVar originalArray = body.decl((JType)propertyRef.array(), "original", (JExpression)JExpr.invoke((String)("getNative" + publicPropertyName)));
        JArray jsArray = JExpr.newArray((JType)propertyRef, (JExpression)originalArray.ref("length").plus(JExpr.lit((int)1)));
        JVar toSetArray = body.decl((JType)propertyRef.array(), "toSet", (JExpression)jsArray);
        body.staticInvoke(jCodeModel.ref(System.class), "arraycopy").arg((JExpression)originalArray).arg(JExpr.lit((int)0)).arg((JExpression)toSetArray).arg(JExpr.lit((int)0)).arg((JExpression)originalArray.ref("length"));
        body.assign((JAssignmentTarget)toSetArray.component(toSetArray.ref("length").minus(JExpr.lit((int)1))), (JExpression)elementParam);
        body.invoke("setNative" + publicPropertyName).arg((JExpression)toSetArray);
        return addMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addAddAllMethodForJsArrayLike(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        String addAllMethodName = "addAll" + publicPropertyName;
        int mod = 9;
        JMethod addAllMethod = jDefinedClass.method(9, Void.TYPE, addAllMethodName);
        JDocComment addAllComment = addAllMethod.javadoc();
        JBlock body = addAllMethod.body();
        addAllComment.append((Object)("Iterates over the specified collection of elements, and adds each element returned by the iterator\nto the end of <b>" + privatePropertyName + "</b>"));
        addAllComment.addParam("elements to be appended to <b>" + privatePropertyName + "</b>");
        BuilderUtils.addCheckNullForJsArrayLike(publicPropertyName, jsUtilsClass, body);
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        if (!propertyRef.unboxify().isPrimitive()) {
            JTypeVar typeParam = addAllMethod.generify("D", propertyRef);
            JVar elementsParam = addAllMethod.varParam((JType)typeParam, "elements");
            elementsParam.mods().setFinal(true);
            JInvocation getAddAllInvocation = jsUtilsClass.staticInvoke("addAll").arg((JExpression)nativeGetterInvocation).arg((JExpression)elementsParam);
            body.add((JStatement)getAddAllInvocation);
        } else {
            JType typeParam = propertyRef.unboxify();
            JVar elementsParam = addAllMethod.varParam(typeParam, "elements");
            elementsParam.mods().setFinal(true);
            JForLoop loop = body._for();
            JVar iVar = loop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
            loop.test(iVar.lt((JExpression)JExpr.ref((JExpression)elementsParam, (String)"length")));
            loop.update(iVar.incr());
            JBlock loopBody = loop.body();
            loopBody.invoke("add" + publicPropertyName).arg((JExpression)elementsParam.component((JExpression)iVar));
        }
        return addAllMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addAddAllMethodForArray(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JType propertyRef, String publicPropertyName, String privatePropertyName) {
        String addAllMethodName = "addAll" + publicPropertyName;
        int mod = 9;
        JMethod addAllMethod = jDefinedClass.method(9, Void.TYPE, addAllMethodName);
        JDocComment addAllComment = addAllMethod.javadoc();
        JBlock body = addAllMethod.body();
        addAllComment.append((Object)("Iterates over the specified collection of elements, and adds each element returned by the iterator\nto the end of <b>" + privatePropertyName + "</b>"));
        addAllComment.addParam("elements to be appended to <b>" + privatePropertyName + "</b>");
        JType typeParam = propertyRef.unboxify();
        JVar elementsParam = addAllMethod.varParam(typeParam, "elements");
        elementsParam.mods().setFinal(true);
        JForLoop loop = body._for();
        JVar iVar = loop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        loop.test(iVar.lt((JExpression)JExpr.ref((JExpression)elementsParam, (String)"length")));
        loop.update(iVar.incr());
        JBlock loopBody = loop.body();
        loopBody.invoke("add" + publicPropertyName).arg((JExpression)elementsParam.component((JExpression)iVar));
        return addAllMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addRemoveMethodForJsArrayLike(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JDefinedClass jsUtilsClass, String publicPropertyName, String privatePropertyName) {
        String removeMethodName = "remove" + publicPropertyName;
        int mod = 9;
        JMethod addMethod = jDefinedClass.method(9, Void.TYPE, removeMethodName);
        JVar indexParam = addMethod.param(8, Integer.TYPE, "index");
        JDocComment removeComment = addMethod.javadoc();
        JBlock body = addMethod.body();
        removeComment.append((Object)("Removes the element at the specified position in the <b>" + privatePropertyName + "</b>"));
        removeComment.addParam("index of the element to be removed");
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        JInvocation getAddInvocation = jsUtilsClass.staticInvoke("remove").arg((JExpression)nativeGetterInvocation).arg((JExpression)indexParam);
        body.add((JStatement)getAddInvocation);
        return addMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JAnnotationUse addRemoveMethodForArray(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JType propertyRef, String publicPropertyName, String privatePropertyName) {
        String removeMethodName = "remove" + publicPropertyName;
        int mod = 9;
        JMethod addMethod = jDefinedClass.method(9, Void.TYPE, removeMethodName);
        JVar indexParam = addMethod.param(8, Integer.TYPE, "index");
        JDocComment removeComment = addMethod.javadoc();
        JBlock body = addMethod.body();
        removeComment.append((Object)("Removes the element at the specified position in the <b>" + privatePropertyName + "</b>"));
        removeComment.addParam("index of the element to be removed");
        BuilderUtils.addCheckNullForArray(publicPropertyName, propertyRef, body);
        JVar originalArray = body.decl((JType)propertyRef.array(), "original", (JExpression)JExpr.invoke((String)("getNative" + publicPropertyName)));
        body._if(originalArray.ref("length").lt(JExpr.lit((int)1)).cor(indexParam.lt(JExpr.lit((int)0)).cor(indexParam.gte((JExpression)originalArray.ref("length")))))._then()._return();
        JArray jsArray = JExpr.newArray((JType)propertyRef, (JExpression)originalArray.ref("length").minus(JExpr.lit((int)1)));
        JVar toSetArray = body.decl((JType)propertyRef.array(), "toSet", (JExpression)jsArray);
        JVar counter = body.decl((JType)jCodeModel.INT, "counter", JExpr.lit((int)0));
        JForLoop loop = body._for();
        JVar iVar = loop.init((JType)jCodeModel.INT, "i", JExpr.lit((int)0));
        loop.test(iVar.lt((JExpression)originalArray.ref("length")));
        loop.update(iVar.incr());
        JBlock loopBody = loop.body();
        loopBody._if(iVar.eq((JExpression)indexParam))._then()._continue();
        loopBody.assign((JAssignmentTarget)toSetArray.component((JExpression)counter), (JExpression)originalArray.component((JExpression)iVar));
        loopBody.assignPlus((JAssignmentTarget)counter, JExpr.lit((int)1));
        body.invoke("setNative" + publicPropertyName).arg((JExpression)toSetArray);
        return addMethod.annotate(jCodeModel.ref(JsOverlay.class));
    }

    public static JMethod addNativeGetter(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        String getterMethodName = "get" + publicPropertyName;
        int mod = 65;
        JMethod getterMethod = jDefinedClass.method(mod, (JType)propertyRef, getterMethodName);
        JDocComment getterComment = getterMethod.javadoc();
        String commentString = "Native getter for <b>" + privatePropertyName + "</b>";
        getterComment.append((Object)commentString);
        JCommentPart getterCommentReturnPart = getterComment.addReturn();
        commentString = "The <b>" + privatePropertyName + "</b> JSON property";
        getterCommentReturnPart.add((Object)commentString);
        getterMethod.annotate(jCodeModel.ref(JsProperty.class)).param("name", privatePropertyName);
        return getterMethod;
    }

    public static JAnnotationUse addNativeSetter(JCodeModel jCodeModel, JDefinedClass jDefinedClass, JClass propertyRef, String publicPropertyName, String privatePropertyName) {
        String setterMethodName = "set" + publicPropertyName;
        int mod = 73;
        JMethod setterMethod = jDefinedClass.method(mod, Void.TYPE, setterMethodName);
        String parameterName = privatePropertyName + "Param";
        setterMethod.param((JType)propertyRef, parameterName);
        JDocComment setterComment = setterMethod.javadoc();
        String commentString = "Setter for <b>" + privatePropertyName + "</b>";
        setterComment.append((Object)commentString);
        JCommentPart setterCommentParameterPart = setterComment.addParam(parameterName);
        commentString = " <b>" + privatePropertyName + "</b> to set.";
        setterCommentParameterPart.add((Object)commentString);
        return setterMethod.annotate(jCodeModel.ref(JsProperty.class)).param("name", privatePropertyName);
    }

    public static Optional<JClass> getJavaRef(String originalClassName, JCodeModel jCodeModel, boolean toUnbox) {
        Optional<JClass> toReturn = Optional.empty();
        try {
            Class<?> aClass = Class.forName(originalClassName);
            if (originalClassName.startsWith("java")) {
                JClass ref = jCodeModel.ref(aClass);
                if (!ref.isPrimitive() && toUnbox) {
                    ref = jCodeModel.ref(ref.unboxify().fullName());
                }
                toReturn = Optional.ofNullable(ref);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return toReturn;
    }

    public static void log(LogLevelSetting level, String message, Throwable e) {
        switch (level) {
            case TRACE: {
                BuilderUtils.getLog().trace(message, e);
                break;
            }
            case INFO: {
                BuilderUtils.getLog().info(message, e);
                break;
            }
            case WARN: {
                BuilderUtils.getLog().warn(message, e);
                break;
            }
            case DEBUG: {
                BuilderUtils.getLog().debug(message, e);
                break;
            }
            case ERROR: {
                BuilderUtils.getLog().error(message, e);
            }
        }
    }

    public static void log(LogLevelSetting level, String message) {
        switch (level) {
            case TRACE: {
                BuilderUtils.getLog().trace(message);
                break;
            }
            case INFO: {
                BuilderUtils.getLog().info(message);
                break;
            }
            case WARN: {
                BuilderUtils.getLog().warn(message);
                break;
            }
            case DEBUG: {
                BuilderUtils.getLog().debug(message);
                break;
            }
            case ERROR: {
                BuilderUtils.getLog().error(message);
            }
        }
    }

    private static void addCheckNullForJsArrayLike(String publicPropertyName, JDefinedClass jsUtilsClass, JBlock body) {
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        JInvocation nativeSetterInvocation = JExpr.invoke((String)("setNative" + publicPropertyName));
        JExpression isNullNativeArray = nativeGetterInvocation.eq(JExpr._null());
        JInvocation nativeArray = jsUtilsClass.staticInvoke("getNativeArray");
        body._if(isNullNativeArray)._then().add((JStatement)nativeSetterInvocation.arg((JExpression)nativeArray));
    }

    private static void addCheckNullForArray(String publicPropertyName, JType propertyRef, JBlock body) {
        JInvocation nativeGetterInvocation = JExpr.invoke((String)("getNative" + publicPropertyName));
        JInvocation nativeSetterInvocation = JExpr.invoke((String)("setNative" + publicPropertyName));
        JExpression isNullNativeArray = nativeGetterInvocation.eq(JExpr._null());
        body._if(isNullNativeArray)._then().add((JStatement)nativeSetterInvocation.arg((JExpression)JExpr.newArray((JType)propertyRef)));
    }

    private static Logger getLog() {
        return LoggerFactory.getLogger((String)BuilderUtils.class.getName());
    }
}

