/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.jexl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.metawidget.inspector.commons.jexl.JexlXmlInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.ThreadUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlXmlInspector
extends BaseXmlInspector {
    private static final ThreadLocal<Object> LOCAL_TOINSPECT = ThreadUtils.newThreadLocal();
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = ThreadUtils.newThreadLocal();
    private static final Pattern PATTERN_BINDING = Pattern.compile("^\\$\\{(.*)\\}$");

    public JexlXmlInspector(JexlXmlInspectorConfig config) {
        super((BaseXmlInspectorConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element inspectAsDom(Object toInspect, String type, String ... names) {
        LOCAL_TOINSPECT.set(toInspect);
        try {
            Element element = super.inspectAsDom(toInspect, type, names);
            return element;
        }
        finally {
            LOCAL_CONTEXT.remove();
            LOCAL_TOINSPECT.remove();
        }
    }

    protected String getExtendsAttribute() {
        return "extends";
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        if ("property".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    protected Map<String, String> inspectAction(Element toInspect) {
        if ("action".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    protected JexlContext getContext() {
        JexlContext context = LOCAL_CONTEXT.get();
        if (context == null) {
            context = this.createContext(LOCAL_TOINSPECT.get());
            LOCAL_CONTEXT.set(context);
        }
        return context;
    }

    protected JexlContext createContext(Object toInspect) {
        JexlContext context = JexlHelper.createContext();
        Map contextMap = context.getVars();
        if (toInspect != null) {
            contextMap.put("this", toInspect);
        }
        return context;
    }

    private Map<String, String> inspect(Element toInspect) {
        Map attributes = XmlUtils.getAttributesAsMap((Node)toInspect);
        for (Map.Entry entry : CollectionUtils.newArrayList(attributes.entrySet())) {
            String value = (String)entry.getValue();
            Matcher matcher = PATTERN_BINDING.matcher(value);
            if (!matcher.matches()) continue;
            try {
                value = StringUtils.quietValueOf((Object)ExpressionFactory.createExpression((String)matcher.group(1)).evaluate(this.getContext()));
            }
            catch (Exception e) {
                throw InspectorException.newException((Throwable)e);
            }
            attributes.put(entry.getKey(), value);
        }
        return attributes;
    }
}

