/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.commons.jexl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.metawidget.inspectionresultprocessor.commons.jexl.JexlInspectionResultProcessorConfig;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessorException;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlInspectionResultProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private static final String THIS_ATTRIBUTE = "this";
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = new ThreadLocal();
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\$\\{([^\\}]+)\\}");
    private PropertyStyle mInjectThis;

    public JexlInspectionResultProcessor() {
        this(new JexlInspectionResultProcessorConfig());
    }

    public JexlInspectionResultProcessor(JexlInspectionResultProcessorConfig config) {
        this.mInjectThis = config.getInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element processInspectionResultAsDom(Element inspectionResult, M metawidget, Object toInspect, String type, String ... names) {
        try {
            LOCAL_CONTEXT.set(this.createContext(metawidget));
            Element element = super.processInspectionResultAsDom(inspectionResult, metawidget, toInspect, type, names);
            return element;
        }
        finally {
            LOCAL_CONTEXT.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEntity(Map<String, String> attributes, M metawidget, Object toInspect, String type, String ... names) {
        JexlContext context = LOCAL_CONTEXT.get();
        Map vars = context.getVars();
        try {
            vars.put(THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, true, names).getValue());
            super.processEntity(attributes, metawidget, toInspect, type, names);
        }
        finally {
            vars.remove(THIS_ATTRIBUTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTraits(Element entity, M metawidget, Object toInspect, String type, String ... names) {
        JexlContext context = LOCAL_CONTEXT.get();
        Map vars = context.getVars();
        try {
            vars.put(THIS_ATTRIBUTE, this.mInjectThis.traverse(toInspect, type, false, names).getValue());
            super.processTraits(entity, metawidget, toInspect, type, names);
        }
        finally {
            vars.remove(THIS_ATTRIBUTE);
        }
    }

    protected void processAttributes(Map<String, String> attributes, M metawidget) {
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            Matcher matcher = PATTERN_EXPRESSION.matcher(value);
            int matchOffset = 0;
            while (matcher.find()) {
                String expression = matcher.group(1);
                try {
                    String valueObjectAsString;
                    Object valueObject = ExpressionFactory.createExpression((String)expression).evaluate(LOCAL_CONTEXT.get());
                    if (valueObject == null) {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = null;
                            break;
                        }
                        valueObjectAsString = "";
                    } else {
                        if (matcher.start() == 0 && matcher.end() == value.length()) {
                            value = String.valueOf(valueObject);
                            break;
                        }
                        valueObjectAsString = String.valueOf(valueObject);
                    }
                    value = new StringBuffer(value).replace(matcher.start() + matchOffset, matcher.end() + matchOffset, valueObjectAsString).toString();
                    matchOffset += valueObjectAsString.length() - (matcher.end() - matcher.start());
                }
                catch (Exception e) {
                    throw InspectionResultProcessorException.newException((String)("Unable to evaluate " + value), (Throwable)e);
                }
            }
            attributes.put(key, value);
        }
    }

    protected JexlContext createContext(M metawidget) {
        return JexlHelper.createContext();
    }
}

