/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacesUtils {
    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("((#|\\$)\\{)(.*)(\\})");
    private static final String EXPRESSION_START = "#{";
    private static final String EXPRESSION_END = "}";

    public static boolean isExpression(String value) {
        return PATTERN_EXPRESSION.matcher(value).matches();
    }

    public static String unwrapExpression(String value) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        return matcher.group(3);
    }

    public static String wrapExpression(String value) {
        if (FacesUtils.isExpression(value)) {
            return value;
        }
        return new StringBuffer().append(EXPRESSION_START).append(FacesUtils.unwrapExpression(value)).append(EXPRESSION_END).toString();
    }

    public static void render(FacesContext context, UIComponent component) throws IOException {
        if (component == null || !component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            FacesUtils.renderChildren(context, component);
        }
        component.encodeEnd(context);
    }

    public static boolean isJsf2() {
        try {
            Class.forName("javax.faces.event.PreRenderViewEvent");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isPartialStateSavingDisabled() {
        FacesContext context = FacesContext.getCurrentInstance();
        return "false".equals(context.getExternalContext().getInitParameter("javax.faces.PARTIAL_STATE_SAVING"));
    }

    public static <T extends UIComponent> T createComponent(String componentType, String rendererType) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (FacesUtils.isJsf2()) {
            return (T)application.createComponent(context, componentType, rendererType);
        }
        return (T)application.createComponent(componentType);
    }

    private static void renderChildren(FacesContext context, UIComponent component) throws IOException {
        for (UIComponent componentChild : component.getChildren()) {
            FacesUtils.render(context, componentChild);
        }
    }

    private FacesUtils() {
    }
}

