/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlMessage;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.util.simple.SimpleLayoutUtils;

public abstract class HtmlLayoutRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent metawidgetComponent) throws IOException {
        UIMetawidget metawidget = (UIMetawidget)metawidgetComponent;
        metawidget.putClientProperty(HtmlLayoutRenderer.class, null);
        super.encodeBegin(context, (UIComponent)metawidget);
        State state = this.getState((UIComponent)metawidget);
        state.labelSuffix = metawidget.getParameter("labelSuffix");
        String inlineMessagesParameter = metawidget.getParameter("inlineMessages");
        if (inlineMessagesParameter != null) {
            state.inlineMessages = Boolean.valueOf(inlineMessagesParameter);
        }
        state.messageStyle = metawidget.getParameter("messageStyle");
        state.messageStyleClass = metawidget.getParameter("messageStyleClass");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String getLabelText(UIComponent componentNeedingLabel) {
        Map metadataAttributes = (Map)componentNeedingLabel.getAttributes().get("metawidget-metadata");
        return ((UIMetawidget)componentNeedingLabel.getParent()).getLabelString(metadataAttributes);
    }

    protected boolean layoutLabel(FacesContext context, UIComponent metawidget, UIComponent componentNeedingLabel) throws IOException {
        if (componentNeedingLabel instanceof UICommand) {
            return false;
        }
        String labelText = this.getLabelText(componentNeedingLabel);
        if (!SimpleLayoutUtils.needsLabel((String)labelText, null)) {
            return false;
        }
        HtmlOutputText componentLabel = (HtmlOutputText)context.getApplication().createComponent("javax.faces.HtmlOutputText");
        State state = this.getState(metawidget);
        if (state.labelSuffix == null) {
            state.labelSuffix = ":";
        }
        if (labelText.indexOf("#{") != -1) {
            componentLabel.setValueBinding("value", context.getApplication().createValueBinding(labelText + state.labelSuffix));
        } else {
            componentLabel.setValue((Object)(labelText + state.labelSuffix));
        }
        FacesUtils.render(context, (UIComponent)componentLabel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChild(FacesContext context, UIComponent metawidget, UIComponent childComponent) throws IOException {
        FacesUtils.render(context, childComponent);
        if (childComponent instanceof HtmlInputHidden) {
            return;
        }
        String messageFor = childComponent.getId();
        if (childComponent instanceof UIMetawidget) {
            UIComponent childOfChild = null;
            Iterator i$ = childComponent.getChildren().iterator();
            while (i$.hasNext()) {
                UIComponent child = (UIComponent)i$.next();
                if (child instanceof UIParameter) continue;
                if (childOfChild != null) {
                    return;
                }
                childOfChild = child;
            }
            if (childOfChild == null) {
                return;
            }
            messageFor = childOfChild.getId();
        } else if (!(childComponent instanceof UIInput)) {
            return;
        }
        Map metadataAttributes = (Map)childComponent.getAttributes().get("metawidget-metadata");
        if (metadataAttributes != null && ("true".equals(metadataAttributes.get("read-only")) || ((UIMetawidget)metawidget).isReadOnly())) {
            return;
        }
        State state = this.getState(metawidget);
        if (!state.inlineMessages) {
            return;
        }
        List children = metawidget.getChildren();
        HtmlMessage inlineMessage = this.createInlineMessage(context, metawidget, messageFor);
        try {
            children.add(inlineMessage);
            FacesUtils.render(context, (UIComponent)inlineMessage);
        }
        finally {
            children.remove(inlineMessage);
        }
    }

    protected HtmlMessage createInlineMessage(FacesContext context, UIComponent metawidget, String messageFor) {
        HtmlMessage message = (HtmlMessage)context.getApplication().createComponent("javax.faces.HtmlMessage");
        message.setId(context.getViewRoot().createUniqueId());
        message.setFor(messageFor);
        State state = this.getState(metawidget);
        if (!"".equals(state.messageStyle)) {
            message.setStyle(state.messageStyle);
        }
        if (!"".equals(state.messageStyleClass)) {
            message.setStyleClass(state.messageStyleClass);
        }
        return message;
    }

    protected void writeStyleAndClass(UIMetawidget metawidget, ResponseWriter writer, String style) throws IOException {
        String styleClassParameter;
        String styleParameter = metawidget.getParameter(style + "Style");
        if (styleParameter != null) {
            writer.writeAttribute("style", (Object)styleParameter, "style");
        }
        if ((styleClassParameter = metawidget.getParameter(style + "StyleClass")) != null) {
            writer.writeAttribute("class", (Object)styleClassParameter, "class");
        }
    }

    private State getState(UIComponent metawidget) {
        State state = (State)((UIMetawidget)metawidget).getClientProperty(HtmlLayoutRenderer.class);
        if (state == null) {
            state = new State();
            ((UIMetawidget)metawidget).putClientProperty(HtmlLayoutRenderer.class, state);
        }
        return state;
    }

    static class State {
        boolean inlineMessages = true;
        String messageStyle;
        String messageStyleClass;
        String labelSuffix;

        State() {
        }
    }
}

