/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesInspectorConfig;
import org.metawidget.inspector.faces.UiFacesAjax;
import org.metawidget.inspector.faces.UiFacesAttribute;
import org.metawidget.inspector.faces.UiFacesAttributes;
import org.metawidget.inspector.faces.UiFacesComponent;
import org.metawidget.inspector.faces.UiFacesConverter;
import org.metawidget.inspector.faces.UiFacesDateTimeConverter;
import org.metawidget.inspector.faces.UiFacesLookup;
import org.metawidget.inspector.faces.UiFacesNumberConverter;
import org.metawidget.inspector.faces.UiFacesSuggest;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.InspectorUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesInspector
extends BaseObjectInspector {
    private boolean mInjectThis;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesAttributes;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesAttribute;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesLookup;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesSuggest;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesComponent;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesAjax;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesConverter;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesNumberConverter;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$UiFacesDateTimeConverter;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$FacesInspectorConfig;

    public FacesInspector() {
        this(new FacesInspectorConfig());
    }

    public FacesInspector(FacesInspectorConfig config) {
        super((BaseObjectInspectorConfig)config);
        this.mInjectThis = config.isInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> inspectParent(Object parentToInspect, Property propertyInParent) throws Exception {
        try {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("this", parentToInspect);
            }
            Map map = super.inspectParent(parentToInspect, propertyInParent);
            return map;
        }
        finally {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove("this");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inspect(Object toInspect, Class<?> classToInspect, Element toAddTo) throws Exception {
        try {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("this", toInspect);
            }
            super.inspect(toInspect, classToInspect, toAddTo);
        }
        finally {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove("this");
            }
        }
    }

    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        UiFacesAttributes facesAttributes = (UiFacesAttributes)trait.getAnnotation(class$org$metawidget$inspector$faces$UiFacesAttributes == null ? (class$org$metawidget$inspector$faces$UiFacesAttributes = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesAttributes")) : class$org$metawidget$inspector$faces$UiFacesAttributes);
        UiFacesAttribute facesAttribute = (UiFacesAttribute)trait.getAnnotation(class$org$metawidget$inspector$faces$UiFacesAttribute == null ? (class$org$metawidget$inspector$faces$UiFacesAttribute = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesAttribute")) : class$org$metawidget$inspector$faces$UiFacesAttribute);
        if (facesAttributes == null && facesAttribute == null) {
            return null;
        }
        if (facesAttribute != null) {
            this.evaluateAndPutExpression(attributes, facesAttribute);
        }
        if (facesAttributes != null) {
            for (UiFacesAttribute nestedFacesAttribute : facesAttributes.value()) {
                this.evaluateAndPutExpression(attributes, nestedFacesAttribute);
            }
        }
        return attributes;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        UiFacesDateTimeConverter dateTimeConverter;
        UiFacesNumberConverter numberConverter;
        UiFacesConverter converter;
        UiFacesAjax ajax;
        UiFacesComponent component;
        UiFacesSuggest facesSuggest;
        HashMap attributes = CollectionUtils.newHashMap();
        UiFacesLookup facesLookup = (UiFacesLookup)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesLookup == null ? (class$org$metawidget$inspector$faces$UiFacesLookup = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesLookup")) : class$org$metawidget$inspector$faces$UiFacesLookup);
        if (facesLookup != null) {
            this.putExpression(attributes, "faces-lookup", facesLookup.value());
        }
        if ((facesSuggest = (UiFacesSuggest)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesSuggest == null ? (class$org$metawidget$inspector$faces$UiFacesSuggest = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesSuggest")) : class$org$metawidget$inspector$faces$UiFacesSuggest)) != null) {
            this.putExpression(attributes, "faces-suggest", facesSuggest.value());
        }
        if ((component = (UiFacesComponent)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesComponent == null ? (class$org$metawidget$inspector$faces$UiFacesComponent = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesComponent")) : class$org$metawidget$inspector$faces$UiFacesComponent)) != null) {
            attributes.put("faces-component", component.value());
        }
        if ((ajax = (UiFacesAjax)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesAjax == null ? (class$org$metawidget$inspector$faces$UiFacesAjax = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesAjax")) : class$org$metawidget$inspector$faces$UiFacesAjax)) != null) {
            attributes.put("faces-ajax-event", ajax.event());
            this.putExpression(attributes, "faces-ajax-action", ajax.action());
        }
        if ((converter = (UiFacesConverter)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesConverter == null ? (class$org$metawidget$inspector$faces$UiFacesConverter = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesConverter")) : class$org$metawidget$inspector$faces$UiFacesConverter)) != null) {
            attributes.put("faces-converter-id", converter.value());
        }
        if ((numberConverter = (UiFacesNumberConverter)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesNumberConverter == null ? (class$org$metawidget$inspector$faces$UiFacesNumberConverter = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesNumberConverter")) : class$org$metawidget$inspector$faces$UiFacesNumberConverter)) != null) {
            if (!"".equals(numberConverter.currencyCode())) {
                attributes.put("currency-code", numberConverter.currencyCode());
            }
            if (!"".equals(numberConverter.currencySymbol())) {
                attributes.put("currency-symbol", numberConverter.currencySymbol());
            }
            if (numberConverter.groupingUsed()) {
                attributes.put("number-uses-grouping-separators", "true");
            }
            if (numberConverter.minIntegerDigits() != -1) {
                attributes.put("minimum-integer-digits", String.valueOf(numberConverter.minIntegerDigits()));
            }
            if (numberConverter.maxIntegerDigits() != -1) {
                attributes.put("maximum-integer-digits", String.valueOf(numberConverter.maxIntegerDigits()));
            }
            if (numberConverter.minFractionDigits() != -1) {
                attributes.put("minimum-fractional-digits", String.valueOf(numberConverter.minFractionDigits()));
            }
            if (numberConverter.maxFractionDigits() != -1) {
                attributes.put("maximum-fractional-digits", String.valueOf(numberConverter.maxFractionDigits()));
            }
            if (!"".equals(numberConverter.locale())) {
                attributes.put("locale", numberConverter.locale());
            }
            if (!"".equals(numberConverter.pattern())) {
                attributes.put("number-pattern", numberConverter.pattern());
            }
            if (!"".equals(numberConverter.type())) {
                attributes.put("number-type", numberConverter.type());
            }
        }
        if ((dateTimeConverter = (UiFacesDateTimeConverter)property.getAnnotation(class$org$metawidget$inspector$faces$UiFacesDateTimeConverter == null ? (class$org$metawidget$inspector$faces$UiFacesDateTimeConverter = FacesInspector.class$("org.metawidget.inspector.faces.UiFacesDateTimeConverter")) : class$org$metawidget$inspector$faces$UiFacesDateTimeConverter)) != null) {
            if (!"".equals(dateTimeConverter.dateStyle())) {
                attributes.put("date-style", dateTimeConverter.dateStyle());
            }
            if (!"".equals(dateTimeConverter.locale())) {
                attributes.put("locale", dateTimeConverter.locale());
            }
            if (!"".equals(dateTimeConverter.pattern())) {
                attributes.put("datetime-pattern", dateTimeConverter.pattern());
            }
            if (!"".equals(dateTimeConverter.timeStyle())) {
                attributes.put("time-style", dateTimeConverter.timeStyle());
            }
            if (!"".equals(dateTimeConverter.timeZone())) {
                attributes.put("time-zone", dateTimeConverter.timeZone());
            }
            if (!"".equals(dateTimeConverter.type())) {
                attributes.put("datetime-type", dateTimeConverter.type());
            }
        }
        return attributes;
    }

    private void putExpression(Map<String, String> attributes, String attributeName, String expression) {
        if ("".equals(expression)) {
            return;
        }
        if (!FacesUtils.isExpression(expression)) {
            throw InspectorException.newException((String)new StringBuffer().append("Expression '").append(expression).append("' (for '").append(attributeName).append("') is not of the form #{...}").toString());
        }
        if (this.mInjectThis && FacesUtils.unwrapExpression(expression).startsWith("this.")) {
            throw InspectorException.newException((String)new StringBuffer().append("Expression '").append(expression).append("' (for '").append(attributeName).append("') must not contain 'this' (see Metawidget Reference Guide)").toString());
        }
        attributes.put(attributeName, expression);
    }

    private void evaluateAndPutExpression(Map<String, String> attributes, UiFacesAttribute facesAttribute) {
        Object value;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw InspectorException.newException((String)"FacesContext not available to FacesInspector");
        }
        String expression = facesAttribute.expression();
        if ("".equals(expression)) {
            return;
        }
        if (!FacesUtils.isExpression(expression)) {
            throw InspectorException.newException((String)new StringBuffer().append("Expression '").append(expression).append("' is not of the form #{...}").toString());
        }
        if (!this.mInjectThis && FacesUtils.unwrapExpression(expression).startsWith("this.")) {
            throw InspectorException.newException((String)new StringBuffer().append("Expression for '").append(expression).append("' contains 'this', but ").append((class$org$metawidget$inspector$faces$FacesInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesInspectorConfig = FacesInspector.class$("org.metawidget.inspector.faces.FacesInspectorConfig")) : class$org$metawidget$inspector$faces$FacesInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
        }
        try {
            value = context.getApplication().createValueBinding(expression).getValue(context);
        }
        catch (Exception e) {
            throw InspectorException.newException((String)new StringBuffer().append("Unable to getValue of ").append(expression).toString(), (Throwable)e);
        }
        if (value == null) {
            return;
        }
        for (String attributeName : facesAttribute.name()) {
            InspectorUtils.putAttributeValue(attributes, (String)attributeName, (Object)value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

