/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.faces;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.inspector.faces.FacesXmlInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesXmlInspector
extends BaseXmlInspector {
    private boolean mInjectThis;
    static /* synthetic */ Class class$org$metawidget$inspector$faces$FacesXmlInspectorConfig;

    public FacesXmlInspector(FacesXmlInspectorConfig config) {
        super((BaseXmlInspectorConfig)config);
        this.mInjectThis = config.isInjectThis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element inspectAsDom(Object toInspect, String type, String[] names) {
        try {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().put("this", toInspect);
            }
            Element element = super.inspectAsDom(toInspect, type, names);
            return element;
        }
        finally {
            if (this.mInjectThis) {
                FacesContext.getCurrentInstance().getExternalContext().getRequestMap().remove("this");
            }
        }
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        if ("property".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    protected Map<String, String> inspectAction(Element toInspect) {
        if ("action".equals(toInspect.getNodeName())) {
            return this.inspect(toInspect);
        }
        return null;
    }

    private Map<String, String> inspect(Element toInspect) {
        Map attributes = XmlUtils.getAttributesAsMap((Node)toInspect);
        for (Map.Entry entry : CollectionUtils.newArrayList(attributes.entrySet())) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if ("faces-lookup".equals(key) || "faces-suggest".equals(key) || "faces-expression".equals(key) || "faces-ajax-action".equals(key)) {
                if (!this.mInjectThis || !FacesUtils.unwrapExpression(value).startsWith("this.")) continue;
                throw InspectorException.newException((String)new StringBuffer().append("Expression '").append(value).append("' (for '").append(key).append("') must not contain 'this' (see Metawidget Reference Guide)").toString());
            }
            if (!FacesUtils.isExpression(value)) continue;
            FacesContext context = FacesContext.getCurrentInstance();
            if (context == null) {
                throw InspectorException.newException((String)"FacesContext not available to FacesXmlInspector");
            }
            if (!this.mInjectThis && FacesUtils.unwrapExpression(value).startsWith("this.")) {
                throw InspectorException.newException((String)new StringBuffer().append("Expression for '").append(value).append("' contains 'this', but ").append((class$org$metawidget$inspector$faces$FacesXmlInspectorConfig == null ? (class$org$metawidget$inspector$faces$FacesXmlInspectorConfig = FacesXmlInspector.class$("org.metawidget.inspector.faces.FacesXmlInspectorConfig")) : class$org$metawidget$inspector$faces$FacesXmlInspectorConfig).getSimpleName()).append(".setInjectThis is 'false'").toString());
            }
            try {
                value = StringUtils.quietValueOf((Object)context.getApplication().createValueBinding(value).getValue(context));
            }
            catch (Exception e) {
                throw InspectorException.newException((String)new StringBuffer().append("Unable to getValue of ").append(value).toString(), (Throwable)e);
            }
            attributes.put(key, value);
        }
        return attributes;
    }

    public /* synthetic */ Object inspectAsDom(Object x0, String x1, String[] x2) {
        return this.inspectAsDom(x0, x1, x2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

