/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.widgetprocessor;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableIdProcessor
implements AdvancedWidgetProcessor<UIComponent, UIMetawidget> {
    public void onStartBuild(UIMetawidget metawidget) {
        metawidget.putClientProperty(ReadableIdProcessor.class, null);
    }

    public UIComponent processWidget(UIComponent component, String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if (component.getId() != null) {
            return component;
        }
        if ("action".equals(elementName)) {
            MethodBinding methodBinding = ((ActionSource)component).getAction();
            if (methodBinding != null) {
                this.setUniqueId(component, methodBinding.getExpressionString(), metawidget);
            } else {
                component.setId(FacesContext.getCurrentInstance().getViewRoot().createUniqueId());
            }
        } else {
            ValueBinding valueBinding = component.getValueBinding("value");
            if (valueBinding != null) {
                this.setUniqueId(component, valueBinding.getExpressionString(), metawidget);
            } else {
                component.setId(FacesContext.getCurrentInstance().getViewRoot().createUniqueId());
            }
        }
        return component;
    }

    public void onEndBuild(UIMetawidget metawidget) {
    }

    protected void setUniqueId(UIComponent component, String expressionString, UIMetawidget metawidget) {
        String id = StringUtils.camelCase((String)FacesUtils.unwrapExpression(expressionString), (char)'.');
        this.setUniqueId(id, component, metawidget);
    }

    protected void setUniqueId(String id, UIComponent component, UIMetawidget metawidget) {
        String originalId = id;
        if (component instanceof UIMetawidget) {
            originalId = originalId + "_Metawidget";
        }
        Set<String> clientIds = this.getClientIds(metawidget);
        String nonDuplicateId = originalId;
        int suffix = 1;
        while (!clientIds.add(nonDuplicateId)) {
            nonDuplicateId = originalId + '_' + ++suffix;
        }
        if (component instanceof UIStub) {
            List children = component.getChildren();
            if (!children.isEmpty()) {
                int childSuffix = 1;
                for (UIComponent childComponent : children) {
                    if (childComponent.getId() != null) continue;
                    if (childSuffix > 1) {
                        childComponent.setId(nonDuplicateId + '_' + childSuffix);
                    } else {
                        childComponent.setId(nonDuplicateId);
                    }
                    ++childSuffix;
                }
            }
            component.setId(FacesContext.getCurrentInstance().getViewRoot().createUniqueId());
            return;
        }
        component.setId(nonDuplicateId);
    }

    private Set<String> getClientIds(UIMetawidget metawidget) {
        Set clientIds = (Set)metawidget.getClientProperty(ReadableIdProcessor.class);
        if (clientIds == null) {
            clientIds = CollectionUtils.newHashSet();
            metawidget.putClientProperty(ReadableIdProcessor.class, clientIds);
            this.getClientIds((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), clientIds);
        }
        return clientIds;
    }

    private void getClientIds(UIComponent component, Set<String> clientIds) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent childComponent = (UIComponent)i.next();
            String id = childComponent.getId();
            if (id != null) {
                clientIds.add(id);
            }
            this.getClientIds(childComponent, clientIds);
        }
    }
}

