/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.widgetprocessor;

import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardValidatorProcessor
implements WidgetProcessor<UIComponent, UIMetawidget> {
    public UIComponent processWidget(UIComponent component, String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if (!(component instanceof EditableValueHolder)) {
            return component;
        }
        EditableValueHolder editableValueHolder = (EditableValueHolder)component;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        String minimumValue = attributes.get("minimum-value");
        String maximumValue = attributes.get("maximum-value");
        if (minimumValue != null || maximumValue != null) {
            DoubleRangeValidator validator;
            String type = attributes.get("actual-class");
            if (type == null) {
                type = attributes.get("type");
            }
            if (Double.TYPE.getName().equals(type) || Double.class.getName().equals(type)) {
                if (!this.hasExistingValidator(editableValueHolder, DoubleRangeValidator.class)) {
                    validator = (DoubleRangeValidator)application.createValidator("javax.faces.DoubleRange");
                    editableValueHolder.addValidator((Validator)validator);
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        validator.setMinimum(Double.parseDouble(minimumValue));
                    }
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        validator.setMaximum(Double.parseDouble(maximumValue));
                    }
                }
            } else if (!this.hasExistingValidator(editableValueHolder, LongRangeValidator.class)) {
                validator = (LongRangeValidator)application.createValidator("javax.faces.LongRange");
                editableValueHolder.addValidator((Validator)validator);
                if (minimumValue != null && !"".equals(minimumValue)) {
                    validator.setMinimum(Long.parseLong(minimumValue));
                }
                if (maximumValue != null && !"".equals(maximumValue)) {
                    validator.setMaximum(Long.parseLong(maximumValue));
                }
            }
        }
        String minimumLength = attributes.get("minimum-length");
        String maximumLength = attributes.get("maximum-length");
        if (!(minimumLength == null && maximumLength == null || this.hasExistingValidator(editableValueHolder, LengthValidator.class))) {
            LengthValidator validator = (LengthValidator)application.createValidator("javax.faces.Length");
            if (minimumLength != null && !"".equals(minimumLength)) {
                validator.setMinimum(Integer.parseInt(minimumLength));
            }
            if (maximumLength != null && !"".equals(maximumLength)) {
                validator.setMaximum(Integer.parseInt(maximumLength));
            }
            editableValueHolder.addValidator((Validator)validator);
        }
        return component;
    }

    private boolean hasExistingValidator(EditableValueHolder editableValueHolder, Class<? extends Validator> validatorClass) {
        Validator[] validators = editableValueHolder.getValidators();
        if (validators == null) {
            return false;
        }
        for (Validator validator : validators) {
            if (!validatorClass.isAssignableFrom(validator.getClass())) continue;
            return true;
        }
        return false;
    }
}

