/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.hibernate.HibernateInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInspector
extends BaseXmlInspector {
    private static final String HIBERNATE_CONFIGURATION_ELEMENT = "hibernate-configuration";
    private static final String HIBERNATE_MAPPING_ELEMENT = "hibernate-mapping";
    private static final InputStream[] EMPTY_INPUTSTREAM_ARRAY = new InputStream[0];
    private final boolean mHideIds;
    static /* synthetic */ Class class$java$lang$String;

    public HibernateInspector(HibernateInspectorConfig config) {
        super((BaseXmlInspectorConfig)config);
        this.mHideIds = config.isHideIds();
    }

    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "class";
    }

    protected String getExtendsAttribute() {
        return "extends";
    }

    protected Element getDocumentElement(ResourceResolver resolver, InputStream[] files) throws Exception {
        Document documentMaster = null;
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse((InputStream)file);
            if (!documentParsed.hasChildNodes()) continue;
            Element parsed = documentParsed.getDocumentElement();
            String nodeName = parsed.getNodeName();
            if (HIBERNATE_CONFIGURATION_ELEMENT.equals(nodeName)) {
                Element mapping = XmlUtils.getChildNamed((Element)documentParsed.getDocumentElement(), (String[])new String[]{"session-factory", "mapping"});
                ArrayList inputStreamList = CollectionUtils.newArrayList();
                while (mapping != null) {
                    inputStreamList.add(resolver.openResource(mapping.getAttribute("resource")));
                    mapping = XmlUtils.getSiblingNamed((Element)mapping, (String)"mapping");
                }
                parsed = this.getDocumentElement(resolver, inputStreamList.toArray(EMPTY_INPUTSTREAM_ARRAY));
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = parsed.getOwnerDocument();
                    continue;
                }
            } else if (HIBERNATE_MAPPING_ELEMENT.equals(nodeName)) {
                this.preprocessDocument(documentParsed);
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = documentParsed;
                    continue;
                }
            } else {
                throw InspectorException.newException((String)new StringBuffer().append("Expected an XML document starting with 'hibernate-configuration' or 'hibernate-mapping', but got '").append(nodeName).append("'").toString());
            }
            XmlUtils.combineElements((Element)documentMaster.getDocumentElement(), (Element)parsed, (String)this.getTopLevelTypeAttribute(), (String)this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
        Element root = document.getDocumentElement();
        String packagePrefix = root.getAttribute("package");
        if (packagePrefix != null && !"".equals(packagePrefix)) {
            packagePrefix = new StringBuffer().append(packagePrefix).append('.').toString();
            NodeList children = root.getChildNodes();
            String topLevelAttribute = this.getTopLevelTypeAttribute();
            String extendsAttribute = this.getExtendsAttribute();
            int length = children.getLength();
            for (int loop = 0; loop < length; ++loop) {
                String extendsClass;
                Node node = children.item(loop);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                String name = element.getAttribute(topLevelAttribute);
                if (name != null && !"".equals(name) && name.indexOf(46) == -1) {
                    element.setAttribute(topLevelAttribute, new StringBuffer().append(packagePrefix).append(name).toString());
                }
                if ((extendsClass = element.getAttribute(extendsAttribute)) != null && !"".equals(extendsClass) && extendsClass.indexOf(46) == -1) {
                    element.setAttribute(extendsAttribute, new StringBuffer().append(packagePrefix).append(extendsClass).toString());
                }
                this.prependPackageToClassAttribute(element, packagePrefix);
            }
        }
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        Element withClass;
        String typeAttribute;
        HashMap attributes = CollectionUtils.newHashMap();
        attributes.put("name", toInspect.getAttribute("name"));
        String type = toInspect.getAttribute("type");
        if ("clob".equals(type)) {
            attributes.put("type", (class$java$lang$String == null ? (class$java$lang$String = HibernateInspector.class$("java.lang.String")) : class$java$lang$String).getName());
            attributes.put("large", "true");
        }
        if (toInspect.hasAttribute(typeAttribute = this.getTypeAttribute())) {
            attributes.put("type", toInspect.getAttribute(typeAttribute));
        }
        if ("true".equals(toInspect.getAttribute("not-null"))) {
            attributes.put("required", "true");
        }
        if (toInspect.hasAttribute("length")) {
            attributes.put("maximum-length", toInspect.getAttribute("length"));
        }
        String nodeName = toInspect.getNodeName();
        if (this.mHideIds && "id".equals(nodeName)) {
            attributes.put("hidden", "true");
        }
        if (("bag".equals(nodeName) || "list".equals(nodeName) || "set".equals(nodeName)) && (withClass = XmlUtils.getChildWithAttribute((Element)toInspect, (String)typeAttribute)) != null) {
            attributes.put("parameterized-type", withClass.getAttribute(typeAttribute));
        }
        return attributes;
    }

    private void prependPackageToClassAttribute(Element element, String packagePrefix) {
        NodeList children = element.getChildNodes();
        String typeAttribute = this.getTypeAttribute();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node node = children.item(loop);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String clazz = child.getAttribute(typeAttribute);
            if (clazz != null && !"".equals(clazz) && clazz.indexOf(46) == -1) {
                child.setAttribute(typeAttribute, new StringBuffer().append(packagePrefix).append(clazz).toString());
            }
            this.prependPackageToClassAttribute(child, packagePrefix);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

