/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.hibernate.HibernateInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInspector
extends BaseXmlInspector {
    private static final String HIBERNATE_CONFIGURATION_ELEMENT = "hibernate-configuration";
    private static final String HIBERNATE_MAPPING_ELEMENT = "hibernate-mapping";
    private static final InputStream[] EMPTY_INPUTSTREAM_ARRAY = new InputStream[0];
    private static final String PROPERTY_REF_ATTRIBUTE = "property-ref";
    private final boolean mHideIds;

    public HibernateInspector(HibernateInspectorConfig config) {
        super((BaseXmlInspectorConfig)config);
        this.mHideIds = config.isHideIds();
    }

    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "class";
    }

    protected String getExtendsAttribute() {
        return "extends";
    }

    protected Element getDocumentElement(ResourceResolver resolver, InputStream ... files) throws Exception {
        Document documentMaster = null;
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse((InputStream)file);
            if (!documentParsed.hasChildNodes()) continue;
            Element parsed = documentParsed.getDocumentElement();
            String nodeName = parsed.getNodeName();
            if (HIBERNATE_CONFIGURATION_ELEMENT.equals(nodeName)) {
                Element mapping = XmlUtils.getChildNamed((Element)documentParsed.getDocumentElement(), (String[])new String[]{"session-factory", "mapping"});
                ArrayList inputStreamList = CollectionUtils.newArrayList();
                while (mapping != null) {
                    inputStreamList.add(resolver.openResource(mapping.getAttribute("resource")));
                    mapping = XmlUtils.getSiblingNamed((Element)mapping, (String)"mapping");
                }
                parsed = this.getDocumentElement(resolver, inputStreamList.toArray(EMPTY_INPUTSTREAM_ARRAY));
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = parsed.getOwnerDocument();
                    continue;
                }
            } else if (HIBERNATE_MAPPING_ELEMENT.equals(nodeName)) {
                this.preprocessDocument(documentParsed);
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = documentParsed;
                    continue;
                }
            } else {
                throw InspectorException.newException((String)("Expected an XML document starting with 'hibernate-configuration' or 'hibernate-mapping', but got '" + nodeName + "'"));
            }
            XmlUtils.combineElements((Element)documentMaster.getDocumentElement(), (Element)parsed, (String)this.getTopLevelTypeAttribute(), (String)this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
        Element root = document.getDocumentElement();
        String packagePrefix = root.getAttribute("package");
        if (packagePrefix != null && !"".equals(packagePrefix)) {
            packagePrefix = packagePrefix + '.';
            String topLevelAttribute = this.getTopLevelTypeAttribute();
            String extendsAttribute = this.getExtendsAttribute();
            Element child = XmlUtils.getFirstChildElement((Element)root);
            while (child != null) {
                String extendsClass;
                String name = child.getAttribute(topLevelAttribute);
                if (name != null && !"".equals(name) && name.indexOf(46) == -1) {
                    child.setAttribute(topLevelAttribute, packagePrefix + name);
                }
                if ((extendsClass = child.getAttribute(extendsAttribute)) != null && !"".equals(extendsClass) && extendsClass.indexOf(46) == -1) {
                    child.setAttribute(extendsAttribute, packagePrefix + extendsClass);
                }
                this.prependPackageToClassAttribute(child, packagePrefix);
                child = XmlUtils.getNextSiblingElement((Element)child);
            }
        }
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        Element withClass;
        String typeAttribute;
        HashMap attributes = CollectionUtils.newHashMap();
        String name = toInspect.getAttribute("name");
        if ("".equals(name)) {
            return null;
        }
        attributes.put("name", name);
        String type = toInspect.getAttribute("type");
        if ("clob".equals(type)) {
            attributes.put("type", String.class.getName());
            attributes.put("large", "true");
        }
        if (toInspect.hasAttribute(typeAttribute = this.getTypeAttribute())) {
            attributes.put("type", toInspect.getAttribute(typeAttribute));
        }
        this.inspectColumnAttributes(toInspect, attributes);
        Element columnElement = XmlUtils.getChildNamed((Element)toInspect, (String[])new String[]{"column"});
        if (columnElement != null) {
            this.inspectColumnAttributes(columnElement, attributes);
        }
        String nodeName = toInspect.getNodeName();
        if (this.mHideIds && "id".equals(nodeName)) {
            attributes.put("hidden", "true");
        }
        if (("bag".equals(nodeName) || "list".equals(nodeName) || "set".equals(nodeName)) && (withClass = XmlUtils.getChildWithAttribute((Element)toInspect, (String)typeAttribute)) != null) {
            attributes.put("parameterized-type", withClass.getAttribute(typeAttribute));
            if (withClass.hasAttribute(PROPERTY_REF_ATTRIBUTE)) {
                attributes.put("inverse-relationship", withClass.getAttribute(PROPERTY_REF_ATTRIBUTE));
            }
        }
        if (toInspect.hasAttribute(PROPERTY_REF_ATTRIBUTE)) {
            attributes.put("inverse-relationship", toInspect.getAttribute(PROPERTY_REF_ATTRIBUTE));
        }
        return attributes;
    }

    private void inspectColumnAttributes(Element toInspect, Map<String, String> attributes) {
        if ("true".equals(toInspect.getAttribute("not-null"))) {
            attributes.put("required", "true");
        }
        if (toInspect.hasAttribute("length")) {
            attributes.put("maximum-length", toInspect.getAttribute("length"));
        }
    }

    private void prependPackageToClassAttribute(Element element, String packagePrefix) {
        NodeList children = element.getChildNodes();
        String typeAttribute = this.getTypeAttribute();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node node = children.item(loop);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String clazz = child.getAttribute(typeAttribute);
            if (clazz != null && !"".equals(clazz) && clazz.indexOf(46) == -1) {
                child.setAttribute(typeAttribute, packagePrefix + clazz);
            }
            this.prependPackageToClassAttribute(child, packagePrefix);
        }
    }
}

