// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace InspectionResultProcessors.
 */

metawidget.inspectionresultprocessor = metawidget.inspectionresultprocessor || {};
// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace Inspectors.
 */

metawidget.inspector = metawidget.inspector || {};

/**
 * @class Delegates inspection to one or more sub-inspectors, then combines the
 * resulting metadata using <tt>metawidget.util.combineInspectionResults</tt>.
 * <p>
 * The combining algorithm should be suitable for most use cases, but one
 * benefit of having a separate CompositeInspector is that developers can
 * replace it with their own version, with its own combining algorithm, if
 * required.
 * <p>
 * Note: the name <em>Composite</em>Inspector refers to the Composite design
 * pattern.
 */

metawidget.inspector.CompositeInspector = function( config ) {

	if ( ! ( this instanceof metawidget.inspector.CompositeInspector ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	var _inspectors;

	if ( config.inspectors !== undefined ) {
		_inspectors = config.inspectors.slice( 0 );
	} else {
		_inspectors = config.slice( 0 );
	}

	this.inspect = function( toInspect, type, names ) {

		var compositeInspectionResult = [];

		for ( var ins = 0, insLength = _inspectors.length; ins < insLength; ins++ ) {

			var inspectionResult;
			var inspector = _inspectors[ins];

			if ( inspector.inspect !== undefined ) {
				inspectionResult = inspector.inspect( toInspect, type, names );
			} else {
				inspectionResult = inspector( toInspect, type, names );
			}

			compositeInspectionResult = metawidget.util.combineInspectionResults( compositeInspectionResult, inspectionResult );
		}

		return compositeInspectionResult;
	};
};

/**
 * @class Inspects JavaScript objects for their property names and types.
 * <p>
 * In principal, ordering of property names within JavaScript objects is not
 * guaranteed. In practice, most browsers respect the original ordering that
 * properties were defined in. However you may want to precede
 * PropertyTypeInspector with a custom Inspector that imposes a defined
 * ordering.
 */

metawidget.inspector.PropertyTypeInspector = function() {

	if ( ! ( this instanceof metawidget.inspector.PropertyTypeInspector ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.inspector.PropertyTypeInspector.prototype.inspect = function( toInspect, type, names ) {

	// Traverse names

	toInspect = metawidget.util.traversePath( toInspect, names );

	// Inspect root node. Important if the Metawidget is
	// pointed directly at a primitive type

	var inspectionResult = [ {
		_root: 'true'
	} ];

	if ( names !== undefined && names.length > 0 ) {
		inspectionResult[0].name = names[names.length - 1];
	} else {
		
		// Nothing useful to return?
		
		if ( toInspect === undefined ) {
			return;
		}
	}

	if ( toInspect !== undefined ) {

		inspectionResult[0].type = typeof( toInspect );
		
		for ( var property in toInspect ) {
	
			var inspectedProperty = {};
			inspectedProperty.name = property;
	
			// Inspect the type of the property as best we can
	
			var value = toInspect[property];

			if ( value instanceof Array ) {
							
				inspectedProperty.type = 'array';

			} else if ( value instanceof Date ) {
	
				// typeof never returns 'date'
	
				inspectedProperty.type = 'date';
			} else {
	
				var typeOfProperty = typeof ( value );
	
				// type 'object' doesn't convey much, and can override a more
				// descriptive inspection result from a previous Inspector
	
				if ( typeOfProperty !== 'object' ) {
					inspectedProperty.type = typeOfProperty;
				}
			}
	
			inspectionResult.push( inspectedProperty );
		}
	}

	return inspectionResult;
};
// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace Layouts.
 */

metawidget.layout = metawidget.layout || {};

/**
 * @class Layout to simply output components one after another, with no labels
 *        and no structure. This Layout is suited to rendering single
 *        components, or for rendering components whose layout relies entirely
 *        on CSS.
 */

metawidget.layout.SimpleLayout = function() {

	if ( ! ( this instanceof metawidget.layout.SimpleLayout ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.layout.SimpleLayout.prototype.layoutWidget = function( widget, attributes, container, mw ) {

	if ( widget.tagName === 'STUB' && !metawidget.util.hasChildElements( widget ) ) {
		return;
	}

	container.appendChild( widget );
};

/**
 * @class Layout to arrange widgets using div tags.
 */

metawidget.layout.DivLayout = function( config ) {

	if ( ! ( this instanceof metawidget.layout.DivLayout ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	var _divStyleClasses = config !== undefined ? config.divStyleClasses : undefined;
	var _labelStyleClass = config !== undefined ? config.labelStyleClass : undefined;
	var _labelRequiredStyleClass = config !== undefined ? config.labelRequiredStyleClass : undefined;
	var _labelSuffix = config !== undefined && config.labelSuffix !== undefined ? config.labelSuffix : ':';

	this.layoutWidget = function( widget, attributes, container, mw ) {

		if ( widget.tagName === 'STUB' && !metawidget.util.hasChildElements( widget ) ) {
			return;
		}

		var outerDiv = document.createElement( 'div' );
		if ( _divStyleClasses !== undefined && _divStyleClasses[0] !== undefined ) {
			outerDiv.setAttribute( 'class', _divStyleClasses[0] );
		}

		// Label

		if ( attributes.name !== undefined || attributes.label !== undefined ) {

			var labelDiv = document.createElement( 'div' );
			if ( _divStyleClasses !== undefined && _divStyleClasses[1] !== undefined ) {
				labelDiv.setAttribute( 'class', _divStyleClasses[1] );
			}

			var label = document.createElement( 'label' );
			if ( widget.getAttribute( 'id' ) !== null ) {
				label.setAttribute( 'for', widget.getAttribute( 'id' ) );
			}

			if ( _labelStyleClass !== undefined ) {
				label.setAttribute( 'class', _labelStyleClass );
			}

			// For Twitter Bootstrap

			if ( _labelRequiredStyleClass !== undefined && attributes.readOnly !== 'true' && attributes.required === 'true' ) {
				var existingClass = label.getAttribute( 'class' );
				
				if ( existingClass === null ) {
					label.setAttribute( 'class', _labelRequiredStyleClass );
				} else {				
					label.setAttribute( 'class', existingClass + ' ' + _labelRequiredStyleClass );
				}
			}

			if ( attributes.label !== undefined ) {
				label.innerHTML = attributes.label + _labelSuffix;
			} else {
				label.innerHTML = metawidget.util.uncamelCase( attributes.name ) + _labelSuffix;
			}

			labelDiv.appendChild( label );
			outerDiv.appendChild( labelDiv );
		}

		// Widget

		var widgetDiv = document.createElement( 'div' );
		if ( _divStyleClasses !== undefined && _divStyleClasses[2] !== undefined ) {
			widgetDiv.setAttribute( 'class', _divStyleClasses[2] );
		}

		widgetDiv.appendChild( widget );
		outerDiv.appendChild( widgetDiv );

		container.appendChild( outerDiv );
	};
};

/**
 * @class Layout to arrange widgets in a table, with one column for the label
 *        and another for the widget.
 */

metawidget.layout.TableLayout = function( config ) {

	if ( ! ( this instanceof metawidget.layout.TableLayout ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	var _tableStyleClass = config !== undefined ? config.tableStyleClass : undefined;
	var _columnStyleClasses = config !== undefined ? config.columnStyleClasses : undefined;
	var _headerStyleClass = config !== undefined ? config.headerStyleClass : undefined;
	var _footerStyleClass = config !== undefined ? config.footerStyleClass : undefined;
	var _numberOfColumns = config !== undefined && config.numberOfColumns ? config.numberOfColumns : 1;
	var _currentColumn = 0;

	this.startContainerLayout = function( container, mw ) {

		var table = document.createElement( 'table' );
		if ( mw.path !== undefined ) {
			var id = metawidget.util.getId( {}, mw );
			if ( id !== undefined ) {
				table.setAttribute( 'id', 'table-' + id );
			}
		}

		if ( _tableStyleClass !== undefined ) {
			table.setAttribute( 'class', _tableStyleClass );
		}

		container.appendChild( table );

		// Facets

		if ( mw.overriddenNodes !== undefined ) {
			for ( var loop1 = 0, length1 = mw.overriddenNodes.length; loop1 < length1; loop1++ ) {

				var child = mw.overriddenNodes[loop1];

				if ( child.tagName !== 'FACET' ) {
					continue;
				}

				// thead or tfoot

				var parent;

				if ( child.getAttribute( 'name' ) === 'header' ) {
					parent = document.createElement( 'thead' );
				} else if ( child.getAttribute( 'name' ) === 'footer' ) {
					parent = document.createElement( 'tfoot' );
				} else {
					continue;
				}

				table.appendChild( parent );
				var tr = document.createElement( 'tr' );
				parent.appendChild( tr );
				var td = document.createElement( 'td' );
				td.setAttribute( 'colspan', _numberOfColumns * 2 );

				if ( child.getAttribute( 'name' ) === 'header' ) {
					if ( _headerStyleClass !== undefined ) {
						td.setAttribute( 'class', _headerStyleClass );
					}
				} else {
					if ( _footerStyleClass !== undefined ) {
						td.setAttribute( 'class', _footerStyleClass );
					}
				}

				tr.appendChild( td );

				// Append children, so as to unwrap the 'facet' tag

				while ( child.childNodes.length > 0 ) {
					td.appendChild( child.removeChild( child.childNodes[0] ) );
				}
			}
		}

		// tbody

		table.appendChild( document.createElement( 'tbody' ) );
	},

	this.layoutWidget = function( widget, attributes, container, mw ) {

		// Do not render empty stubs

		if ( widget.tagName === 'STUB' && !metawidget.util.hasChildElements( widget ) ) {
			return;
		}

		// Special support for large components

		var spanAllColumns = metawidget.util.isSpanAllColumns( attributes );

		if ( spanAllColumns === true && _currentColumn > 0 ) {
			_currentColumn = 0;
		}

		// Id

		var table = container.childNodes[container.childNodes.length - 1];
		var idPrefix = undefined;

		if ( attributes.name !== undefined ) {
			if ( table.hasAttribute( 'id' ) ) {
				idPrefix = table.getAttribute( 'id' );
			}

			if ( idPrefix !== undefined ) {
				if ( attributes._root !== 'true' ) {
					if ( idPrefix.charAt( idPrefix.length - 1 ) !== '-' ) {
						idPrefix += metawidget.util.capitalize( attributes.name );
					} else {
						idPrefix += attributes.name;
					}
				}
			} else {
				idPrefix = 'table-' + attributes.name;
			}
		}

		// Start column

		var tbody = table.childNodes[table.childNodes.length - 1];
		var tr;

		if ( _currentColumn === 0 ) {
			tr = document.createElement( 'tr' );
			if ( idPrefix !== undefined ) {
				tr.setAttribute( 'id', idPrefix + '-row' );
			}
			tbody.appendChild( tr );
		} else {
			tr = tbody.childNodes[tbody.childNodes.length - 1];
		}

		if ( attributes.name !== undefined || attributes.label !== undefined ) {
			// Label

			var th = document.createElement( 'th' );

			if ( idPrefix !== undefined ) {
				th.setAttribute( 'id', idPrefix + '-label-cell' );
			}

			if ( _columnStyleClasses !== undefined && _columnStyleClasses[0] !== undefined ) {
				th.setAttribute( 'class', _columnStyleClasses[0] );
			}

			var label = document.createElement( 'label' );

			if ( widget.hasAttribute( 'id' ) ) {
				label.setAttribute( 'for', widget.getAttribute( 'id' ) );
			}

			if ( idPrefix !== undefined ) {
				label.setAttribute( 'id', idPrefix + '-label' );
			}

			if ( attributes.label !== undefined ) {
				label.innerHTML = attributes.label + ':';
			} else {
				label.innerHTML = metawidget.util.uncamelCase( attributes.name ) + ':';
			}

			th.appendChild( label );
			tr.appendChild( th );
		}

		// Widget

		var td = document.createElement( 'td' );

		if ( idPrefix !== undefined ) {
			td.setAttribute( 'id', idPrefix + '-cell' );
		}

		if ( _columnStyleClasses !== undefined && _columnStyleClasses[1] !== undefined ) {
			td.setAttribute( 'class', _columnStyleClasses[1] );
		}

		if ( spanAllColumns === true ) {
			td.setAttribute( 'colspan', ( ( _numberOfColumns * 3 ) - 1 ) - tr.childNodes.length );
		} else if ( tr.childNodes.length < 1 ) {
			td.setAttribute( 'colspan', 2 - tr.childNodes.length );
		}

		td.appendChild( widget );
		tr.appendChild( td );

		// Error

		td = document.createElement( 'td' );

		if ( _columnStyleClasses !== undefined && _columnStyleClasses[2] !== undefined ) {
			td.setAttribute( 'class', _columnStyleClasses[2] );
		}

		if ( attributes.readOnly !== 'true' && attributes.required === 'true' ) {
			td.innerHTML = '*';
		}

		tr.appendChild( td );

		// Next column

		if ( spanAllColumns === true ) {
			_currentColumn = _numberOfColumns - 1;
		}

		_currentColumn = ( _currentColumn + 1 ) % _numberOfColumns;
	};
};

//
// LayoutDecorator
//

/**
 * Augment the given 'decorator' with methods suitable for making section
 * separator LayoutDecorators.
 * <p>
 * This includes implementing <tt>onStartBuild</tt>,
 * <tt>startContainerLayout</tt>, <tt>endContainerLayout</tt> and
 * <tt>onEndBuild</tt> methods.
 */

metawidget.layout._createSectionLayoutDecorator = function( config, decorator, decoratorName ) {

	var _delegate;

	if ( config.delegate !== undefined ) {
		_delegate = config.delegate;
	} else {
		_delegate = config;
	}

	/**
	 * Read-only getter.
	 * <p>
	 * Dangerous to add a public 'delegate' property, because can conflict with
	 * 'config.delegate'.
	 */

	decorator.getDelegate = function() {

		return _delegate;
	};

	decorator.onStartBuild = function( mw ) {

		if ( decorator.getDelegate().onStartBuild !== undefined ) {
			decorator.getDelegate().onStartBuild( mw );
		}
	};

	decorator.startContainerLayout = function( container, mw ) {

		container[decoratorName] = {};

		if ( decorator.getDelegate().startContainerLayout !== undefined ) {
			decorator.getDelegate().startContainerLayout( container, mw );
		}
	};

	decorator.endContainerLayout = function( container, mw ) {

		if ( decorator.getDelegate().endContainerLayout !== undefined ) {
			decorator.getDelegate().endContainerLayout( container, mw );
		}

		container[decoratorName] = {};
	};

	decorator.onEndBuild = function( mw ) {

		if ( decorator.getDelegate().onEndBuild !== undefined ) {
			decorator.getDelegate().onEndBuild( mw );
		}
	};
};

/**
 * Augment the given 'decorator' with methods suitable for making flat (as
 * opposed to nested) section separator LayoutDecorators.
 * <p>
 * This includes an implementation of the <tt>layoutWidget</tt> method and a
 * declaration of a <tt>addSectionWidget</tt> method.
 */

metawidget.layout.createFlatSectionLayoutDecorator = function( config, decorator, decoratorName ) {

	if ( this instanceof metawidget.layout.createFlatSectionLayoutDecorator ) {
		throw new Error( 'Function called as a Constructor' );
	}

	metawidget.layout._createSectionLayoutDecorator( config, decorator, decoratorName );

	decorator.layoutWidget = function( widget, attributes, container, mw ) {

		// If our delegate is itself a NestedSectionLayoutDecorator, strip
		// the section

		if ( decorator.getDelegate().nestedSectionLayoutDecorator === true ) {

			// Stay where we are?

			var section = metawidget.util.stripSection( attributes );

			if ( section === undefined || section === container[decoratorName].currentSection ) {
				return decorator.getDelegate().layoutWidget( widget, attributes, container, mw );
			}

			// End nested LayoutDecorator's current section

			if ( container[decoratorName].currentSection !== undefined ) {
				decorator.getDelegate().endContainerLayout( container, mw );
			}

			container[decoratorName].currentSection = section;

			// Add a heading

			if ( section !== '' ) {
				decorator.addSectionWidget( section, 0, attributes, container, mw );
			}
		} else {

			// Stay where we are?

			if ( attributes.section === undefined || attributes.section === container[decoratorName].currentSection ) {
				return decorator.getDelegate().layoutWidget( widget, attributes, container, mw );
			}

			// For each of the new sections...

			var sections = metawidget.util.splitArray( attributes.section );
			var currentSections;

			if ( container[decoratorName].currentSection !== undefined ) {
				currentSections = metawidget.util.splitArray( container[decoratorName].currentSection );
			} else {
				currentSections = [];
			}

			for ( var level = 0; level < sections.length; level++ ) {
				var section = sections[level];

				// ...that are different from our current...

				if ( section === '' ) {
					continue;
				}

				if ( level < currentSections.length && section === currentSections[level] ) {
					continue;
				}

				// ...add a heading
				//
				// Note: we cannot stop/start the delegate layout here. It is
				// tempting, but remember addSectionWidget needs to use
				// the delegate. If you stop/add section heading/start the
				// delegate, who is laying out the section heading?

				decorator.addSectionWidget( section, level, attributes, container, mw );
			}

			container[decoratorName].currentSection = attributes.section;
		}

		// Add component as normal

		decorator.getDelegate().layoutWidget( widget, attributes, container, mw );
	};
};

/**
 * Augment the given 'decorator' with methods suitable for making nested (as
 * opposed to flat) section separator LayoutDecorators.
 * <p>
 * This includes an implementation of the <tt>layoutWidget</tt> method and a
 * declaration of a <tt>createSectionWidget</tt> method.
 */

metawidget.layout.createNestedSectionLayoutDecorator = function( config, decorator, decoratorName ) {

	if ( this instanceof metawidget.layout.createNestedSectionLayoutDecorator ) {
		throw new Error( 'Function called as a Constructor' );
	}

	metawidget.layout._createSectionLayoutDecorator( config, decorator, decoratorName );

	// Tag this NestedSectionLayoutDecorator so that FlatSectionLayoutDecorator
	// can recognize it

	decorator.nestedSectionLayoutDecorator = true;

	decorator.layoutWidget = function( widget, attributes, container, mw ) {

		// Stay where we are?

		var section = metawidget.util.stripSection( attributes );

		if ( section === undefined || section === container[decoratorName].currentSection ) {
			if ( container[decoratorName].currentSectionWidget ) {
				return decorator.getDelegate().layoutWidget( widget, attributes, container[decoratorName].currentSectionWidget, mw );
			}
			return decorator.getDelegate().layoutWidget( widget, attributes, container, mw );
		}

		// End current section

		if ( container[decoratorName].currentSectionWidget !== undefined ) {
			decorator.endContainerLayout( container[decoratorName].currentSectionWidget, mw );
		}

		container[decoratorName].currentSection = section;
		var previousSectionWidget = container[decoratorName].currentSectionWidget;
		delete container[decoratorName].currentSectionWidget;

		// No new section?

		if ( section === '' ) {
			decorator.getDelegate().layoutWidget( widget, attributes, container, mw );
			return;
		}

		// Start new section

		container[decoratorName].currentSectionWidget = decorator.createSectionWidget( previousSectionWidget, section, attributes, container, mw );
		decorator.startContainerLayout( container[decoratorName].currentSectionWidget, mw );

		// Add component to new section

		decorator.getDelegate().layoutWidget( widget, attributes, container[decoratorName].currentSectionWidget, mw );
	};

	var _superEndContainerLayout = decorator.endContainerLayout;

	decorator.endContainerLayout = function( container, mw ) {

		// End hanging layouts

		if ( container[decoratorName].currentSectionWidget !== undefined ) {
			decorator.endContainerLayout( container[decoratorName].currentSectionWidget, mw );
		}

		_superEndContainerLayout( container, mw );
	};
};

/**
 * @class LayoutDecorator to decorate widgets from different sections using an
 *        HTML heading tag (i.e. <tt>h1</tt>, <tt>h2</tt> etc).
 */

metawidget.layout.HeadingTagLayoutDecorator = function( config ) {

	if ( ! ( this instanceof metawidget.layout.HeadingTagLayoutDecorator ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	metawidget.layout.createFlatSectionLayoutDecorator( config, this, 'headingTagLayoutDecorator' );
};

metawidget.layout.HeadingTagLayoutDecorator.prototype.addSectionWidget = function( section, level, attributes, container, mw ) {

	var h1 = document.createElement( 'h' + ( level + 1 ) );
	h1.innerHTML = section;

	this.getDelegate().layoutWidget( h1, {
		wide: 'true'
	}, container, mw );
};

/**
 * @class LayoutDecorator to decorate widgets from different sections using
 *        nested <tt>div</tt> tags.
 */

metawidget.layout.DivLayoutDecorator = function( config ) {

	if ( ! ( this instanceof metawidget.layout.DivLayoutDecorator ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	metawidget.layout.createNestedSectionLayoutDecorator( config, this, 'divLayoutDecorator' );
};

metawidget.layout.DivLayoutDecorator.prototype.createSectionWidget = function( previousSectionWidget, section, attributes, container, mw ) {

	var div = document.createElement( 'div' );
	div.setAttribute( 'title', section );
	this.getDelegate().layoutWidget( div, {
		wide: 'true'
	}, container, mw );

	return div;
};
// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace Utilities.
 */

metawidget.util = metawidget.util || {};

/**
 * Uncamel cases the given name (e.g. from 'fooBarBaz' to 'Foo Bar Baz').
 */

metawidget.util.uncamelCase = function( name ) {

	return name.charAt( 0 ).toUpperCase() + name.slice( 1 ).replace( /([^ ])([A-Z0-9])/g, function( $1, $2, $3 ) {

		return $2 + ' ' + $3;
	} );
};

/**
 * Capitalizes the first letter of the given name (e.g. from 'fooBarBaz' to
 * 'FooBarBaz').
 */

metawidget.util.capitalize = function( name ) {

	return name.charAt( 0 ).toUpperCase() + name.slice( 1 );
};

/**
 * Camel cases the given array of names (e.g. from ['foo','bar','baz'] to
 * 'fooBarBaz').
 * 
 * @return the camel cased name. Or an empty string if no name
 */

metawidget.util.camelCase = function( names ) {

	var toString = '';
	var length = names.length;

	if ( length > 0 ) {
		toString += names[0];
	}

	for ( var loop = 1; loop < length; loop++ ) {
		toString += metawidget.util.capitalize( names[loop] );
	}

	return toString;
};

/**
 * Gets a camelCased id based on the given attributes.name and the given
 * mw.path.
 */

metawidget.util.getId = function( attributes, mw ) {

	if ( mw.path !== undefined ) {
		var splitPath = mw.path.split( '.' );

		if ( splitPath[0] === 'object' ) {
			splitPath = splitPath.slice( 1 );
		}

		if ( attributes.name && attributes._root !== 'true' ) {
			splitPath.push( attributes.name );
		} else if ( splitPath.length == 0 ) {
			return undefined;
		}

		return metawidget.util.camelCase( splitPath );
	}

	if ( attributes !== undefined ) {
		return attributes.name;
	}
};

/**
 * Returns true if the given node has child <em>elements</em>. That is, their
 * <tt>nodeType === 1</tt>. Ignores other sorts of child nodes, such as text
 * nodes.
 */

metawidget.util.hasChildElements = function( node ) {

	var childNodes = node.childNodes;

	for ( var loop = 0, length = childNodes.length; loop < length; loop++ ) {

		if ( childNodes[loop].nodeType === 1 ) {
			return true;
		}
	}

	return false;
};

/**
 * @true if the given attributes define 'large' or 'wide'.
 */

metawidget.util.isSpanAllColumns = function( attributes ) {

	if ( attributes === undefined ) {
		return false;
	}

	if ( attributes.large === 'true' ) {
		return true;
	}

	if ( attributes.wide === 'true' ) {
		return true;
	}

	return false;
};

/**
 * Splits the given path into its type and an array of names (e.g. 'foo.bar.baz'
 * into type 'foo' and names ['bar','baz']).
 * 
 * @returns an object with properties 'type' and 'names' (provided there is at
 *          least 1 name)
 */

metawidget.util.splitPath = function( path ) {

	var splitPath = {};

	if ( path !== undefined ) {
		var pathArray = path.split( '.' );
		splitPath.type = pathArray[0];

		if ( pathArray.length > 1 ) {
			splitPath.names = pathArray.slice( 1 );
		}
	}

	return splitPath;
};

/**
 * Appends the 'path' property from the given Metawidget to the 'name' property
 * in the given attributes.
 */

metawidget.util.appendPath = function( attributes, mw ) {

	if ( mw.path !== undefined ) {
		return mw.path + '.' + attributes.name;
	}

	if ( mw.toInspect !== undefined ) {
		return typeof ( mw.toInspect ) + '.' + attributes.name;
	}

	return 'object.' + attributes.name;
};

/**
 * Traverses the given 'toInspect' along properties defined by the array of
 * 'names'.
 */

metawidget.util.traversePath = function( toInspect, names ) {

	if ( toInspect === undefined ) {
		return undefined;
	}

	if ( names !== undefined ) {
		for ( var loop = 0, length = names.length; loop < length; loop++ ) {

			var name = names[loop];
			var indexOf = name.indexOf( '[' );
			var arrayIndex = undefined;

			if ( indexOf !== -1 ) {
				arrayIndex = name.substring( indexOf + 1, name.length - 1 );
				name = name.substring( 0, indexOf );
			}

			toInspect = toInspect[name];

			if ( arrayIndex !== undefined ) {
				toInspect = toInspect[arrayIndex];
			}

			if ( toInspect === undefined ) {
				return undefined;
			}
		}
	}

	return toInspect;
};

/**
 * Combines the given first array with the given second array.
 * <p>
 * Array elements are expected to be objects. They are combined based on their
 * 'name' property (or their '_root' property). If no elements match, new
 * elements are appended to the end of the array.
 */

metawidget.util.combineInspectionResults = function( existingInspectionResult, newInspectionResult ) {

	// Inspector may return undefined

	if ( newInspectionResult === undefined ) {
		return existingInspectionResult;
	}

	// If this is the first result...

	if ( existingInspectionResult.length === 0 ) {

		// ...copy it

		for ( var loop = 0, length = newInspectionResult.length; loop < length; loop++ ) {

			var newAttributes = newInspectionResult[loop];
			var existingAttributes = {};

			for ( var attribute in newAttributes ) {
				existingAttributes[attribute] = newAttributes[attribute];
			}

			existingInspectionResult.push( existingAttributes );
		}

	} else {

		// ...otherwise merge it

		outer: for ( var loop1 = 0, length1 = newInspectionResult.length; loop1 < length1; loop1++ ) {

			var newAttributes = newInspectionResult[loop1];

			for ( var loop2 = 0, length2 = existingInspectionResult.length; loop2 < length2; loop2++ ) {
				var existingAttributes = existingInspectionResult[loop2];

				if ( existingAttributes.name === newAttributes.name || ( existingAttributes._root === 'true' && newAttributes._root === 'true' ) ) {

					for ( var attribute in newAttributes ) {
						existingAttributes[attribute] = newAttributes[attribute];
					}

					continue outer;
				}
			}

			// If no existing attributes matched, push a new one

			var existingAttributes = {};

			for ( var attribute in newAttributes ) {
				existingAttributes[attribute] = newAttributes[attribute];
			}

			existingInspectionResult.push( existingAttributes );
		}
	}

	return existingInspectionResult;
};

/**
 * Strips the first section off the section attribute (if any).
 */

metawidget.util.stripSection = function( attributes ) {

	var section = attributes.section;

	// (undefined means 'no change to current section')

	if ( section === undefined ) {
		return undefined;
	}

	var sections = metawidget.util.splitArray( section );

	switch ( sections.length ) {

		// (empty String means 'end current section')
		case 0:
			return '';

		case 1:
			delete attributes.section;
			return sections[0];

		case 2:
			attributes.section = metawidget.util.joinArray( sections.slice( 1 ) );
			return sections[0];
	}
};

/**
 * Similar to String.split(',') but recognizes escaped commas.
 */

metawidget.util.splitArray = function( toSplit ) {

	var array = [];

	var regex = /(?:[^\,\\]+|\\.)+/g;
	var matched;
	while ( matched = regex.exec( toSplit ) ) {
		array.push( matched[0].replace( /\\,/g, ',' ) );
	}

	return array;
};

/**
 * Similar to Array.join(',') but escapes any commas.
 */

metawidget.util.joinArray = function( array ) {

	var toReturn = '';

	for ( var loop = 0, length = array.length; loop < length; loop++ ) {

		if ( toReturn.length !== 0 ) {
			toReturn += ',';
		}

		toReturn += array[loop].replace( /,/g, '\\,' );
	}

	return toReturn;
};// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace WidgetBuilders.
 */

metawidget.widgetbuilder = metawidget.widgetbuilder || {};

/**
 * @class Delegates widget building to one or more sub-WidgetBuilders.
 *        <p>
 *        Each sub-WidgetBuilder in the list is invoked, in order, calling its
 *        <code>buildWidget</code> method. The first result is returned. If
 *        all sub-WidgetBuilders return undefined, undefined is returned (the
 *        parent Metawidget will generally instantiate a nested Metawidget in
 *        this case).
 *        <p>
 *        Note: the name <em>Composite</em>WidgetBuilder refers to the
 *        Composite design pattern.
 */

metawidget.widgetbuilder.CompositeWidgetBuilder = function( config ) {

	if ( ! ( this instanceof metawidget.widgetbuilder.CompositeWidgetBuilder ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	var _widgetBuilders;

	if ( config.widgetBuilders !== undefined ) {
		_widgetBuilders = config.widgetBuilders.slice( 0 );
	} else {
		_widgetBuilders = config.slice( 0 );
	}

	this.onStartBuild = function() {

		for ( var loop = 0, length = _widgetBuilders.length; loop < length; loop++ ) {

			var widgetBuilder = _widgetBuilders[loop];

			if ( widgetBuilder.onStartBuild !== undefined ) {
				widgetBuilder.onStartBuild();
			}
		}
	};

	this.buildWidget = function( attributes, mw ) {

		for ( var loop = 0, length = _widgetBuilders.length; loop < length; loop++ ) {

			var widget;
			var widgetBuilder = _widgetBuilders[loop];

			if ( widgetBuilder.buildWidget !== undefined ) {
				widget = widgetBuilder.buildWidget( attributes, mw );
			} else {
				widget = widgetBuilder( attributes, mw );
			}

			if ( widget !== undefined ) {
				return widget;
			}
		}
	};

	this.onEndBuild = function() {

		for ( var loop = 0, length = _widgetBuilders.length; loop < length; loop++ ) {

			var widgetBuilder = _widgetBuilders[loop];

			if ( widgetBuilder.onEndBuild !== undefined ) {
				widgetBuilder.onEndBuild();
			}
		}
	};
};

/**
 * @class WidgetBuilder to override widgets based on <tt>mw.overriddenNodes</tt>.
 *        <p>
 *        Widgets are overridden based on id, not name, because name is not
 *        legal syntax for many nodes (e.g. <tt>table</tt>).
 */

metawidget.widgetbuilder.OverriddenWidgetBuilder = function() {

	if ( ! ( this instanceof metawidget.widgetbuilder.OverriddenWidgetBuilder ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetbuilder.OverriddenWidgetBuilder.prototype.buildWidget = function( attributes, mw ) {

	if ( mw.overriddenNodes === undefined ) {
		return;
	}

	var overrideId = metawidget.util.getId( attributes, mw );

	for ( var loop = 0, length = mw.overriddenNodes.length; loop < length; loop++ ) {

		var child = mw.overriddenNodes[loop];
		if ( child.nodeType === 1 && child.getAttribute( 'id' ) === overrideId ) {
			child.overridden = true;
			mw.overriddenNodes.splice( loop, 1 );
			return child;
		}
	}
};

/**
 * @class WidgetBuilder for read-only widgets in HTML 5 environments.
 */

metawidget.widgetbuilder.ReadOnlyWidgetBuilder = function() {

	if ( ! ( this instanceof metawidget.widgetbuilder.ReadOnlyWidgetBuilder ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetbuilder.ReadOnlyWidgetBuilder.prototype.buildWidget = function( attributes, mw ) {

	// Not read-only?

	if ( attributes.readOnly !== 'true' ) {
		return;
	}

	// Hidden

	if ( attributes.hidden === 'true' || attributes.type === 'function' ) {
		return document.createElement( 'stub' );
	}

	if ( attributes.lookup !== undefined || attributes.type === 'string' || attributes.type === 'boolean' || attributes.type === 'number' || attributes.type === 'date' ) {

		if ( attributes.masked === 'true' ) {

			// Masked (return a couple of nested Stubs, so that we DO still
			// render a label)

			var stub = document.createElement( 'stub' );
			stub.appendChild( document.createElement( 'stub' ) );
			return stub;
		}

		return document.createElement( 'output' );
	}

	// Not simple, but don't expand

	if ( attributes.dontExpand === 'true' ) {
		return document.createElement( 'output' );
	}
};

/**
 * WidgetBuilder for pure JavaScript environments.
 * <p>
 * Creates native HTML 5 widgets, such as <code>input</code> and
 * <code>select</code>, to suit the inspected fields.
 */

metawidget.widgetbuilder.HtmlWidgetBuilder = function() {

	if ( ! ( this instanceof metawidget.widgetbuilder.HtmlWidgetBuilder ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetbuilder.HtmlWidgetBuilder.prototype.buildWidget = function( attributes, mw ) {

	// Hidden

	if ( attributes.hidden === 'true' ) {
		return document.createElement( 'stub' );
	}

	// Select box

	if ( attributes.lookup !== undefined && attributes.lookup !== '' ) {

		var lookupSplit = metawidget.util.splitArray( attributes.lookup );
		var lookupLabelsSplit = undefined;
		
		if ( attributes.lookupLabels !== undefined && attributes.lookupLabels != '' ) {
			lookupLabelsSplit = metawidget.util.splitArray( attributes.lookupLabels );
		}

		// Multi-select and radio buttons

		if ( attributes.type === 'array' || attributes.componentType !== undefined ) {

			var div = document.createElement( 'div' );
			
			for ( var loop = 0, length = lookupSplit.length; loop < length; loop++ ) {

				// Uses 'implicit label association':
				// http://www.w3.org/TR/html4/interact/forms.html#h-17.9.1
				
				var label = document.createElement( 'label' );
				var option = document.createElement( 'input' );
				
				if ( attributes.componentType !== undefined ) {
					option.setAttribute( 'type', attributes.componentType );
				} else {
					option.setAttribute( 'type', 'checkbox' );
				}
				option.setAttribute( 'value', lookupSplit[loop] );
				label.appendChild( option );

				if ( lookupLabelsSplit !== undefined ) {
					label.appendChild( document.createTextNode( lookupLabelsSplit[loop] ));
				} else {
					label.appendChild( document.createTextNode( lookupSplit[loop] ));
				}

				div.appendChild( label );
			}

			return div;
		}

		// Single-select

		var select = document.createElement( 'select' );

		if ( attributes.required === undefined || attributes.required === 'false' ) {
			select.appendChild( document.createElement( 'option' ) );
		}

		for ( var loop = 0, length = lookupSplit.length; loop < length; loop++ ) {
			var option = document.createElement( 'option' );

			// HtmlUnit needs an 'option' to have a 'value', even if the same as
			// the innerHTML

			option.setAttribute( 'value', lookupSplit[loop] );

			if ( lookupLabelsSplit !== undefined ) {
				option.innerHTML = lookupLabelsSplit[loop];
			} else {
				option.innerHTML = lookupSplit[loop];
			}

			select.appendChild( option );
		}
		return select;
	}

	// Action

	if ( attributes.type === 'function' ) {
		var button = document.createElement( 'button' );

		if ( attributes.label !== undefined ) {
			button.innerHTML = attributes.label;
		} else {
			button.innerHTML = metawidget.util.uncamelCase( attributes.name );
		}
		return button;
	}

	// Number

	if ( attributes.type === 'number' ) {

		if ( attributes.minimumValue !== undefined && attributes.maximumValue !== undefined ) {
			var range = document.createElement( 'input' );
			range.setAttribute( 'type', 'range' );
			range.setAttribute( 'min', attributes.minimumValue );
			range.setAttribute( 'max', attributes.maximumValue );
			return range;
		}

		var number = document.createElement( 'input' );
		number.setAttribute( 'type', 'number' );
		return number;
	}

	// Boolean

	if ( attributes.type === 'boolean' ) {
		var checkbox = document.createElement( 'input' );
		checkbox.setAttribute( 'type', 'checkbox' );
		return checkbox;
	}

	// Date

	if ( attributes.type === 'date' ) {
		var date = document.createElement( 'input' );
		date.setAttribute( 'type', 'date' );
		return date;
	}

	// String

	if ( attributes.type === 'string' ) {

		if ( attributes.masked === 'true' ) {
			var password = document.createElement( 'input' );
			password.setAttribute( 'type', 'password' );

			if ( attributes.maximumLength !== undefined ) {
				password.setAttribute( 'maxlength', attributes.maximumLength );
			}

			return password;
		}

		if ( attributes.large === 'true' ) {
			return document.createElement( 'textarea' );
		}

		var text = document.createElement( 'input' );
		text.setAttribute( 'type', 'text' );

		if ( attributes.maximumLength !== undefined ) {
			text.setAttribute( 'maxlength', attributes.maximumLength );
		}

		return text;
	}

	// Not simple, but don't expand

	if ( attributes.dontExpand === 'true' ) {
		var text = document.createElement( 'input' );
		text.setAttribute( 'type', 'text' );
		return text;
	}
};
// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

var metawidget = metawidget || {};

/**
 * @namespace WidgetProcessors.
 */

metawidget.widgetprocessor = metawidget.widgetprocessor || {};

/**
 * @class WidgetProcessor that sets the HTML 'id' attribute.
 */

metawidget.widgetprocessor.IdProcessor = function() {

	if ( ! ( this instanceof metawidget.widgetprocessor.IdProcessor ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetprocessor.IdProcessor.prototype.processWidget = function( widget, attributes, mw ) {

	// Dangerous to reassign an id. For example, some JQuery UI widgets assign
	// temporary ids when they wrap widgets

	if ( !widget.hasAttribute( 'id' )) {
		var id = metawidget.util.getId( attributes, mw );
		
		if ( id !== undefined ) {
			widget.setAttribute( 'id', id );
		}
	}

	return widget;
};

/**
 * @class WidgetProcessor that sets the HTML 5 'required' attribute.
 */

metawidget.widgetprocessor.RequiredAttributeProcessor = function() {

	if ( ! ( this instanceof metawidget.widgetprocessor.RequiredAttributeProcessor ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetprocessor.RequiredAttributeProcessor.prototype.processWidget = function( widget, attributes, mw ) {

	if ( attributes.required === 'true' ) {
		widget.setAttribute( 'required', 'required' );
	}

	return widget;
};

/**
 * @class Simple data/action binding implementation. Frameworks that supply their own
 * data-binding mechanisms (such as Angular JS) should override this with their own WidgetProcessor.
 */

metawidget.widgetprocessor.SimpleBindingProcessor = function() {

	if ( ! ( this instanceof metawidget.widgetprocessor.SimpleBindingProcessor ) ) {
		throw new Error( 'Constructor called as a function' );
	}
};

metawidget.widgetprocessor.SimpleBindingProcessor.prototype.onStartBuild = function( mw ) {

	mw._simpleBindingProcessorBindings = {};
};

metawidget.widgetprocessor.SimpleBindingProcessor.prototype.processWidget = function( widget, attributes, mw ) {

	if ( widget.tagName === 'BUTTON' ) {
		widget.onclick = function() { try { return mw.toInspect[attributes.name](); } catch( e ) { alert( e ); }};
	} else {

		var value;
		var typeAndNames = metawidget.util.splitPath( mw.path );
		var toInspect = metawidget.util.traversePath( mw.toInspect, typeAndNames.names );

		if ( attributes._root !== 'true' && toInspect !== undefined ) {
			value = toInspect[attributes.name];
		} else {
			value = toInspect;
		}

		var isBindable = ( widget.tagName === 'INPUT' || widget.tagName === 'SELECT' || widget.tagName === 'TEXTAREA' );

		if ( isBindable === true && widget.hasAttribute( 'id' ) ) {

			// Standard HTML works off 'name', not 'id', for binding

			widget.setAttribute( 'name', widget.getAttribute( 'id' ) );
		}

		// Check 'not undefined', rather than 'if value', in case value is a boolean of false
		//
		// Note: this is a general convention throughout Metawidget, as JavaScript has a
		// surprisingly large number of 'falsy' values)
		
		if ( value !== undefined ) {
			if ( widget.tagName === 'OUTPUT' || widget.tagName === 'TEXTAREA' ) {
				widget.innerHTML = value;
			} else if ( widget.tagName === 'INPUT' && widget.getAttribute( 'type' ) === 'checkbox' ) {
				widget.checked = value;
			} else if ( isBindable === true ) {
				widget.value = value;
			}
		}

		if ( isBindable === true || widget.metawidget !== undefined ) {
			mw._simpleBindingProcessorBindings[attributes.name] = widget;
		}
	}

	return widget;
};

/**
 * Save the bindings associated with the given Metawidget.
 */

metawidget.widgetprocessor.SimpleBindingProcessor.prototype.save = function( mw ) {

	var typeAndNames = metawidget.util.splitPath( mw.path );
	var toInspect = metawidget.util.traversePath( mw.toInspect, typeAndNames.names );
	
	for ( var name in mw._simpleBindingProcessorBindings ) {

		var widget = mw._simpleBindingProcessorBindings[name];

		if ( widget.metawidget !== undefined ) {
			this.save( widget.metawidget );
			continue;
		}

		if ( widget.getAttribute( 'type' ) === 'checkbox' ) {
			toInspect[name] = widget.checked;
			continue;
		}
		
		toInspect[name] = widget.value;
	}
};
// Metawidget 3.2 (licensed under LGPL)
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

'use strict';

/**
 * @namespace Metawidget for pure JavaScript environments.
 */

var metawidget = metawidget || {};

/**
 * Pure JavaScript Metawidget.
 * 
 * @param element
 *            the element to populate with UI components matching the properties
 *            of the business object
 * @param config
 *            optional configuration object (see metawidget.Pipeline.configure)
 * @returns {metawidget.Metawidget}
 */

metawidget.Metawidget = function( element, config ) {

	if ( ! ( this instanceof metawidget.Metawidget ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	// Pipeline (private)

	var _pipeline = new metawidget.Pipeline( element );
	_pipeline.buildNestedMetawidget = function( attributes, mw ) {

		var nestedWidget = document.createElement( 'div' );

		// Duck-type our 'pipeline' as the 'config' of the nested Metawidget

		var nestedMetawidget = new metawidget.Metawidget( nestedWidget, _pipeline );
		nestedMetawidget.toInspect = mw.toInspect;
		nestedMetawidget.path = metawidget.util.appendPath( attributes, mw );
		nestedMetawidget.readOnly = mw.readOnly || attributes.readOnly === 'true';

		// Attach ourselves as a property of the tag, rather than try to
		// 'extend' the built-in HTML tags. This is used by SimpleBindingProcessor,
		// among others

		nestedWidget.metawidget = nestedMetawidget;
		nestedMetawidget.buildWidgets();

		return nestedWidget;
	};

	// Configure defaults

	_pipeline.inspector = new metawidget.inspector.PropertyTypeInspector();
	_pipeline.widgetBuilder = new metawidget.widgetbuilder.CompositeWidgetBuilder( [ new metawidget.widgetbuilder.OverriddenWidgetBuilder(), new metawidget.widgetbuilder.ReadOnlyWidgetBuilder(),
			new metawidget.widgetbuilder.HtmlWidgetBuilder() ] );
	_pipeline.widgetProcessors = [ new metawidget.widgetprocessor.IdProcessor(), new metawidget.widgetprocessor.RequiredAttributeProcessor(), new metawidget.widgetprocessor.SimpleBindingProcessor() ];
	_pipeline.layout = new metawidget.layout.HeadingTagLayoutDecorator( new metawidget.layout.TableLayout() );
	_pipeline.configure( config );

	// First time in, capture the contents of the Metawidget, if any (private)

	var _overriddenNodes = [];

	while ( element.childNodes.length > 0 ) {
		var childNode = element.childNodes[0];
		element.removeChild( childNode );

		if ( childNode.nodeType === 1 ) {
			_overriddenNodes.push( childNode );
		}
	}

	//
	// Public methods
	//

	this.getWidgetProcessor = function( testInstanceOf ) {

		return _pipeline.getWidgetProcessor( testInstanceOf );
	};

	this.setLayout = function( layout ) {

		_pipeline.layout = layout;
	};

	this.buildWidgets = function( inspectionResult ) {

		// Defensive copy

		this.overriddenNodes = [];

		for ( var loop = 0, length = _overriddenNodes.length; loop < length; loop++ ) {
			this.overriddenNodes.push( _overriddenNodes[loop].cloneNode( true ) );
		}

		// Inspect (if necessary)

		if ( inspectionResult === undefined ) {
			var splitPath = metawidget.util.splitPath( this.path );
			inspectionResult = _pipeline.inspect( this.toInspect, splitPath.type, splitPath.names, this );
		}

		// Build widgets
		
		_pipeline.buildWidgets( inspectionResult, this );
	};
};

/**
 * @class Convenience implementation for implementing pipelines (see
 * http://metawidget.org/doc/reference/en/html/ch02.html).
 * <p>
 * Specifically, BasePipeline provides support for:
 * </p>
 * <ul>
 * <li>Inspectors, InspectionResultProcessors, WidgetBuilders, WidgetProcessors and Layouts</li>
 * <li>single/compound widgets</li>
 * <li>stubs/stub attributes</li>
 * <li>read-only/active widgets</li>
 * <li>maximum inspection depth</li>
 * </ul>
 * <p>
 * Clients should override 'buildNestedMetawidget'.
 * </p>
 */

metawidget.Pipeline = function( element ) {

	if ( ! ( this instanceof metawidget.Pipeline ) ) {
		throw new Error( 'Constructor called as a function' );
	}

	this.inspectionResultProcessors = [];
	this.widgetProcessors = [];
	this.element = element;
	this.maximumInspectionDepth = 10;
};

/**
 * Configures the pipeline using the given config object.
 * <p>
 * This method is separate to the constructor, so that subclasses can set
 * defaults. The following configuration properties are supported:
 * <ul>
 * <li>inspector - an Inspector</li>
 * <li>inspectionResultProcessors - an array of InspectionResultProcessors</li>
 * <li>widgetBuilder - a WidgetBuilder</li>
 * <li>widgetProcessors - an array of WidgetProcessors</li>
 * <li>layout - a Layout</li>
 * </ul>
 * 
 * @param config
 *            the config object to use. This can be an array, in which case
 *            multiple configs will be applied (in the order they appear in the
 *            array)
 */

metawidget.Pipeline.prototype.configure = function( config ) {

	if ( config === undefined ) {
		return;
	}
	
	// Support arrays of configs
	
	if ( config instanceof Array ) {
		for( var loop = 0, length = config.length; loop < length; loop++ ) {
			this.configure( config[loop] );
		}
		return;
	}
	if ( config.inspector !== undefined ) {
		this.inspector = config.inspector;
	}
	if ( config.inspectionResultProcessors !== undefined ) {
		this.inspectionResultProcessors = config.inspectionResultProcessors.slice( 0 );
	}

	// Support adding to the existing array of InspectionResultProcessors (it
	// may be hard for clients to redefine the originals)

	if ( config.addInspectionResultProcessors !== undefined ) {
		for ( var loop = 0, length = config.addInspectionResultProcessors.length; loop < length; loop++ ) {
			this.inspectionResultProcessors.push( config.addInspectionResultProcessors[loop] );
		}
	}
	if ( config.widgetBuilder !== undefined ) {
		this.widgetBuilder = config.widgetBuilder;
	}
	if ( config.widgetProcessors !== undefined ) {
		this.widgetProcessors = config.widgetProcessors.slice( 0 );
	}

	// Support prepending/adding to the existing array of WidgetProcessors (it may be
	// hard for clients to redefine the originals)

	if ( config.prependWidgetProcessors !== undefined ) {
		for ( var loop = 0, length = config.prependWidgetProcessors.length; loop < length; loop++ ) {
			this.widgetProcessors.splice( loop, 0, config.prependWidgetProcessors[loop] );
		}
	}
	if ( config.addWidgetProcessors !== undefined ) {
		for ( var loop = 0, length = config.addWidgetProcessors.length; loop < length; loop++ ) {
			this.widgetProcessors.push( config.addWidgetProcessors[loop] );
		}
	}
	if ( config.layout !== undefined ) {
		this.layout = config.layout;
	}

	// Safeguard against infinite recursion

	if ( config.maximumInspectionDepth !== undefined ) {
		this.maximumInspectionDepth = config.maximumInspectionDepth - 1;
	}
};

/**
 * Searches the pipeline's current list of WidgetProcessors and matches each
 * against the given function
 * 
 * @param testInstanceOf
 *            a function that accepts a WidgetProcessor and will perform an
 *            'instanceof' test on it
 */

metawidget.Pipeline.prototype.getWidgetProcessor = function( testInstanceOf ) {

	for ( var loop = 0, length = this.widgetProcessors.length; loop < length; loop++ ) {

		var widgetProcessor = this.widgetProcessors[loop];

		if ( testInstanceOf( widgetProcessor ) ) {
			return widgetProcessor;
		}
	}
};

/**
 * Inspect the 'toInspect' according to its 'type' and 'names', and return the
 * result as a JSON String.
 * <p>
 * This method mirrors the <code>Inspector</code> interface. Internally it
 * looks up the Inspector to use. It is a useful hook for subclasses wishing to
 * inspect different Objects using our same <code>Inspector</code>.
 * <p>
 * In addition, this method runs the <code>InspectionResultProcessors</code>.
 */

metawidget.Pipeline.prototype.inspect = function( toInspect, type, names, mw ) {

	// Inspector

	var inspectionResult;

	if ( this.inspector.inspect !== undefined ) {
		inspectionResult = this.inspector.inspect( toInspect, type, names );
	} else {
		inspectionResult = this.inspector( toInspect, type, names );
	}

	// Inspector may return undefined

	if ( inspectionResult === undefined ) {
		return;
	}

	// InspectionResultProcessors

	for ( var loop = 0, length = this.inspectionResultProcessors.length; loop < length; loop++ ) {

		var inspectionResultProcessor = this.inspectionResultProcessors[loop];

		if ( inspectionResultProcessor.processInspectionResult !== undefined ) {
			inspectionResult = inspectionResultProcessor.processInspectionResult( inspectionResult, mw, toInspect, type, names );
		} else {
			inspectionResult = inspectionResultProcessor( inspectionResult, mw, toInspect, type, names );
		}

		// InspectionResultProcessor may return undefined

		if ( inspectionResult === undefined ) {
			return;
		}
	}

	return inspectionResult;
};

/**
 * Build widgets from the given JSON inspection result.
 * <p>
 * Note: the Pipeline expects the JSON to be passed in externally, rather than
 * fetching it itself, because some JSON inspections may be asynchronous.
 * 
 * @param inspectionResult
 * 			array of metadata to base widgets on.
 * @param mw
 *            Metawidget instance that will be passed down the pipeline
 *            (WidgetBuilders, WidgetProcessors etc). Expected to have
 *            'toInspect', 'path' and 'readOnly'.
 */

metawidget.Pipeline.prototype.buildWidgets = function( inspectionResult, mw ) {

	// Clear existing contents

	while ( this.element.childNodes.length > 0 ) {
		this.element.removeChild( this.element.childNodes[0] );
	}

	_startBuild( this, mw );

	// Build top-level widget...

	if ( inspectionResult !== undefined ) {
		for ( var loop = 0, length = inspectionResult.length; loop < length; loop++ ) {

			var attributes = inspectionResult[loop];

			if ( attributes._root !== 'true' ) {
				continue;
			}

			var copiedAttributes = _forceReadOnly( attributes, mw );
			var widget = _buildWidget( this, copiedAttributes, mw );

			if ( widget !== undefined ) {
				widget = _processWidget( this, widget, copiedAttributes, mw );

				if ( widget !== undefined ) {
					this.layoutWidget( widget, copiedAttributes, this.element, mw );
					return;
				}
			}

			break;
		}

		// ...or try compound widget

		for ( var loop = 0, length = inspectionResult.length; loop < length; loop++ ) {

			var attributes = inspectionResult[loop];

			if ( attributes._root === 'true' ) {
				continue;
			}

			var copiedAttributes = _forceReadOnly( attributes, mw );
			var widget = _buildWidget( this, copiedAttributes, mw );

			if ( widget === undefined ) {
				if ( this.maximumInspectionDepth <= 0 ) {
					return;
				}

				widget = this.buildNestedMetawidget( copiedAttributes, mw );

				if ( widget === undefined ) {
					return;
				}
			}

			widget = _processWidget( this, widget, copiedAttributes, mw );

			if ( widget !== undefined ) {
				this.layoutWidget( widget, copiedAttributes, this.element, mw );
			}
		}
	}

	// Even if no inspectors match, we still call startBuild()/endBuild()
	// because you can use a Metawidget purely for layout, with no
	// inspection

	_endBuild( this, mw );

	return;

	//
	// Private methods
	//

	/**
	 * Defensively copies the attributes (in case something like stripSection
	 * changes them) and adds 'readOnly' if the given Metawidget is readOnly.
	 */

	function _forceReadOnly( attributes, mw ) {

		var copiedAttributes = {};

		for ( var name in attributes ) {
			copiedAttributes[name] = attributes[name];
		}

		// Try to keep the exact nature of the 'readOnly' mechanism (i.e. set on
		// attribute, or set on overall Metawidget) out of the
		// WidgetBuilders/WidgetProcessors/Layouts. This is because not
		// everybody will need/want a Metawidget-level 'setReadOnly'

		if ( mw.readOnly === true ) {
			copiedAttributes.readOnly = 'true';
		}

		return copiedAttributes;
	}

	function _startBuild( pipeline, mw ) {

		if ( pipeline.widgetBuilder.onStartBuild !== undefined ) {
			pipeline.widgetBuilder.onStartBuild( mw );
		}

		for ( var loop = 0, length = pipeline.widgetProcessors.length; loop < length; loop++ ) {

			var widgetProcessor = pipeline.widgetProcessors[loop];

			if ( widgetProcessor.onStartBuild !== undefined ) {
				widgetProcessor.onStartBuild( mw );
			}
		}

		if ( pipeline.layout.onStartBuild !== undefined ) {
			pipeline.layout.onStartBuild( mw );
		}

		if ( pipeline.layout.startContainerLayout !== undefined ) {
			pipeline.layout.startContainerLayout( pipeline.element, mw );
		}
	}

	function _buildWidget( pipeline, attributes, mw ) {

		if ( pipeline.widgetBuilder.buildWidget !== undefined ) {
			return pipeline.widgetBuilder.buildWidget( attributes, mw );
		}

		return pipeline.widgetBuilder( attributes, mw );
	}

	function _processWidget( pipeline, widget, attributes, mw ) {

		for ( var loop = 0, length = pipeline.widgetProcessors.length; loop < length; loop++ ) {

			var widgetProcessor = pipeline.widgetProcessors[loop];

			if ( widgetProcessor.processWidget !== undefined ) {
				widget = widgetProcessor.processWidget( widget, attributes, mw );
			} else {
				widget = widgetProcessor( widget, attributes, mw );
			}

			if ( widget === undefined ) {
				return;
			}
		}

		return widget;
	}

	function _endBuild( pipeline, mw ) {

		if ( mw.onEndBuild !== undefined ) {
			mw.onEndBuild();
		} else {
			while ( mw.overriddenNodes.length > 0 ) {

				var child = mw.overriddenNodes[0];
				mw.overriddenNodes.splice( 0, 1 );

				// Unused facets don't count

				if ( child.tagName === 'FACET' ) {
					continue;
				}

				// Stubs can supply their own metadata (such as 'label')

				var childAttributes = {
					section: ''
				};

				if ( child.tagName === 'STUB' ) {
					for ( var loop = 0, length = child.attributes.length; loop < length; loop++ ) {
						var prop = child.attributes[loop];
						childAttributes[prop.nodeName] = prop.nodeValue;
					}
				}

				// Manually created components default to no section

				pipeline.layoutWidget( child, childAttributes, pipeline.element, mw );
			}
		}

		// End all stages of the pipeline

		if ( pipeline.layout.endContainerLayout !== undefined ) {
			pipeline.layout.endContainerLayout( pipeline.element, mw );
		}

		if ( pipeline.layout.onEndBuild !== undefined ) {
			pipeline.layout.onEndBuild( mw );
		}

		for ( var loop = 0, length = pipeline.widgetProcessors.length; loop < length; loop++ ) {

			var widgetProcessor = pipeline.widgetProcessors[loop];

			if ( widgetProcessor.onEndBuild !== undefined ) {
				widgetProcessor.onEndBuild( mw );
			}
		}

		if ( pipeline.widgetBuilder.onEndBuild !== undefined ) {
			pipeline.widgetBuilder.onEndBuild( mw );
		}
	}
};

metawidget.Pipeline.prototype.layoutWidget = function( widget, attributes, container, mw ) {

	if ( this.layout.layoutWidget !== undefined ) {
		this.layout.layoutWidget( widget, attributes, container, mw );
		return;
	}

	this.layout( widget, attributes, container, mw );
};

/**
 * Subclasses should override this method to create a nested Metawidget, using
 * their preferred widget creation methodology.
 */

metawidget.Pipeline.prototype.buildNestedMetawidget = function( attributes, mw ) {

	return undefined;
};
