/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetprocessor;

import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.LiteralTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.widgetbuilder.HtmlWidgetBuilderUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiddenFieldProcessor
implements WidgetProcessor<Tag, MetawidgetTag> {
    public static final String ATTRIBUTE_NEEDS_HIDDEN_FIELD = "metawidget-needs-hidden-field";

    public Tag processWidget(Tag tag, String elementName, Map<String, String> attributes, MetawidgetTag metawidget) {
        if (!"true".equals(attributes.get(ATTRIBUTE_NEEDS_HIDDEN_FIELD))) {
            return tag;
        }
        return this.wrapTag(tag, attributes, metawidget);
    }

    protected Tag wrapTag(Tag tag, Map<String, String> attributes, MetawidgetTag metawidget) {
        try {
            StringBuilder builder = new StringBuilder();
            String value = JspUtils.writeTag(metawidget.getPageContext(), tag, (Tag)metawidget);
            builder.append(value);
            Tag hiddenTag = this.createHiddenTag(attributes, metawidget);
            builder.append(JspUtils.writeTag(metawidget.getPageContext(), hiddenTag, (Tag)metawidget));
            if (!"true".equals(attributes.get("hidden")) && "".equals(value)) {
                builder.append("<span></span>");
            }
            return new LiteralTag(builder.toString());
        }
        catch (JspException e) {
            throw WidgetBuilderException.newException((Throwable)e);
        }
    }

    protected Tag createHiddenTag(Map<String, String> attributes, MetawidgetTag metawidget) {
        StringBuilder builder = new StringBuilder();
        builder.append("<input type=\"hidden\"");
        builder.append(HtmlWidgetBuilderUtils.writeValueAttribute(attributes, metawidget));
        builder.append(HtmlWidgetBuilderUtils.writeAttributes(attributes, metawidget));
        builder.append("/>");
        return new LiteralTag(builder.toString());
    }
}

