/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext;

import java.io.FileNotFoundException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.config.iface.ConfigReader;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.config.impl.BaseConfigReader;
import org.metawidget.config.impl.ServletResourceResolver;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.jsp.tagext.FacetTag;
import org.metawidget.jsp.tagext.StubTag;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetawidgetTag
extends BodyTagSupport {
    private static final String CONFIG_READER_ATTRIBUTE = "metawidget-config-reader";
    private static final String DEFAULT_USER_CONFIG = "metawidget.xml";
    static boolean LOGGED_MISSING_CONFIG;
    private String mPath;
    private String mPathPrefix;
    private boolean mNullConfig;
    private ResourceBundle mBundle;
    private Map<String, FacetTag> mFacets;
    private Map<String, StubTag> mStubs;
    private Map<Object, Object> mClientProperties;
    W3CPipeline<Tag, BodyTag, MetawidgetTag> mPipeline = this.newPipeline();

    public void setPageContext(PageContext newPageContext) {
        ConfigReader configReader;
        super.setPageContext(newPageContext);
        ServletContext servletContext = this.pageContext.getServletContext();
        if (this.mPipeline.getConfig() == null) {
            String configFile = servletContext.getInitParameter("org.metawidget.jsp.tagext.CONFIG_FILE");
            if (configFile == null) {
                if (!this.mNullConfig) {
                    this.mPipeline.setConfig((Object)DEFAULT_USER_CONFIG);
                }
            } else {
                this.mPipeline.setConfig((Object)configFile);
            }
        }
        if ((configReader = (ConfigReader)servletContext.getAttribute(CONFIG_READER_ATTRIBUTE)) == null) {
            configReader = new BaseConfigReader((ResourceResolver)new ServletResourceResolver(servletContext));
            servletContext.setAttribute(CONFIG_READER_ATTRIBUTE, (Object)configReader);
        }
        this.mPipeline.setConfigReader(configReader);
    }

    public String getPath() {
        return this.mPath;
    }

    public String getPathPrefix() {
        return this.mPathPrefix;
    }

    public void setConfig(String config) {
        this.mPipeline.setConfig((Object)config);
        this.mNullConfig = config == null;
    }

    public String getLabelString(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        String label = attributes.get("label");
        if (label != null) {
            if ("".equals(label)) {
                return null;
            }
            String localized = this.getLocalizedKey(StringUtils.camelCase((String)label));
            if (localized != null) {
                return localized.trim();
            }
            return label.trim();
        }
        String name = attributes.get("name");
        if (name != null) {
            String localized = this.getLocalizedKey(name);
            if (localized != null) {
                return localized.trim();
            }
            return StringUtils.uncamelCase((String)name);
        }
        return "";
    }

    public String getLocalizedKey(String key) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            String localizedKey = this.mBundle.getString(key);
            if (localizedKey != null) {
                return localizedKey;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "???" + key + "???";
    }

    public FacetTag getFacet(String name) {
        if (this.mFacets == null) {
            return null;
        }
        return this.mFacets.get(name);
    }

    public void setFacet(String name, FacetTag facetTag) {
        if (this.mFacets == null) {
            this.mFacets = CollectionUtils.newHashMap();
        }
        this.mFacets.put(name, facetTag);
    }

    public void setStub(String path, StubTag stubTag) {
        if (this.mStubs == null) {
            this.mStubs = CollectionUtils.newHashMap();
        }
        this.mStubs.put(path, stubTag);
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.mPipeline.setReadOnly(readOnly);
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
    }

    public String inspect(Object toInspect, String type, String ... names) {
        return this.mPipeline.inspect(toInspect, type, names);
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<MetawidgetTag> ... inspectionResultProcessors) {
        this.mPipeline.setInspectionResultProcessors(inspectionResultProcessors);
    }

    public void setWidgetBuilder(WidgetBuilder<Object, ? extends MetawidgetTag> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
    }

    public void setWidgetProcessors(WidgetProcessor<Tag, MetawidgetTag> ... widgetProcessors) {
        this.mPipeline.setWidgetProcessors(widgetProcessors);
    }

    public Layout<Tag, BodyTag, MetawidgetTag> getLayout() {
        return this.mPipeline.getLayout();
    }

    public void setLayout(Layout<Tag, BodyTag, MetawidgetTag> layout) {
        this.mPipeline.setLayout(layout);
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void putClientProperty(Object key, Object value) {
        if (this.mClientProperties == null) {
            this.mClientProperties = CollectionUtils.newHashMap();
        }
        this.mClientProperties.put(key, value);
    }

    public <T> T getClientProperty(Object key) {
        if (this.mClientProperties == null) {
            return null;
        }
        return (T)this.mClientProperties.get(key);
    }

    public int doStartTag() throws JspException {
        this.mFacets = null;
        this.mStubs = null;
        this.mPipeline.setNeedsConfiguring();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        this.mPipeline.configureOnce();
        try {
            this.mPipeline.buildWidgets((Object)this.inspect());
        }
        catch (Exception e) {
            throw MetawidgetException.newException((Throwable)e);
        }
        return super.doEndTag();
    }

    public StubTag getStub(String path) {
        if (this.mStubs == null) {
            return null;
        }
        return this.mStubs.get(path);
    }

    protected void setPathInternal(String path) {
        this.mPath = path;
        this.mPathPrefix = null;
    }

    protected void setPathPrefix(String pathPrefix) {
        this.mPathPrefix = pathPrefix;
    }

    protected void setBundle(ResourceBundle bundle) {
        this.mBundle = bundle;
    }

    protected W3CPipeline<Tag, BodyTag, MetawidgetTag> newPipeline() {
        return new MetawidgetTagPipeline();
    }

    protected abstract void beforeBuildCompoundWidget(Element var1);

    protected void initNestedMetawidget(MetawidgetTag nestedMetawidget, Map<String, String> attributes) {
        nestedMetawidget.setConfig(null);
        this.mPipeline.initNestedPipeline(nestedMetawidget.mPipeline, attributes);
        nestedMetawidget.setPathInternal(this.mPath + '.' + attributes.get("name"));
        nestedMetawidget.setBundle(this.mBundle);
    }

    protected Element inspect() {
        Object obj;
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath((String)this.mPath, (char)'.');
        String type = typeAndNames.getType();
        Element inspectionResult = (Element)this.mPipeline.inspectAsDom(null, type, typeAndNames.getNamesAsArray());
        if (this.pageContext != null && (obj = this.pageContext.findAttribute(type)) != null) {
            Element additionalInspectionResult = (Element)this.mPipeline.inspectAsDom(obj, obj.getClass().getName(), typeAndNames.getNamesAsArray());
            if (inspectionResult == null) {
                inspectionResult = additionalInspectionResult;
            } else if (additionalInspectionResult != null) {
                Element inspectionResultEntity = XmlUtils.getFirstChildElement((Element)inspectionResult);
                Element additionalInspectionResultEntity = XmlUtils.getFirstChildElement((Element)additionalInspectionResult);
                XmlUtils.combineElements((Element)inspectionResultEntity, (Element)additionalInspectionResultEntity, (String)"name", null);
            }
        }
        return inspectionResult;
    }

    protected abstract String getDefaultConfiguration();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MetawidgetTagPipeline
    extends W3CPipeline<Tag, BodyTag, MetawidgetTag> {
        protected MetawidgetTagPipeline() {
        }

        protected MetawidgetTag getPipelineOwner() {
            return MetawidgetTag.this;
        }

        protected String getDefaultConfiguration() {
            return MetawidgetTag.this.getDefaultConfiguration();
        }

        protected void configure() {
            try {
                super.configure();
            }
            catch (MetawidgetException e) {
                if (!MetawidgetTag.DEFAULT_USER_CONFIG.equals(this.getConfig()) || !(e.getCause() instanceof FileNotFoundException)) {
                    throw e;
                }
                if (!LOGGED_MISSING_CONFIG) {
                    LOGGED_MISSING_CONFIG = true;
                    LogUtils.getLog(MetawidgetTag.class).info("Could not locate metawidget.xml. This file is optional, but if you HAVE created one then Metawidget isn''t finding it: {0}", new Object[]{e.getMessage()});
                }
                super.configureDefaults();
            }
        }

        protected Map<String, String> getAdditionalAttributes(Tag tag) {
            if (tag instanceof StubTag) {
                return ((StubTag)tag).getAttributesMap();
            }
            return null;
        }

        protected void buildCompoundWidget(Element element) throws Exception {
            MetawidgetTag.this.beforeBuildCompoundWidget(element);
            super.buildCompoundWidget((Object)element);
        }

        protected MetawidgetTag buildNestedMetawidget(Map<String, String> attributes) throws Exception {
            MetawidgetTag metawidgetTag = (MetawidgetTag)((Object)((Object)((Object)MetawidgetTag.this)).getClass().newInstance());
            MetawidgetTag.this.initNestedMetawidget(metawidgetTag, attributes);
            return metawidgetTag;
        }
    }
}

