/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.widgetbuilder;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.tagext.LiteralTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.html.HtmlStubTag;
import org.metawidget.jsp.tagext.html.widgetbuilder.HtmlWidgetBuilderUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlWidgetBuilder
implements WidgetBuilder<Tag, MetawidgetTag> {
    public Tag buildWidget(String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        if ("true".equals(map.get("hidden"))) {
            map.put("metawidget-needs-hidden-field", "true");
            return new HtmlStubTag();
        }
        if ("action".equals(string)) {
            return this.createSubmitTag(map, metawidgetTag);
        }
        Class clazz = WidgetBuilderUtils.getActualClassOrType(map, String.class);
        if (Boolean.class.equals((Object)clazz) && "true".equals(map.get("required"))) {
            return this.createCheckboxTag(map, metawidgetTag);
        }
        String string2 = map.get("jsp-lookup");
        if (string2 != null && !"".equals(string2)) {
            return this.createSelectTag(string2, map, metawidgetTag);
        }
        String string3 = map.get("lookup");
        if (string3 != null && !"".equals(string3)) {
            return this.createSelectTag(CollectionUtils.fromString((String)string3), CollectionUtils.fromString((String)map.get("lookup-labels")), map, metawidgetTag);
        }
        if (clazz != null) {
            if (Boolean.TYPE.equals(clazz)) {
                return this.createCheckboxTag(map, metawidgetTag);
            }
            if (clazz.isPrimitive()) {
                return this.createTextTag(map, metawidgetTag);
            }
            if (String.class.equals((Object)clazz)) {
                if ("true".equals(map.get("large"))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<textarea");
                    stringBuilder.append(HtmlWidgetBuilderUtils.writeAttributes(map, metawidgetTag));
                    stringBuilder.append(">");
                    stringBuilder.append(HtmlWidgetBuilderUtils.evaluateAsText(map, metawidgetTag));
                    stringBuilder.append("</textarea>");
                    return new LiteralTag(stringBuilder.toString());
                }
                if ("true".equals(map.get("masked"))) {
                    return this.createTextTag("password", map, metawidgetTag);
                }
                return this.createTextTag(map, metawidgetTag);
            }
            if (Character.class.equals((Object)clazz)) {
                return this.createTextTag(map, metawidgetTag);
            }
            if (Date.class.equals((Object)clazz)) {
                return this.createTextTag(map, metawidgetTag);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                return this.createTextTag(map, metawidgetTag);
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return new HtmlStubTag();
            }
        }
        if ("true".equals(map.get("dont-expand"))) {
            return this.createTextTag(map, metawidgetTag);
        }
        return null;
    }

    private Tag createCheckboxTag(Map<String, String> map, MetawidgetTag metawidgetTag) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<input type=\"checkbox\"");
        stringBuilder.append(HtmlWidgetBuilderUtils.writeAttributes(map, metawidgetTag));
        stringBuilder.append(this.writeCheckedAttribute(map, metawidgetTag));
        stringBuilder.append("/>");
        return new LiteralTag(stringBuilder.toString());
    }

    private Tag createTextTag(Map<String, String> map, MetawidgetTag metawidgetTag) {
        return this.createTextTag("text", map, metawidgetTag);
    }

    private Tag createTextTag(String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<input type=\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        stringBuilder.append(HtmlWidgetBuilderUtils.writeValueAttribute(map, metawidgetTag));
        stringBuilder.append(HtmlWidgetBuilderUtils.writeAttributes(map, metawidgetTag));
        Class clazz = WidgetBuilderUtils.getActualClassOrType(map, null);
        if (Character.TYPE.equals(clazz) || Character.class.equals((Object)clazz)) {
            stringBuilder.append(" maxlength=\"1\"");
        } else {
            String string2 = map.get("maximum-length");
            if (string2 != null && !"".equals(string2)) {
                stringBuilder.append(" maxlength=\"");
                stringBuilder.append(string2);
                stringBuilder.append("\"");
            }
        }
        stringBuilder.append("/>");
        return new LiteralTag(stringBuilder.toString());
    }

    private Tag createSubmitTag(Map<String, String> map, MetawidgetTag metawidgetTag) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<input type=\"submit\" value=\"");
        stringBuilder.append(metawidgetTag.getLabelString(map));
        stringBuilder.append("\"");
        stringBuilder.append(HtmlWidgetBuilderUtils.writeAttributes(map, metawidgetTag));
        stringBuilder.append("/>");
        return new LiteralTag(stringBuilder.toString());
    }

    private String writeCheckedAttribute(Map<String, String> map, MetawidgetTag metawidgetTag) {
        Object object = HtmlWidgetBuilderUtils.evaluate(map, metawidgetTag);
        if (object != null && ((Boolean)object).booleanValue()) {
            return " checked";
        }
        return "";
    }

    private Tag createSelectTag(String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        Object object = HtmlWidgetBuilderUtils.evaluate(string, metawidgetTag);
        if (object == null) {
            return null;
        }
        if (object instanceof Collection && !(object instanceof List)) {
            object = CollectionUtils.newArrayList((Collection)((Collection)object));
        } else if (object.getClass().isArray()) {
            object = CollectionUtils.newArrayList((Object[])((Object[])object));
        }
        return this.createSelectTag((List)object, null, map, metawidgetTag);
    }

    private Tag createSelectTag(List<?> list, List<String> list2, Map<String, String> map, MetawidgetTag metawidgetTag) {
        if (list2 != null && !list2.isEmpty() && list2.size() != list.size()) {
            throw WidgetBuilderException.newException((String)"Labels list must be same size as values list");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<select");
        stringBuilder.append(HtmlWidgetBuilderUtils.writeAttributes(map, metawidgetTag));
        stringBuilder.append(">");
        if (WidgetBuilderUtils.needsEmptyLookupItem(map)) {
            stringBuilder.append("<option value=\"\"></option>");
        }
        String string = HtmlWidgetBuilderUtils.evaluateAsText(map, metawidgetTag);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj == null) continue;
            String string2 = StringUtils.quietValueOf(obj);
            stringBuilder.append("<option value=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"");
            if (string2.equals(string)) {
                stringBuilder.append(" selected");
            }
            stringBuilder.append(">");
            if (list2 == null || list2.isEmpty()) {
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(list2.get(i));
            }
            stringBuilder.append("</option>");
        }
        stringBuilder.append("</select>");
        return new LiteralTag(stringBuilder.toString());
    }
}

