/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.jsp;

import javax.servlet.jsp.PageContext;
import junit.framework.TestCase;
import org.metawidget.inspectionresultprocessor.jsp.JspInspectionResultProcessor;
import org.metawidget.jsp.JspMetawidgetTests;
import org.metawidget.jsp.tagext.html.HtmlMetawidgetTag;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JspInspectionResultProcessorTest
extends TestCase {
    public void testXml() {
        String xml = "<?xml version=\"1.0\"?>";
        xml = xml + "<inspection-result xmlns=\"http://www.metawidget.org/inspection-result\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.metawidget.org/inspection-result ../../inspectionResultProcessor/inspection-result-1.0.xsd\" version=\"1.0\">";
        xml = xml + "<entity type=\"Foo\">";
        xml = xml + "<property name=\"bar1\" value-is-el=\"${baz1}\" value-is-text=\"text\"/>";
        xml = xml + "<property name=\"bar2\" value-is-null=\"${null}\" value-is-embedded-el=\"first ${abc} middle ${null}${def} last\"/>";
        xml = xml + "<action name=\"bar3\" value-is-el=\"${baz2}\" value-is-text=\"text\"/>";
        xml = xml + "</entity></inspection-result>";
        JspInspectionResultProcessor inspectionResultProcessor = new JspInspectionResultProcessor();
        HtmlMetawidgetTag metawidgetTag = new HtmlMetawidgetTag();
        metawidgetTag.setPageContext((PageContext)new JspMetawidgetTests.MockPageContext());
        String result = inspectionResultProcessor.processInspectionResult(xml, (Object)metawidgetTag, null, null, new String[0]);
        Document document = XmlUtils.documentFromString((String)result);
        JspInspectionResultProcessorTest.assertEquals((String)"inspection-result", (String)document.getFirstChild().getNodeName());
        Element entity = (Element)document.getDocumentElement().getFirstChild();
        JspInspectionResultProcessorTest.assertEquals((String)"entity", (String)entity.getNodeName());
        JspInspectionResultProcessorTest.assertEquals((String)"Foo", (String)entity.getAttribute("type"));
        JspInspectionResultProcessorTest.assertFalse((boolean)entity.hasAttribute("name"));
        Element property = XmlUtils.getFirstChildElement((Element)entity);
        JspInspectionResultProcessorTest.assertEquals((String)"property", (String)property.getNodeName());
        JspInspectionResultProcessorTest.assertEquals((String)"bar1", (String)property.getAttribute("name"));
        JspInspectionResultProcessorTest.assertEquals((String)"result of ${baz1}", (String)property.getAttribute("value-is-el"));
        JspInspectionResultProcessorTest.assertEquals((String)"text", (String)property.getAttribute("value-is-text"));
        JspInspectionResultProcessorTest.assertEquals((int)3, (int)property.getAttributes().getLength());
        property = XmlUtils.getNextSiblingElement((Element)property);
        JspInspectionResultProcessorTest.assertEquals((String)"property", (String)property.getNodeName());
        JspInspectionResultProcessorTest.assertEquals((String)"bar2", (String)property.getAttribute("name"));
        JspInspectionResultProcessorTest.assertTrue((!property.hasAttribute("value-is-null") ? 1 : 0) != 0);
        JspInspectionResultProcessorTest.assertEquals((String)"first result of ${abc} middle result of ${def} last", (String)property.getAttribute("value-is-embedded-el"));
        JspInspectionResultProcessorTest.assertEquals((int)2, (int)property.getAttributes().getLength());
        Element action = XmlUtils.getNextSiblingElement((Element)property);
        JspInspectionResultProcessorTest.assertEquals((String)"action", (String)action.getNodeName());
        JspInspectionResultProcessorTest.assertEquals((String)"bar3", (String)action.getAttribute("name"));
        JspInspectionResultProcessorTest.assertEquals((String)"result of ${baz2}", (String)action.getAttribute("value-is-el"));
        JspInspectionResultProcessorTest.assertEquals((String)"text", (String)action.getAttribute("value-is-text"));
        JspInspectionResultProcessorTest.assertEquals((int)3, (int)action.getAttributes().getLength());
        JspInspectionResultProcessorTest.assertEquals((int)entity.getChildNodes().getLength(), (int)3);
    }

    public void testArrays() {
        String xml = "<?xml version=\"1.0\"?>";
        xml = xml + "<inspection-result xmlns=\"http://www.metawidget.org/inspection-result\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.metawidget.org/inspection-result ../../inspector/inspection-result-1.0.xsd\" version=\"1.0\">";
        xml = xml + "<entity type=\"Company\">";
        xml = xml + "<property name=\"employee\" lookup=\"${array1,}\" lookup2=\"${collection1,}\"/>";
        xml = xml + "</entity></inspection-result>";
        JspInspectionResultProcessor inspectionResultProcessor = new JspInspectionResultProcessor();
        HtmlMetawidgetTag metawidgetTag = new HtmlMetawidgetTag();
        metawidgetTag.setPageContext((PageContext)new JspMetawidgetTests.MockPageContext());
        String result = inspectionResultProcessor.processInspectionResult(xml, (Object)metawidgetTag, null, null, new String[0]);
        Document document = XmlUtils.documentFromString((String)result);
        Element entity = XmlUtils.getFirstChildElement((Element)document.getDocumentElement());
        Element property = XmlUtils.getFirstChildElement((Element)entity);
        JspInspectionResultProcessorTest.assertEquals((String)"employee", (String)property.getAttribute("name"));
        JspInspectionResultProcessorTest.assertEquals((String)"${array1\\,},${array1\\,}", (String)property.getAttribute("lookup"));
        JspInspectionResultProcessorTest.assertEquals((String)"${collection1\\,},${collection1\\,}", (String)property.getAttribute("lookup2"));
        JspInspectionResultProcessorTest.assertEquals((int)3, (int)property.getAttributes().getLength());
        JspInspectionResultProcessorTest.assertEquals((int)entity.getChildNodes().getLength(), (int)1);
    }
}

