/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.java5;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java5Inspector
extends BaseObjectInspector {
    public Java5Inspector() {
        this(new BaseObjectInspectorConfig());
    }

    public Java5Inspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    protected boolean shouldInspectPropertyAsEntity(Property property) {
        return true;
    }

    protected Map<String, String> inspectEntity(Class<?> declaredClass, Class<?> actualClass) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        if (Enum.class.isAssignableFrom(actualClass)) {
            Method methodValues = actualClass.getMethod("values", new Class[0]);
            Enum[] enums = (Enum[])methodValues.invoke(actualClass, new Object[0]);
            ArrayList lookup = CollectionUtils.newArrayList();
            ArrayList lookupLabels = CollectionUtils.newArrayList();
            for (Enum anEnum : enums) {
                lookup.add(anEnum.name());
                lookupLabels.add(anEnum.toString());
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
            attributes.put("lookup-labels", CollectionUtils.toString((Collection)lookupLabels));
            if (actualClass.isEnum()) {
                attributes.put("type", actualClass.getName());
            } else {
                attributes.put("type", actualClass.getSuperclass().getName());
            }
        }
        return attributes;
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        HashMap attributes = CollectionUtils.newHashMap();
        Type type = property.getGenericType();
        if (type instanceof ParameterizedType) {
            Type[] typeActuals = null;
            try {
                typeActuals = ((ParameterizedType)type).getActualTypeArguments();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (typeActuals != null && typeActuals.length > 0) {
                StringBuilder builder = new StringBuilder();
                for (Type typeActual : typeActuals) {
                    if (typeActual == null) continue;
                    if (builder.length() > 0) {
                        builder.append(StringUtils.SEPARATOR_COMMA);
                    }
                    if (typeActual instanceof Class) {
                        builder.append(((Class)typeActual).getName());
                        continue;
                    }
                    builder.append(typeActual.toString());
                }
                attributes.put("parameterized-type", builder.toString());
            }
        }
        return attributes;
    }
}

