/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.simple.ObjectUtils;

public class MigLayoutConfig {
    private int mNumberOfColumns = 1;
    private boolean mDebugMode = false;

    public MigLayoutConfig setNumberOfColumns(int numberOfColumns) {
        if (numberOfColumns < 1) {
            throw LayoutException.newException((String)"numberOfColumns must be >= 1");
        }
        this.mNumberOfColumns = numberOfColumns;
        return this;
    }

    public MigLayoutConfig setDebugMode(boolean debugMode) {
        this.mDebugMode = debugMode;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals((Object)this, (Object)that)) {
            return false;
        }
        if (this.mNumberOfColumns != ((MigLayoutConfig)that).mNumberOfColumns) {
            return false;
        }
        return this.mDebugMode == ((MigLayoutConfig)that).mDebugMode;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + this.mNumberOfColumns;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.mDebugMode);
        return hashCode;
    }

    protected int getNumberOfColumns() {
        return this.mNumberOfColumns;
    }

    protected boolean isDebugMode() {
        return this.mDebugMode;
    }
}

