/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.xsd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.xsd.XmlSchemaInspectorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSchemaInspector
extends BaseXmlInspector {
    private static final String COMPLEX_TYPE = "complexType";
    private static final String SIMPLE_TYPE = "simpleType";
    private static final String COMPLEX_CONTENT = "complexContent";
    private static final String SIMPLE_CONTENT = "simpleContent";
    private static final String REF = "ref";
    private static final String BASE = "base";
    private static final String ALL = "all";
    private static final String SEQUENCE = "sequence";
    private static final String EXTENSION = "extension";
    private static final String RESTRICTION = "restriction";
    private static final String ENUMERATION = "enumeration";
    private static final String VALUE = "value";

    public XmlSchemaInspector(XmlSchemaInspectorConfig config) {
        super((BaseXmlInspectorConfig)config);
    }

    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    protected String getReferenceAttribute() {
        return REF;
    }

    protected Element traverseFromTopLevelTypeToNamedChildren(Element topLevel) {
        Element complexType;
        if (SIMPLE_TYPE.equals(topLevel.getLocalName())) {
            return topLevel;
        }
        if (COMPLEX_TYPE.equals(topLevel.getLocalName())) {
            complexType = topLevel;
        } else {
            complexType = XmlUtils.getFirstChildElement((Element)topLevel);
            if (complexType == null) {
                if (!topLevel.hasAttribute("type")) {
                    return null;
                }
                complexType = XmlUtils.getChildWithAttributeValue((Element)topLevel.getOwnerDocument().getDocumentElement(), (String)"name", (String)topLevel.getAttribute("type"));
                if (complexType == null) {
                    return null;
                }
            }
            if (!COMPLEX_TYPE.equals(complexType.getLocalName())) {
                throw InspectorException.newException((String)("Unexpected child node '" + complexType.getLocalName() + "'"));
            }
        }
        Element sequence = XmlUtils.getFirstChildElement((Element)complexType);
        if (sequence == null) {
            return null;
        }
        String sequenceLocalName = sequence.getLocalName();
        if ("annotation".equals(sequenceLocalName)) {
            sequence = XmlUtils.getNextSiblingElement((Element)sequence);
            sequenceLocalName = sequence.getLocalName();
        }
        if (!(SEQUENCE.equals(sequenceLocalName) || ALL.equals(sequenceLocalName) || SIMPLE_CONTENT.equals(sequenceLocalName) || COMPLEX_CONTENT.equals(sequenceLocalName) || "attributeGroup".equals(sequenceLocalName))) {
            throw InspectorException.newException((String)("Unexpected child node '" + sequenceLocalName + "'"));
        }
        Element choice = XmlUtils.getChildNamed((Element)sequence, (String[])new String[]{"choice"});
        if (choice != null) {
            return choice;
        }
        return sequence;
    }

    protected void inspectTraits(Element toInspect, Element toAddTo) {
        Element toInspectToUse = toInspect;
        if (SIMPLE_TYPE.equals(toInspectToUse.getLocalName())) {
            HashMap attributes = CollectionUtils.newHashMap();
            this.inspectRestriction(toInspectToUse, attributes);
            XmlUtils.setMapAsAttributes((Element)toAddTo, (Map)attributes);
            return;
        }
        if (SIMPLE_CONTENT.equals(toInspectToUse.getLocalName())) {
            HashMap attributes = CollectionUtils.newHashMap();
            this.inspectExtension(toInspectToUse, attributes);
            this.inspectRestriction(toInspectToUse, attributes);
            XmlUtils.setMapAsAttributes((Element)toAddTo, (Map)attributes);
            return;
        }
        if (COMPLEX_CONTENT.equals(toInspectToUse.getLocalName())) {
            if ((toInspectToUse = XmlUtils.getChildNamed((Element)toInspectToUse, (String[])new String[]{EXTENSION})) == null) {
                throw InspectorException.newException((String)"Expected complexContent to have an extension");
            }
            String base = toInspectToUse.getAttribute(BASE);
            if (base == null) {
                throw InspectorException.newException((String)"Expected extension to have a base");
            }
            Element baseElement = XmlUtils.getChildWithAttributeValue((Element)toInspectToUse.getOwnerDocument().getDocumentElement(), (String)this.getTopLevelTypeAttribute(), (String)base);
            Element baseSequence = XmlUtils.getFirstChildElement((Element)baseElement);
            if (!SEQUENCE.equals(baseSequence.getLocalName())) {
                throw InspectorException.newException((String)("Unexpected child node '" + baseSequence.getLocalName() + "'"));
            }
            this.inspectTraits(baseSequence, toAddTo);
            toInspectToUse = XmlUtils.getFirstChildElement((Element)toInspectToUse);
            if (!SEQUENCE.equals(toInspectToUse.getLocalName())) {
                throw InspectorException.newException((String)("Unexpected child node '" + toInspectToUse.getLocalName() + "'"));
            }
        }
        super.inspectTraits(toInspectToUse, toAddTo);
    }

    protected Map<String, String> inspectProperty(Element toInspect) {
        Element toInspectToUse;
        HashMap attributes;
        block10: {
            attributes = CollectionUtils.newHashMap();
            toInspectToUse = toInspect;
            while (true) {
                Element typeToUse;
                if (toInspectToUse == null) {
                    return null;
                }
                if ("any".equals(toInspectToUse.getLocalName())) {
                    return null;
                }
                if (toInspectToUse.hasAttribute(REF)) {
                    String name = toInspectToUse.getAttribute(REF);
                    if (!attributes.containsKey("name")) {
                        attributes.put("name", name);
                    }
                    toInspectToUse = XmlUtils.getChildWithAttributeValue((Element)toInspectToUse.getOwnerDocument().getDocumentElement(), (String)this.getTopLevelTypeAttribute(), (String)name);
                    continue;
                }
                if (toInspectToUse.hasChildNodes() || !toInspectToUse.hasAttribute("type")) break;
                this.inspectElement(toInspectToUse, attributes);
                if (!attributes.containsKey("name")) {
                    attributes.put("name", toInspectToUse.getAttribute("name"));
                }
                if ((typeToUse = XmlUtils.getChildWithAttributeValue((Element)toInspectToUse.getOwnerDocument().getDocumentElement(), (String)this.getTopLevelTypeAttribute(), (String)toInspectToUse.getAttribute("type"))) != null) {
                    toInspectToUse = typeToUse;
                    continue;
                }
                break block10;
                break;
            }
            if (COMPLEX_TYPE.equals(toInspectToUse.getLocalName())) {
                Element simpleContent = XmlUtils.getChildNamed((Element)toInspectToUse, (String[])new String[]{SIMPLE_CONTENT});
                if (simpleContent != null) {
                    this.inspectExtension(simpleContent, attributes);
                    this.inspectRestriction(simpleContent, attributes);
                }
                return attributes;
            }
            if (!attributes.containsKey("name") && toInspectToUse.hasAttribute("name")) {
                attributes.put("name", toInspectToUse.getAttribute("name"));
            }
        }
        this.inspectElement(toInspectToUse, attributes);
        return attributes;
    }

    private void inspectElement(Element element, Map<String, String> attributes) {
        if (element.hasAttribute("type")) {
            attributes.put("type", element.getAttribute("type"));
        } else {
            Element complexType = XmlUtils.getChildNamed((Element)element, (String[])new String[]{COMPLEX_TYPE});
            if (complexType != null) {
                Element simpleContent = XmlUtils.getChildNamed((Element)complexType, (String[])new String[]{SIMPLE_CONTENT});
                if (simpleContent != null) {
                    this.inspectExtension(simpleContent, attributes);
                    this.inspectRestriction(simpleContent, attributes);
                }
            } else if (SIMPLE_TYPE.equals(element.getLocalName())) {
                this.inspectRestriction(element, attributes);
            } else {
                Element simpleType = XmlUtils.getChildNamed((Element)element, (String[])new String[]{SIMPLE_TYPE});
                if (simpleType != null) {
                    this.inspectRestriction(simpleType, attributes);
                }
            }
        }
        String notNull = element.getAttribute("minOccurs");
        if (!"".equals(notNull) && Integer.parseInt(notNull) > 0) {
            attributes.put("required", "true");
        }
    }

    private void inspectExtension(Element parent, Map<String, String> attributes) {
        Element extension = XmlUtils.getChildNamed((Element)parent, (String[])new String[]{EXTENSION});
        if (extension == null) {
            return;
        }
        if (extension.hasAttribute(BASE)) {
            attributes.put("type", extension.getAttribute(BASE));
        }
    }

    private void inspectRestriction(Element parent, Map<String, String> attributes) {
        Element enumeration;
        Element fractionDigits;
        Element maxInclusive;
        Element minInclusive;
        Element maxLength;
        Element minLength;
        Element restriction = XmlUtils.getChildNamed((Element)parent, (String[])new String[]{RESTRICTION});
        if (restriction == null) {
            return;
        }
        if (restriction.hasAttribute(BASE)) {
            attributes.put("type", restriction.getAttribute(BASE));
        }
        if ((minLength = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{"minLength"})) != null) {
            attributes.put("minimum-length", minLength.getAttribute(VALUE));
        }
        if ((maxLength = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{"maxLength"})) != null) {
            attributes.put("maximum-length", maxLength.getAttribute(VALUE));
        }
        if ((minInclusive = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{"minInclusive"})) != null) {
            attributes.put("minimum-value", minInclusive.getAttribute(VALUE));
        }
        if ((maxInclusive = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{"maxInclusive"})) != null) {
            attributes.put("maximum-value", maxInclusive.getAttribute(VALUE));
        }
        if ((fractionDigits = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{"fractionDigits"})) != null) {
            attributes.put("maximum-fractional-digits", fractionDigits.getAttribute(VALUE));
        }
        if ((enumeration = XmlUtils.getChildNamed((Element)restriction, (String[])new String[]{ENUMERATION})) != null) {
            ArrayList lookup = CollectionUtils.newArrayList();
            while (enumeration != null) {
                lookup.add(enumeration.getAttribute(VALUE));
                enumeration = XmlUtils.getSiblingNamed((Element)enumeration, (String)ENUMERATION);
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
        }
    }
}

