/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.Address;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.cluster.ClientLocalListener;
import org.mobicents.cluster.ClientLocalListenerComparator;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.cache.ClusteredCacheData;
import org.mobicents.cluster.cache.ClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.cache.DefaultClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.election.SingletonElector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener(sync=false)
public class DefaultMobicentsCluster
implements MobicentsCluster {
    private static final Logger logger = Logger.getLogger(DefaultMobicentsCluster.class);
    private final SortedSet<ClientLocalListener> localListeners = Collections.synchronizedSortedSet(new TreeSet<ClientLocalListener>(new ClientLocalListenerComparator()));
    private final MobicentsCache mobicentsCache;
    private final TransactionManager txMgr;
    private final SingletonElector elector;
    private final DefaultClusteredCacheDataIndexingHandler clusteredCacheDataIndexingHandler;
    private List<Address> currentView;

    public DefaultMobicentsCluster(MobicentsCache watchedCache, TransactionManager txMgr, SingletonElector elector) {
        this.mobicentsCache = watchedCache;
        Cache cache = watchedCache.getJBossCache();
        if (!cache.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.LOCAL)) {
            this.currentView = new ArrayList<Address>(cache.getConfiguration().getRuntimeConfig().getChannel().getView().getMembers());
            cache.addCacheListener((Object)this);
        }
        this.txMgr = txMgr;
        this.elector = elector;
        this.clusteredCacheDataIndexingHandler = new DefaultClusteredCacheDataIndexingHandler();
    }

    @Override
    public Address getLocalAddress() {
        return this.mobicentsCache.getJBossCache().getLocalAddress();
    }

    @Override
    public List<Address> getClusterMembers() {
        if (this.currentView != null) {
            return Collections.unmodifiableList(this.currentView);
        }
        Address localAddress = this.getLocalAddress();
        if (localAddress == null) {
            return Collections.emptyList();
        }
        ArrayList<Address> list = new ArrayList<Address>();
        list.add(localAddress);
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean isHeadMember() {
        Address localAddress = this.getLocalAddress();
        if (localAddress != null) {
            List<Address> clusterMembers = this.getClusterMembers();
            return !clusterMembers.isEmpty() && clusterMembers.get(0).equals(localAddress);
        }
        return true;
    }

    @ViewChanged
    public synchronized void onViewChangeEvent(ViewChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : pre[" + event.isPre() + "] : event local address[" + event.getCache().getLocalAddress() + "]"));
        }
        final List<Address> oldView = this.currentView;
        this.currentView = new ArrayList<Address>(event.getNewView().getMembers());
        final Address localAddress = this.getLocalAddress();
        Runnable runnable = new Runnable(){

            public void run() {
                for (Address oldMember : oldView) {
                    if (DefaultMobicentsCluster.this.currentView.contains(oldMember)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onViewChangeEvent : processing lost member " + oldMember));
                    }
                    if (!DefaultMobicentsCluster.this.elector.elect(DefaultMobicentsCluster.this.currentView).equals(localAddress)) continue;
                    DefaultMobicentsCluster.this.performTakeOver(oldMember, localAddress);
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTakeOver(Address lostMember, Address localAddress) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : failing over lost member " + lostMember));
        }
        Cache jbossCache = this.mobicentsCache.getJBossCache();
        for (ClientLocalListener localListener : this.localListeners) {
            Fqn rootFqnOfChanges = localListener.getBaseFqn();
            boolean createdTx = false;
            boolean doRollback = true;
            try {
                if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                localListener.failOverClusterMember(lostMember);
                for (Object childName : jbossCache.getChildrenNames(rootFqnOfChanges)) {
                    Address address;
                    ClusteredCacheData clusteredCacheData = new ClusteredCacheData(Fqn.fromRelativeElements((Fqn)rootFqnOfChanges, (Object[])new Object[]{childName}), this);
                    if (!clusteredCacheData.exists() || (address = clusteredCacheData.getClusterNodeAddress()) == null || !address.equals(lostMember)) continue;
                    localListener.wonOwnership(clusteredCacheData);
                    clusteredCacheData.setClusterNodeAddress(localAddress);
                }
                doRollback = false;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (!createdTx) continue;
                try {
                    if (!doRollback) {
                        this.txMgr.commit();
                        continue;
                    }
                    this.txMgr.rollback();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean addLocalListener(ClientLocalListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding local listener " + localListener));
        }
        return this.localListeners.add(localListener);
    }

    @Override
    public boolean removeLocalListener(ClientLocalListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing local listener " + localListener));
        }
        return this.localListeners.remove(localListener);
    }

    @Override
    public MobicentsCache getMobicentsCache() {
        return this.mobicentsCache;
    }

    @Override
    public ClusteredCacheDataIndexingHandler getClusteredCacheDataIndexingHandler() {
        return this.clusteredCacheDataIndexingHandler;
    }
}

