/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.buddyreplication.BuddyGroup;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.BuddyGroupChanged;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.BuddyGroupChangedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.Address;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.cluster.DataRemovalListener;
import org.mobicents.cluster.FailOverListener;
import org.mobicents.cluster.FailOverListenerPriorityComparator;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.cache.ClusteredCacheData;
import org.mobicents.cluster.cache.ClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.cache.DefaultClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.election.ClientLocalListenerElector;
import org.mobicents.cluster.election.ClusterElector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener(sync=false)
public class DefaultMobicentsCluster
implements MobicentsCluster {
    private static final String FQN_SEPARATOR = "/";
    private static final String BUDDY_BACKUP_FQN_ROOT = "/_BUDDY_BACKUP_/";
    private static final Logger logger = Logger.getLogger(DefaultMobicentsCluster.class);
    private static final String BUDDIES_STORE = "MC_BUDDIES";
    private final SortedSet<FailOverListener> failOverListeners = Collections.synchronizedSortedSet(new TreeSet<FailOverListener>(new FailOverListenerPriorityComparator()));
    private final ConcurrentHashMap<Fqn, DataRemovalListener> dataRemovalListeners = new ConcurrentHashMap();
    private final MobicentsCache mobicentsCache;
    private final TransactionManager txMgr;
    private final ClusterElector elector;
    private final DefaultClusteredCacheDataIndexingHandler clusteredCacheDataIndexingHandler;
    private List<Address> currentView;
    private boolean started;

    public DefaultMobicentsCluster(MobicentsCache watchedCache, TransactionManager txMgr, ClusterElector elector) {
        this.mobicentsCache = watchedCache;
        this.txMgr = txMgr;
        this.elector = elector;
        this.clusteredCacheDataIndexingHandler = new DefaultClusteredCacheDataIndexingHandler();
    }

    @Override
    public Address getLocalAddress() {
        return this.mobicentsCache.getJBossCache().getLocalAddress();
    }

    @Override
    public List<Address> getClusterMembers() {
        if (this.currentView != null) {
            return Collections.unmodifiableList(this.currentView);
        }
        Address localAddress = this.getLocalAddress();
        if (localAddress == null) {
            return Collections.emptyList();
        }
        ArrayList<Address> list = new ArrayList<Address>();
        list.add(localAddress);
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean isHeadMember() {
        Address localAddress = this.getLocalAddress();
        if (localAddress != null) {
            List<Address> clusterMembers = this.getClusterMembers();
            return !clusterMembers.isEmpty() && clusterMembers.get(0).equals(localAddress);
        }
        return true;
    }

    @Override
    public boolean isSingleMember() {
        Address localAddress = this.getLocalAddress();
        if (localAddress != null) {
            List<Address> clusterMembers = this.getClusterMembers();
            return clusterMembers.size() == 1;
        }
        return true;
    }

    @ViewChanged
    public synchronized void onViewChangeEvent(ViewChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : pre[" + event.isPre() + "] : event local address[" + event.getCache().getLocalAddress() + "]"));
        }
        final List<Address> oldView = this.currentView;
        this.currentView = new ArrayList<Address>(event.getNewView().getMembers());
        final Address localAddress = this.getLocalAddress();
        if (oldView != null) {
            Cache jbossCache = this.mobicentsCache.getJBossCache();
            Configuration config = jbossCache.getConfiguration();
            final boolean isBuddyReplicationEnabled = config.getBuddyReplicationConfig() != null && config.getBuddyReplicationConfig().isEnabled();
            Runnable runnable = new Runnable(){

                public void run() {
                    for (Address oldMember : oldView) {
                        if (DefaultMobicentsCluster.this.currentView.contains(oldMember)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("onViewChangeEvent : processing lost member " + oldMember));
                        }
                        for (FailOverListener localListener : DefaultMobicentsCluster.this.failOverListeners) {
                            ClientLocalListenerElector localListenerElector = localListener.getElector();
                            if (localListenerElector != null && !isBuddyReplicationEnabled) {
                                DefaultMobicentsCluster.this.performTakeOver(localListener, oldMember, localAddress, true, isBuddyReplicationEnabled);
                                continue;
                            }
                            List electionView = DefaultMobicentsCluster.this.getElectionView(oldMember);
                            if (electionView != null && DefaultMobicentsCluster.this.elector.elect(electionView).equals(localAddress)) {
                                DefaultMobicentsCluster.this.performTakeOver(localListener, oldMember, localAddress, false, isBuddyReplicationEnabled);
                            }
                            DefaultMobicentsCluster.this.cleanAfterTakeOver(localListener, oldMember);
                        }
                    }
                }
            };
            Thread t = new Thread(runnable);
            t.start();
        }
    }

    @BuddyGroupChanged
    public void onBuddyGroupChangedEvent(BuddyGroupChangedEvent event) {
        Node root = event.getCache().getRoot();
        root.put((Object)BUDDIES_STORE, (Object)event.getBuddyGroup().getBuddies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTakeOver(FailOverListener localListener, Address lostMember, Address localAddress, boolean useLocalListenerElector, boolean isBuddyReplicationEnabled) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : " + localAddress + " failing over lost member " + lostMember + ", useLocalListenerElector=" + useLocalListenerElector + ", isBuddyReplicationEnabled=" + isBuddyReplicationEnabled));
        }
        Cache jbossCache = this.mobicentsCache.getJBossCache();
        Fqn rootFqnOfChanges = localListener.getBaseFqn();
        boolean createdTx = false;
        boolean doRollback = true;
        try {
            if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                this.txMgr.begin();
                createdTx = true;
            }
            if (isBuddyReplicationEnabled) {
                String fqn = this.getBuddyBackupFqn(lostMember) + localListener.getBaseFqn();
                Node buddyGroupRootNode = jbossCache.getNode(Fqn.fromString((String)fqn));
                if (buddyGroupRootNode != null) {
                    Set children = buddyGroupRootNode.getChildren();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Fqn : " + fqn + " : children " + children));
                    }
                    for (Node child : children) {
                        Fqn childFqn = Fqn.fromRelativeElements((Fqn)localListener.getBaseFqn(), (Object[])new Object[]{child.getFqn().getLastElement()});
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("forcing data gravitation on following child fqn " + childFqn));
                        }
                        jbossCache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                        Node n = jbossCache.getNode(childFqn);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Fqn : " + fqn + " : doesn't return any node, this node  " + localAddress + "might not be a buddy group of the failed node " + lostMember));
                }
            }
            if (createdTx) {
                this.txMgr.commit();
                createdTx = false;
            }
            if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                this.txMgr.begin();
                createdTx = true;
            }
            localListener.failOverClusterMember(lostMember);
            Set children = jbossCache.getChildrenNames(rootFqnOfChanges);
            for (Object childName : children) {
                ClusteredCacheData clusteredCacheData = new ClusteredCacheData(Fqn.fromRelativeElements((Fqn)rootFqnOfChanges, (Object[])new Object[]{childName}), this);
                if (clusteredCacheData.exists()) {
                    Address address = clusteredCacheData.getClusterNodeAddress();
                    if (address == null || !address.equals(lostMember) || !isBuddyReplicationEnabled && useLocalListenerElector && !localAddress.equals(localListener.getElector().elect(this.currentView, clusteredCacheData))) continue;
                    localListener.wonOwnership(clusteredCacheData);
                    clusteredCacheData.setClusterNodeAddress(localAddress);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(" Attempt to index: " + Fqn.fromRelativeElements((Fqn)rootFqnOfChanges, (Object[])new Object[]{childName}) + " failed, node does not exist."));
            }
            doRollback = false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (createdTx) {
                try {
                    if (!doRollback) {
                        this.txMgr.commit();
                    } else {
                        this.txMgr.rollback();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @NodeRemoved
    public void onNodeRemovedEvent(NodeRemovedEvent event) {
        DataRemovalListener dataRemovalListener;
        if (!event.isOriginLocal() && !event.isPre() && (dataRemovalListener = this.dataRemovalListeners.get(event.getFqn().getParent())) != null) {
            dataRemovalListener.dataRemoved(event.getFqn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Address> getElectionView(Address deadMember) {
        boolean isBuddyReplicationEnabled;
        Cache jbossCache = this.mobicentsCache.getJBossCache();
        Configuration config = jbossCache.getConfiguration();
        boolean bl = isBuddyReplicationEnabled = config.getBuddyReplicationConfig() != null && config.getBuddyReplicationConfig().isEnabled();
        if (isBuddyReplicationEnabled) {
            boolean createdTx = false;
            boolean doRollback = true;
            try {
                String fqnBackupRoot;
                Node backupRoot;
                if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                    this.txMgr.begin();
                    createdTx = true;
                }
                if ((backupRoot = jbossCache.getNode(fqnBackupRoot = this.getBuddyBackupFqn(deadMember))) != null) {
                    ArrayList<Address> buddies = (ArrayList<Address>)backupRoot.get((Object)BUDDIES_STORE);
                    if (buddies == null) {
                        buddies = new ArrayList<Address>();
                        buddies.add(config.getRuntimeConfig().getChannel().getLocalAddress());
                    }
                    ArrayList<Address> arrayList = buddies;
                    return arrayList;
                }
                List<Address> list = null;
                return list;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (createdTx) {
                    try {
                        if (!doRollback) {
                            this.txMgr.commit();
                        } else {
                            this.txMgr.rollback();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            return null;
        }
        return this.currentView;
    }

    private String getBuddyBackupFqn(Address owner) {
        String lostMemberFqnizied = owner.toString().replace(":", "_");
        String fqn = BUDDY_BACKUP_FQN_ROOT + lostMemberFqnizied;
        return fqn;
    }

    private void cleanAfterTakeOver(FailOverListener localListener, Address deadMember) {
        boolean isBuddyReplicationEnabled;
        Cache jbossCache = this.mobicentsCache.getJBossCache();
        Configuration config = jbossCache.getConfiguration();
        boolean bl = isBuddyReplicationEnabled = config.getBuddyReplicationConfig() != null && config.getBuddyReplicationConfig().isEnabled();
        if (isBuddyReplicationEnabled) {
            String fqn = this.getBuddyBackupFqn(deadMember) + localListener.getBaseFqn();
            jbossCache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            jbossCache.removeNode(Fqn.fromString((String)fqn));
            BuddyGroup bg = config.getRuntimeConfig().getBuddyGroup();
            if (bg != null && bg.getBuddies().size() == 1 && bg.getBuddies().contains(deadMember)) {
                jbossCache.getRoot().remove((Object)BUDDIES_STORE);
            }
        }
    }

    @Override
    public boolean addFailOverListener(FailOverListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding local listener " + localListener));
        }
        for (FailOverListener failOverListener : this.failOverListeners) {
            if (!failOverListener.getBaseFqn().equals((Object)localListener.getBaseFqn())) continue;
            return false;
        }
        return this.failOverListeners.add(localListener);
    }

    @Override
    public boolean removeFailOverListener(FailOverListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing local listener " + localListener));
        }
        return this.failOverListeners.remove(localListener);
    }

    @Override
    public boolean addDataRemovalListener(DataRemovalListener listener) {
        return this.dataRemovalListeners.putIfAbsent(listener.getBaseFqn(), listener) == null;
    }

    @Override
    public boolean removeDataRemovalListener(DataRemovalListener listener) {
        return this.dataRemovalListeners.remove(listener.getBaseFqn()) != null;
    }

    @Override
    public MobicentsCache getMobicentsCache() {
        return this.mobicentsCache;
    }

    @Override
    public ClusteredCacheDataIndexingHandler getClusteredCacheDataIndexingHandler() {
        return this.clusteredCacheDataIndexingHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCluster() {
        DefaultMobicentsCluster defaultMobicentsCluster = this;
        synchronized (defaultMobicentsCluster) {
            if (this.started) {
                throw new IllegalStateException("cluster already started");
            }
            this.mobicentsCache.startCache();
            Cache cache = this.mobicentsCache.getJBossCache();
            if (!cache.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.LOCAL)) {
                this.currentView = new ArrayList<Address>(cache.getConfiguration().getRuntimeConfig().getChannel().getView().getMembers());
                cache.addCacheListener((Object)this);
                Configuration conf = cache.getConfiguration();
                if (conf.getBuddyReplicationConfig() != null && conf.getBuddyReplicationConfig().isEnabled() && conf.getRuntimeConfig().getBuddyGroup() != null) {
                    Node root = cache.getRoot();
                    root.put((Object)BUDDIES_STORE, (Object)conf.getRuntimeConfig().getBuddyGroup().getBuddies());
                }
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        DefaultMobicentsCluster defaultMobicentsCluster = this;
        synchronized (defaultMobicentsCluster) {
            return this.started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCluster() {
        DefaultMobicentsCluster defaultMobicentsCluster = this;
        synchronized (defaultMobicentsCluster) {
            if (!this.started) {
                throw new IllegalStateException("cluster already started");
            }
            this.mobicentsCache.stopCache();
            this.started = false;
        }
    }
}

