/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.util.CachePrinter;

public class MobicentsCache {
    private static Logger logger = Logger.getLogger(MobicentsCache.class);
    private final Cache jBossCache;
    private boolean localMode;
    private final boolean managedCache;

    public MobicentsCache(Configuration cacheConfiguration) {
        this.jBossCache = new DefaultCacheFactory().createCache(cacheConfiguration, false);
        this.managedCache = false;
        this.setLocalMode();
    }

    public MobicentsCache(String cacheConfigurationLocation) {
        this.jBossCache = new DefaultCacheFactory().createCache(cacheConfigurationLocation, false);
        this.managedCache = false;
        this.setLocalMode();
    }

    public MobicentsCache(CacheManager haCacheManager, String cacheName, boolean managedCache) throws Exception {
        this.jBossCache = haCacheManager.getCache(cacheName, true);
        this.jBossCache.create();
        this.managedCache = managedCache;
        this.setLocalMode();
    }

    public MobicentsCache(Cache cache) {
        this.jBossCache = cache;
        this.managedCache = true;
        this.setLocalMode();
    }

    private void setLocalMode() {
        if (this.jBossCache.getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL) {
            this.localMode = true;
        }
    }

    public void startCache() {
        if (CacheStatus.STARTED != this.jBossCache.getCacheStatus()) {
            logger.info((Object)"Starting JBoss Cache...");
            this.jBossCache.start();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Mobicents Cache started, status: " + this.jBossCache.getCacheStatus() + ", Mode: " + this.jBossCache.getConfiguration().getCacheModeString()));
        }
    }

    public Cache getJBossCache() {
        return this.jBossCache;
    }

    public void stopCache() {
        if (!this.managedCache) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Mobicents Cache stopping...");
            }
            this.jBossCache.stop();
            this.jBossCache.destroy();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Mobicents Cache stopped.");
        }
    }

    public boolean isLocalMode() {
        return this.localMode;
    }

    public void setReplicationClassLoader(Fqn regionFqn, ClassLoader classLoader) {
        if (!this.isLocalMode()) {
            Region region = this.jBossCache.getRegion(regionFqn, true);
            region.registerContextClassLoader(classLoader);
            if (!region.isActive() && this.jBossCache.getCacheStatus() == CacheStatus.STARTED) {
                region.activate();
            }
        }
    }

    public void setReplicationClassLoader(ClassLoader classLoader) {
        this.setReplicationClassLoader(Fqn.ROOT, classLoader);
    }

    public void unsetReplicationClassLoader(Fqn regionFqn, ClassLoader classLoader) {
        Region region;
        if (!this.isLocalMode() && (region = this.jBossCache.getRegion(regionFqn, true)) != null) {
            if (region.isActive()) {
                region.deactivate();
            }
            region.unregisterContextClassLoader();
            this.jBossCache.removeRegion(regionFqn);
        }
    }

    public void unsetReplicationClassLoader(ClassLoader classLoader) {
        this.unsetReplicationClassLoader(Fqn.ROOT, classLoader);
    }

    public String getCacheContent() {
        return "Mobicents Cache: \n+-- Content:\n" + CachePrinter.printCacheDetails((Cache)this.jBossCache);
    }
}

