/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.NodeRemovedEvent;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.Address;
import org.mobicents.cache.MobicentsCache;
import org.mobicents.cluster.DataRemovalListener;
import org.mobicents.cluster.FailOverListener;
import org.mobicents.cluster.FailOverListenerPriorityComparator;
import org.mobicents.cluster.MobicentsCluster;
import org.mobicents.cluster.cache.ClusteredCacheData;
import org.mobicents.cluster.cache.ClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.cache.DefaultClusteredCacheDataIndexingHandler;
import org.mobicents.cluster.election.ClientLocalListenerElector;
import org.mobicents.cluster.election.ClusterElector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener(sync=false)
public class DefaultMobicentsCluster
implements MobicentsCluster {
    private static final String FQN_SEPARATOR = "/";
    private static final String BUDDY_BACKUP_FQN_ROOT = "/_BUDDY_BACKUP_/";
    private static final Logger logger = Logger.getLogger(DefaultMobicentsCluster.class);
    private final SortedSet<FailOverListener> failOverListeners = Collections.synchronizedSortedSet(new TreeSet<FailOverListener>(new FailOverListenerPriorityComparator()));
    private final ConcurrentHashMap<Fqn, DataRemovalListener> dataRemovalListeners = new ConcurrentHashMap();
    private final MobicentsCache mobicentsCache;
    private final TransactionManager txMgr;
    private final ClusterElector elector;
    private final DefaultClusteredCacheDataIndexingHandler clusteredCacheDataIndexingHandler;
    private List<Address> currentView;

    public DefaultMobicentsCluster(MobicentsCache watchedCache, TransactionManager txMgr, ClusterElector elector) {
        this.mobicentsCache = watchedCache;
        Cache cache = watchedCache.getJBossCache();
        if (!cache.getConfiguration().getCacheMode().equals((Object)Configuration.CacheMode.LOCAL)) {
            this.currentView = new ArrayList<Address>(cache.getConfiguration().getRuntimeConfig().getChannel().getView().getMembers());
            cache.addCacheListener((Object)this);
        }
        this.txMgr = txMgr;
        this.elector = elector;
        this.clusteredCacheDataIndexingHandler = new DefaultClusteredCacheDataIndexingHandler();
    }

    @Override
    public Address getLocalAddress() {
        return this.mobicentsCache.getJBossCache().getLocalAddress();
    }

    @Override
    public List<Address> getClusterMembers() {
        if (this.currentView != null) {
            return Collections.unmodifiableList(this.currentView);
        }
        Address localAddress = this.getLocalAddress();
        if (localAddress == null) {
            return Collections.emptyList();
        }
        ArrayList<Address> list = new ArrayList<Address>();
        list.add(localAddress);
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean isHeadMember() {
        Address localAddress = this.getLocalAddress();
        if (localAddress != null) {
            List<Address> clusterMembers = this.getClusterMembers();
            return !clusterMembers.isEmpty() && clusterMembers.get(0).equals(localAddress);
        }
        return true;
    }

    @Override
    public boolean isSingleMember() {
        Address localAddress = this.getLocalAddress();
        if (localAddress != null) {
            List<Address> clusterMembers = this.getClusterMembers();
            return clusterMembers.size() == 1;
        }
        return true;
    }

    @ViewChanged
    public synchronized void onViewChangeEvent(ViewChangedEvent event) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : pre[" + event.isPre() + "] : event local address[" + event.getCache().getLocalAddress() + "]"));
        }
        final List<Address> oldView = this.currentView;
        this.currentView = new ArrayList<Address>(event.getNewView().getMembers());
        final Address localAddress = this.getLocalAddress();
        Runnable runnable = new Runnable(){

            public void run() {
                for (Address oldMember : oldView) {
                    if (DefaultMobicentsCluster.this.currentView.contains(oldMember)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("onViewChangeEvent : processing lost member " + oldMember));
                    }
                    for (FailOverListener localListener : DefaultMobicentsCluster.this.failOverListeners) {
                        boolean electionDone = false;
                        boolean elected = false;
                        ClientLocalListenerElector localListenerElector = localListener.getElector();
                        if (localListenerElector != null) {
                            DefaultMobicentsCluster.this.performTakeOver(localListener, oldMember, localAddress, true);
                            continue;
                        }
                        if (!electionDone) {
                            electionDone = true;
                            elected = DefaultMobicentsCluster.this.elector.elect(DefaultMobicentsCluster.this.currentView).equals(localAddress);
                        }
                        if (!elected) continue;
                        DefaultMobicentsCluster.this.performTakeOver(localListener, oldMember, localAddress, false);
                    }
                }
            }
        };
        Thread t = new Thread(runnable);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performTakeOver(FailOverListener localListener, Address lostMember, Address localAddress, boolean useLocalListenerElector) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("onViewChangeEvent : failing over lost member " + lostMember));
        }
        Cache jbossCache = this.mobicentsCache.getJBossCache();
        Fqn rootFqnOfChanges = localListener.getBaseFqn();
        boolean createdTx = false;
        boolean doRollback = true;
        try {
            if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                this.txMgr.begin();
                createdTx = true;
            }
            if (jbossCache.getConfiguration().getBuddyReplicationConfig().isEnabled()) {
                String lostMemberFqnizied = lostMember.toString().replace(":", "_");
                String fqn = BUDDY_BACKUP_FQN_ROOT + lostMemberFqnizied + localListener.getBaseFqn();
                Node buddyGroupRootNode = jbossCache.getNode(Fqn.fromString((String)fqn));
                Set children = buddyGroupRootNode.getChildren();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Fqn : " + fqn + " : children " + children));
                }
                for (Node child : children) {
                    Fqn childFqn = Fqn.fromString((String)(localListener.getBaseFqn().toString() + FQN_SEPARATOR + child.getFqn().getLastElementAsString()));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("forcing data gravitation on following child fqn " + childFqn));
                    }
                    jbossCache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                    jbossCache.getNode(childFqn);
                }
            }
            if (createdTx) {
                this.txMgr.commit();
                createdTx = false;
            }
            if (this.txMgr != null && this.txMgr.getTransaction() == null) {
                this.txMgr.begin();
                createdTx = true;
            }
            localListener.failOverClusterMember(lostMember);
            for (Object childName : jbossCache.getChildrenNames(rootFqnOfChanges)) {
                ClusteredCacheData clusteredCacheData = new ClusteredCacheData(Fqn.fromRelativeElements((Fqn)rootFqnOfChanges, (Object[])new Object[]{childName}), this);
                if (clusteredCacheData.exists()) {
                    Address address = clusteredCacheData.getClusterNodeAddress();
                    if (address == null || !address.equals(lostMember) || useLocalListenerElector && !localAddress.equals(localListener.getElector().elect(this.currentView, clusteredCacheData))) continue;
                    localListener.wonOwnership(clusteredCacheData);
                    clusteredCacheData.setClusterNodeAddress(localAddress);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(" Attempt to index: " + Fqn.fromRelativeElements((Fqn)rootFqnOfChanges, (Object[])new Object[]{childName}) + " failed, node does not exist."));
            }
            doRollback = false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (createdTx) {
                try {
                    if (!doRollback) {
                        this.txMgr.commit();
                    } else {
                        this.txMgr.rollback();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @NodeRemoved
    public void onNodeRemovedEvent(NodeRemovedEvent event) {
        DataRemovalListener dataRemovalListener;
        if (!event.isOriginLocal() && (dataRemovalListener = this.dataRemovalListeners.get(event.getFqn().getParent())) != null) {
            dataRemovalListener.dataRemoved(event.getFqn());
        }
    }

    @Override
    public boolean addFailOverListener(FailOverListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding local listener " + localListener));
        }
        for (FailOverListener failOverListener : this.failOverListeners) {
            if (!failOverListener.getBaseFqn().equals((Object)localListener.getBaseFqn())) continue;
            return false;
        }
        return this.failOverListeners.add(localListener);
    }

    @Override
    public boolean removeFailOverListener(FailOverListener localListener) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Removing local listener " + localListener));
        }
        return this.failOverListeners.remove(localListener);
    }

    @Override
    public boolean addDataRemovalListener(DataRemovalListener listener) {
        return this.dataRemovalListeners.putIfAbsent(listener.getBaseFqn(), listener) == null;
    }

    @Override
    public boolean removeDataRemovalListener(DataRemovalListener listener) {
        return this.dataRemovalListeners.remove(listener.getBaseFqn()) != null;
    }

    @Override
    public MobicentsCache getMobicentsCache() {
        return this.mobicentsCache;
    }

    @Override
    public ClusteredCacheDataIndexingHandler getClusteredCacheDataIndexingHandler() {
        return this.clusteredCacheDataIndexingHandler;
    }
}

