/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.timers;

import java.util.concurrent.ScheduledFuture;
import org.apache.log4j.Logger;
import org.mobicents.timers.FaultTolerantScheduler;
import org.mobicents.timers.SetTimerAfterTxCommitRunnable;
import org.mobicents.timers.TimerTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimerTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(TimerTask.class);
    private final TimerTaskData data;
    private ScheduledFuture<?> scheduledFuture;
    private SetTimerAfterTxCommitRunnable action;
    private FaultTolerantScheduler scheduler;
    protected boolean autoRemoval = true;
    private transient boolean cancel;

    public TimerTask(TimerTaskData data) {
        this.data = data;
    }

    public TimerTaskData getData() {
        return this.data;
    }

    protected SetTimerAfterTxCommitRunnable getSetTimerTransactionalAction() {
        return this.action;
    }

    void setSetTimerTransactionalAction(SetTimerAfterTxCommitRunnable action) {
        this.action = action;
    }

    public ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    protected void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
        if (this.cancel) {
            this.scheduledFuture.cancel(false);
        }
    }

    protected void cancel() {
        this.cancel = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
        }
    }

    @Override
    public final void run() {
        if (this.data.getPeriod() < 0L && this.autoRemoval) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Task with id " + this.data.getTaskID() + " is not recurring, so removing it locally and in the cluster"));
            }
            this.removeFromScheduler();
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Task with id " + this.data.getTaskID() + " is recurring, not removing it locally nor in the cluster"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing Timer with id " + this.data.getTaskID()));
        }
        this.runTask();
    }

    protected void removeFromScheduler() {
        this.scheduler.remove(this.data.getTaskID(), true);
    }

    public abstract void runTask();

    public void beforeRecover() {
        long now = System.currentTimeMillis();
        if (this.data.getStartTime() < now) {
            this.data.setStartTime(now);
        }
    }

    public void setScheduler(FaultTolerantScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public FaultTolerantScheduler getScheduler() {
        return this.scheduler;
    }
}

