/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.SendFailedNotification;
import com.sun.nio.sctp.ShutdownNotification;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.AssociationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AssociationHandler
extends AbstractNotificationHandler<AssociationImpl> {
    private static final Logger logger = Logger.getLogger(AssociationHandler.class);

    @Override
    public HandlerResult handleNotification(AssociationChangeNotification not, AssociationImpl asscoitaion) {
        switch (not.event()) {
            case COMM_UP: {
                int outbound = not.association().maxOutboundStreams();
                int inbound = not.association().maxInboundStreams();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("New association setup for Association=%s with %d outbound streams, and %d inbound streams.\n", asscoitaion.getName(), outbound, inbound));
                }
                asscoitaion.createSLSTable(Math.min(inbound, outbound) - 1);
                asscoitaion.createworkerThreadTable(Math.max(inbound, outbound));
                asscoitaion.getAssociationListener().onCommunicationUp((Association)asscoitaion);
                return HandlerResult.CONTINUE;
            }
            case CANT_START: {
                logger.error((Object)String.format("Can't start for Association=%s", asscoitaion.getName()));
                return HandlerResult.CONTINUE;
            }
            case COMM_LOST: {
                logger.warn((Object)String.format("Communication lost for Association=%s", asscoitaion.getName()));
                asscoitaion.close();
                if (asscoitaion.getType() == AssociationType.CLIENT) {
                    asscoitaion.scheduleConnect();
                }
                asscoitaion.getAssociationListener().onCommunicationLost((Association)asscoitaion);
                return HandlerResult.RETURN;
            }
            case RESTART: {
                logger.warn((Object)String.format("Restart for Association=%s", asscoitaion.getName()));
                asscoitaion.getAssociationListener().onCommunicationRestart((Association)asscoitaion);
                return HandlerResult.CONTINUE;
            }
            case SHUTDOWN: {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)String.format("Shutdown for Association=%s", asscoitaion.getName()));
                }
                asscoitaion.getAssociationListener().onCommunicationShutdown((Association)asscoitaion);
                return HandlerResult.RETURN;
            }
        }
        return HandlerResult.CONTINUE;
    }

    @Override
    public HandlerResult handleNotification(ShutdownNotification not, AssociationImpl asscoitaion) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Association=%s SHUTDOWN", asscoitaion.getName()));
        }
        asscoitaion.getAssociationListener().onCommunicationShutdown((Association)asscoitaion);
        return HandlerResult.RETURN;
    }

    @Override
    public HandlerResult handleNotification(SendFailedNotification notification, AssociationImpl asscoitaion) {
        logger.error((Object)String.format("Association=%s SendFailedNotification", asscoitaion.getName()));
        return HandlerResult.RETURN;
    }
}

