/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Management;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.AssociationType;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.SctpXMLBinding;
import org.mobicents.protocols.sctp.SelectorThread;
import org.mobicents.protocols.sctp.ServerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementImpl
implements Management {
    private static final Logger logger = Logger.getLogger(ManagementImpl.class);
    private static final String SCTP_PERSIST_DIR_KEY = "sctp.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sctp.xml";
    private static final String SERVERS = "servers";
    private static final String ASSOCIATIONS = "associations";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    protected static final SctpXMLBinding binding = new SctpXMLBinding();
    protected static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private final String name;
    protected String persistDir = null;
    private FastList<Server> servers = new FastList();
    protected AssociationMap<String, Association> associations = new AssociationMap();
    private FastList<ChangeRequest> pendingChanges = new FastList();
    private Selector socketSelector = null;
    private SelectorThread selectorThread = null;
    static final int DEFAULT_IO_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private int workerThreads = DEFAULT_IO_THREADS;
    private boolean singleThread = false;
    private int workerThreadCount = 0;
    private int maxIOErrors = 3;
    private int connectDelay = 30000;
    private ExecutorService[] executorServices = null;
    private volatile boolean started = false;

    public ManagementImpl(String name) throws IOException {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(ServerImpl.class, "server");
        binding.setAlias(AssociationImpl.class, "association");
        binding.setAlias(String.class, "string");
        this.socketSelector = SelectorProvider.provider().openSelector();
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public int getConnectDelay() {
        return this.connectDelay;
    }

    public void setConnectDelay(int connectDelay) {
        this.connectDelay = connectDelay;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        if (workerThreads < 1) {
            workerThreads = DEFAULT_IO_THREADS;
        }
        this.workerThreads = workerThreads;
    }

    public int getMaxIOErrors() {
        return this.maxIOErrors;
    }

    public void setMaxIOErrors(int maxIOErrors) {
        if (maxIOErrors < 1) {
            maxIOErrors = 1;
        }
        this.maxIOErrors = maxIOErrors;
    }

    public boolean isSingleThread() {
        return this.singleThread;
    }

    public void setSingleThread(boolean singleThread) {
        this.singleThread = singleThread;
    }

    public void start() throws Exception {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCTP_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("SCTP configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SCTP configuration file. \n%s", e.getMessage()));
        }
        if (!this.singleThread) {
            this.executorServices = new ExecutorService[this.workerThreads];
            for (int i = 0; i < this.workerThreads; ++i) {
                this.executorServices[i] = Executors.newSingleThreadExecutor();
            }
        }
        this.selectorThread = new SelectorThread(this.socketSelector, this);
        this.selectorThread.setStarted(true);
        new Thread(this.selectorThread).start();
        this.started = true;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Started SCTP Management=%s WorkerThreads=%d SingleThread=%s", this.name, this.singleThread ? 0 : this.workerThreads, this.singleThread));
        }
    }

    public void stop() throws Exception {
        this.store();
        FastMap.Entry n = this.associations.head();
        FastMap.Entry end = this.associations.tail();
        while ((n = n.getNext()) != end) {
            Association associationTemp = (Association)n.getValue();
            if (!associationTemp.isStarted()) continue;
            ((AssociationImpl)associationTemp).stop();
        }
        n = this.servers.head();
        end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (!serverTemp.isStarted()) continue;
            try {
                ((ServerImpl)serverTemp).stop();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Exception while stopping the Server=%s", serverTemp.getName()), (Throwable)e);
            }
        }
        if (this.executorServices != null) {
            for (int i = 0; i < this.executorServices.length; ++i) {
                this.executorServices[i].shutdown();
            }
        }
        this.selectorThread.setStarted(false);
        this.socketSelector.wakeup();
        if (this.executorServices != null) {
            for (int i = 0; i < this.executorServices.length; ++i) {
                if (this.executorServices[i].isTerminated()) continue;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Waiting for worker thread to die gracefully ....");
                }
                try {
                    this.executorServices[i].awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.started = false;
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding((XMLBinding)binding);
            this.servers = (FastList)reader.read(SERVERS, FastList.class);
            FastList.Node n = this.servers.head();
            FastList.Node end = this.servers.tail();
            while ((n = n.getNext()) != end) {
                Server serverTemp = (Server)n.getValue();
                ((ServerImpl)serverTemp).setManagement(this);
                if (!serverTemp.isStarted()) continue;
                try {
                    ((ServerImpl)serverTemp).start();
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Error while initiating Server=%s", serverTemp.getName()), (Throwable)e);
                }
            }
            this.associations = (AssociationMap)((Object)reader.read(ASSOCIATIONS, AssociationMap.class));
            n = this.associations.head();
            end = this.associations.tail();
            while ((n = n.getNext()) != end) {
                AssociationImpl associationTemp = (AssociationImpl)n.getValue();
                associationTemp.setManagement(this);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding((XMLBinding)binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.servers, SERVERS, FastList.class);
            writer.write(this.associations, ASSOCIATIONS, AssociationMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public ServerImpl addServer(String serverName, String hostAddress, int port) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (hostAddress == null) {
            throw new Exception("Server host address cannot be null");
        }
        if (port < 1) {
            throw new Exception("Server host port cannot be less than 1");
        }
        FastList.Node n = this.servers.head();
        FastList.Node end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (serverName.equals(serverTemp.getName())) {
                throw new Exception(String.format("Server name=%s already exist", serverName));
            }
            if (!hostAddress.equals(serverTemp.getHostAddress()) || port != serverTemp.getHostport()) continue;
            throw new Exception(String.format("Server name=%s is already bound to %s:%d", serverTemp.getName(), serverTemp.getHostAddress(), serverTemp.getHostport()));
        }
        ServerImpl server = new ServerImpl(serverName, hostAddress, port);
        server.setManagement(this);
        this.servers.add((Object)server);
        this.store();
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Created Server=%s", server.getName()));
        }
        return server;
    }

    public void removeServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        Server removeServer = null;
        FastList.Node n = this.servers.head();
        FastList.Node end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            if (serverTemp.isStarted()) {
                throw new Exception(String.format("Server=%s is started. Stop the server before removing", serverName));
            }
            removeServer = serverTemp;
            break;
        }
        if (removeServer == null) {
            throw new Exception(String.format("No Server found with name=%s", serverName));
        }
        this.servers.remove(removeServer);
        this.store();
    }

    public void startServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (this.name == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList.Node n = this.servers.head();
        FastList.Node end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            if (serverTemp.isStarted()) {
                throw new Exception(String.format("Server=%s is already started", serverName));
            }
            ((ServerImpl)serverTemp).start();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server foubd with name=%s", serverName));
    }

    public void stopServer(String serverName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        FastList.Node n = this.servers.head();
        FastList.Node end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (!serverName.equals(serverTemp.getName())) continue;
            ((ServerImpl)serverTemp).stop();
            this.store();
            return;
        }
        throw new Exception(String.format("No Server found with name=%s", serverName));
    }

    public AssociationImpl addServerAssociation(String peerAddress, int peerPort, String serverName, String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (serverName == null) {
            throw new Exception("Server name cannot be null");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        if (this.associations.get(assocName) != null) {
            throw new Exception(String.format("Already has association=%s", assocName));
        }
        Server server = null;
        FastList.Node n = this.servers.head();
        FastList.Node end = this.servers.tail();
        while ((n = n.getNext()) != end) {
            Server serverTemp = (Server)n.getValue();
            if (!serverTemp.getName().equals(serverName)) continue;
            server = serverTemp;
        }
        if (server == null) {
            throw new Exception(String.format("No Server found for name=%s", serverName));
        }
        n = this.associations.head();
        end = this.associations.tail();
        while ((n = n.getNext()) != end) {
            Association associationTemp = (Association)n.getValue();
            if (!peerAddress.equals(associationTemp.getPeerAddress()) || associationTemp.getPeerPort() != peerPort) continue;
            throw new Exception(String.format("Already has association=%s with same peer address=% and port=%d", associationTemp.getName(), peerAddress, peerPort));
        }
        AssociationImpl association = new AssociationImpl(peerAddress, peerPort, serverName, assocName);
        association.setManagement(this);
        this.associations.put(assocName, association);
        ((ServerImpl)server).associations.add((Object)assocName);
        this.store();
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getType()}));
        }
        return association;
    }

    public AssociationImpl addAssociation(String hostAddress, int hostPort, String peerAddress, int peerPort, String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (hostAddress == null) {
            throw new Exception("Host address cannot be null");
        }
        if (hostPort < 1) {
            throw new Exception("Host port cannot be less than 1");
        }
        if (peerAddress == null) {
            throw new Exception("Peer address cannot be null");
        }
        if (peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        FastMap.Entry n = this.associations.head();
        FastMap.Entry end = this.associations.tail();
        while ((n = n.getNext()) != end) {
            Association associationTemp = (Association)n.getValue();
            if (assocName.equals(associationTemp.getName())) {
                throw new Exception(String.format("Already has association=%s", associationTemp.getName()));
            }
            if (peerAddress.equals(associationTemp.getPeerAddress()) && associationTemp.getPeerPort() == peerPort) {
                throw new Exception(String.format("Already has association=%s with same peer address=% and port=%d", associationTemp.getName(), peerAddress, peerPort));
            }
            if (!hostAddress.equals(associationTemp.getHostAddress()) || associationTemp.getHostPort() != hostPort) continue;
            throw new Exception(String.format("Already has association=%s with same host address=% and port=%d", associationTemp.getName(), hostAddress, hostPort));
        }
        AssociationImpl association = new AssociationImpl(hostAddress, hostPort, peerAddress, peerPort, assocName);
        association.setManagement(this);
        this.associations.put(assocName, association);
        this.store();
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Added Associoation=%s of type=%s", new Object[]{association.getName(), association.getType()}));
        }
        return association;
    }

    public Association getAssociation(String assocName) throws Exception {
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        return associationTemp;
    }

    public Map<String, Association> getAssociations() {
        return this.associations.unmodifiable();
    }

    public void startAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association associationTemp = (Association)this.associations.get(assocName);
        if (associationTemp == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        if (associationTemp.isStarted()) {
            throw new Exception(String.format("Association=%s is already started", assocName));
        }
        ((AssociationImpl)associationTemp).start();
        this.store();
    }

    public void stopAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association association = (Association)this.associations.get(assocName);
        if (association == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        ((AssociationImpl)association).stop();
        this.store();
    }

    public void removeAssociation(String assocName) throws Exception {
        if (!this.started) {
            throw new Exception(String.format("Management=%s not started", this.name));
        }
        if (assocName == null) {
            throw new Exception("Association name cannot be null");
        }
        Association association = (Association)this.associations.get(assocName);
        if (association == null) {
            throw new Exception(String.format("No Association found for name=%s", assocName));
        }
        if (association.isStarted()) {
            throw new Exception(String.format("Association name=%s is started. Stop before removing", assocName));
        }
        this.associations.remove(assocName);
        if (((AssociationImpl)association).getType() == AssociationType.SERVER) {
            FastList.Node n = this.servers.head();
            FastList.Node end = this.servers.tail();
            while ((n = n.getNext()) != end) {
                Server serverTemp = (Server)n.getValue();
                if (!serverTemp.getName().equals(association.getServerName())) continue;
                ((ServerImpl)serverTemp).associations.remove((Object)assocName);
                break;
            }
        }
        this.store();
    }

    public List<Server> getServers() {
        return this.servers.unmodifiable();
    }

    protected FastList<ChangeRequest> getPendingChanges() {
        return this.pendingChanges;
    }

    protected Selector getSocketSelector() {
        return this.socketSelector;
    }

    protected void populateWorkerThread(int[] workerThreadTable) {
        for (int count = 0; count < workerThreadTable.length; ++count) {
            if (this.workerThreadCount == this.workerThreads) {
                this.workerThreadCount = 0;
            }
            workerThreadTable[count] = this.workerThreadCount++;
        }
    }

    protected ExecutorService getExecutorService(int index) {
        return this.executorServices[index];
    }
}

