/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpServerChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.sctp.AssociationImpl;
import org.mobicents.protocols.sctp.AssociationMap;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.ManagementImpl;

public class SelectorThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(SelectorThread.class);
    private Selector selector;
    private ManagementImpl management = null;
    private volatile boolean started = true;

    protected SelectorThread(Selector selector, ManagementImpl management) {
        this.selector = selector;
        this.management = management;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SelectorThread for Management=%s started.", this.management.getName()));
        }
        while (this.started) {
            try {
                FastList<ChangeRequest> pendingChanges;
                FastList<ChangeRequest> fastList = pendingChanges = this.management.getPendingChanges();
                synchronized (fastList) {
                    for (ChangeRequest change : pendingChanges) {
                        switch (change.getType()) {
                            case 2: {
                                pendingChanges.remove((Object)change);
                                SelectionKey key = change.getSocketChannel().keyFor(this.selector);
                                key.interestOps(change.getOps());
                                break;
                            }
                            case 1: {
                                pendingChanges.remove((Object)change);
                                SelectionKey key1 = change.getSocketChannel().register(this.selector, change.getOps());
                                key1.attach(change.getAssociation());
                                break;
                            }
                            case 3: {
                                if (change.getExecutionTime() > System.currentTimeMillis()) break;
                                pendingChanges.remove((Object)change);
                                change.getAssociation().initiateConnection();
                                break;
                            }
                            case 4: {
                                pendingChanges.remove((Object)change);
                                change.getAssociation().close();
                            }
                        }
                    }
                }
                this.selector.select(500L);
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isConnectable()) {
                        this.finishConnection(key);
                        continue;
                    }
                    if (key.isAcceptable()) {
                        this.accept(key);
                        continue;
                    }
                    if (key.isReadable()) {
                        this.read(key);
                        continue;
                    }
                    if (!key.isWritable()) continue;
                    this.write(key);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while selecting the ready keys", (Throwable)e);
            }
        }
        try {
            this.selector.close();
        }
        catch (IOException e) {
            logger.error((Object)String.format("Error while closing Selector for SCTP Management=%s", this.management.getName()));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SelectorThread for Management=%s stopped.", this.management.getName()));
        }
    }

    private void accept(SelectionKey key) throws IOException {
        SctpServerChannel serverSocketChannel = (SctpServerChannel)key.channel();
        SctpChannel socketChannel = serverSocketChannel.accept();
        Set<SocketAddress> socAddresses = socketChannel.getRemoteAddresses();
        boolean provisioned = false;
        int port = 0;
        InetAddress inetAddress = null;
        block0: for (SocketAddress sockAdd : socAddresses) {
            inetAddress = ((InetSocketAddress)sockAdd).getAddress();
            port = ((InetSocketAddress)sockAdd).getPort();
            AssociationMap<String, Association> associations = this.management.associations;
            FastMap.Entry n = associations.head();
            FastMap.Entry end = associations.tail();
            while ((n = n.getNext()) != end && !provisioned) {
                Association association = (Association)n.getValue();
                if (port != association.getPeerPort() || !inetAddress.getHostAddress().equals(association.getPeerAddress())) continue;
                provisioned = true;
                if (!association.isStarted()) {
                    logger.error((Object)String.format("Received connect request for Association=%s but not started yet. Droping the connection! ", association.getName()));
                    socketChannel.close();
                    continue block0;
                }
                ((AssociationImpl)association).setSocketChannel(socketChannel);
                socketChannel.configureBlocking(false);
                SelectionKey key1 = socketChannel.register(this.selector, 1);
                key1.attach(association);
                if (!logger.isInfoEnabled()) continue block0;
                logger.info((Object)String.format("Connected %s", association));
                continue block0;
            }
        }
        if (!provisioned) {
            logger.warn((Object)String.format("Received connect request from non provisioned %s:%d address. Closing Channel", inetAddress.getHostAddress(), port));
            socketChannel.close();
        }
    }

    private void read(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        association.read();
    }

    private void write(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        association.write(key);
    }

    private void finishConnection(SelectionKey key) throws IOException {
        AssociationImpl association = (AssociationImpl)key.attachment();
        try {
            SctpChannel socketChannel = (SctpChannel)key.channel();
            if (socketChannel.isConnectionPending()) {
                while (socketChannel.isConnectionPending()) {
                    socketChannel.finishConnect();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Asscoiation=%s connected to=%s", association.getName(), socketChannel.getRemoteAddresses()));
            }
            key.interestOps(1);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception while finishing connection for Association=%s", association.getName()), (Throwable)e);
            association.scheduleConnect();
        }
    }
}

