/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.sctp;

import com.sun.nio.sctp.SctpServerChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.Association;
import org.mobicents.protocols.api.Server;
import org.mobicents.protocols.sctp.ChangeRequest;
import org.mobicents.protocols.sctp.ManagementImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerImpl
implements Server {
    private static final Logger logger = Logger.getLogger((String)ServerImpl.class.getName());
    private static final String NAME = "name";
    private static final String HOST_ADDRESS = "hostAddress";
    private static final String HOST_PORT = "hostPort";
    private static final String ASSOCIATIONS = "associations";
    private static final String STARTED = "started";
    private String name;
    private String hostAddress;
    private int hostport;
    private volatile boolean started = false;
    private SctpServerChannel serverChannel;
    private ManagementImpl management = null;
    protected FastList<String> associations = new FastList();
    protected static final XMLFormat<ServerImpl> SERVER_XML = new XMLFormat<ServerImpl>(ServerImpl.class){

        public void read(XMLFormat.InputElement xml, ServerImpl server) throws XMLStreamException {
            server.name = xml.getAttribute(ServerImpl.NAME, "");
            server.started = xml.getAttribute(ServerImpl.STARTED, false);
            server.hostAddress = xml.getAttribute(ServerImpl.HOST_ADDRESS, "");
            server.hostport = xml.getAttribute(ServerImpl.HOST_PORT, 0);
            server.associations = (FastList)xml.get(ServerImpl.ASSOCIATIONS, FastList.class);
        }

        public void write(ServerImpl server, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(ServerImpl.NAME, server.name);
            xml.setAttribute(ServerImpl.STARTED, server.started);
            xml.setAttribute(ServerImpl.HOST_ADDRESS, server.hostAddress);
            xml.setAttribute(ServerImpl.HOST_PORT, server.hostport);
            xml.add(server.associations, ServerImpl.ASSOCIATIONS, FastList.class);
        }
    };

    public ServerImpl() {
    }

    public ServerImpl(String name, String hostAddress, int hostport) throws IOException {
        this.name = name;
        this.hostAddress = hostAddress;
        this.hostport = hostport;
    }

    protected void start() throws Exception {
        this.initSocket();
        this.started = true;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Started Server=%s", this.name));
        }
    }

    protected void stop() throws Exception {
        FastList.Node n = this.associations.head();
        FastList.Node end = this.associations.tail();
        while ((n = n.getNext()) != end) {
            String assocName = (String)n.getValue();
            Association associationTemp = this.management.getAssociation(assocName);
            if (!associationTemp.isStarted()) continue;
            throw new Exception(String.format("Stop all the associations first. Association=%s is still started", new Object[0]));
        }
        if (this.serverChannel != null) {
            try {
                this.serverChannel.close();
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Error while stopping the Server=%s", this.name), (Throwable)e);
            }
        }
        this.started = false;
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("Stoped Server=%s", this.name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSocket() throws IOException {
        FastList<ChangeRequest> pendingChanges;
        this.serverChannel = SctpServerChannel.open();
        this.serverChannel.configureBlocking(false);
        InetSocketAddress isa = new InetSocketAddress(this.hostAddress, this.hostport);
        this.serverChannel.bind(isa);
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("SctpServerChannel bound to=%s ", this.serverChannel.getAllLocalAddresses()));
        }
        FastList<ChangeRequest> fastList = pendingChanges = this.management.getPendingChanges();
        synchronized (fastList) {
            pendingChanges.add((Object)new ChangeRequest(this.serverChannel, null, 1, 16));
        }
        this.management.getSocketSelector().wakeup();
    }

    public String getName() {
        return this.name;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public int getHostport() {
        return this.hostport;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setManagement(ManagementImpl management) {
        this.management = management;
    }

    public List<String> getAssociations() {
        return this.associations.unmodifiable();
    }
}

