/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.asterisk;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.NamingException;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.InvalidStateException;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionFactory;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.response.ManagerResponse;
import org.jboss.logging.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.container.component.ComponentKey;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorState;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.asterisk.AsteriskActivityContextInterfaceFactory;
import org.mobicents.slee.resource.asterisk.AsteriskActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.asterisk.AsteriskActivityHandle;
import org.mobicents.slee.resource.asterisk.AsteriskManagerMessage;
import org.mobicents.slee.resource.asterisk.AsteriskResourceAdaptorSbbInterface;

public class AsteriskResourceAdaptor
implements ManagerEventListener,
ResourceAdaptor,
Serializable {
    private static final long serialVersionUID = -8460649793374940252L;
    private static transient Logger log = Logger.getLogger(AsteriskResourceAdaptor.class);
    private ResourceAdaptorState state;
    private Properties properties;
    private ManagerConnection managerConnection;
    private transient HashMap activities;
    private String MAGIIP = "0.0.0.0";
    private String MAGILogin = "admin";
    private String MAGIPassword = "amp111";
    private int responseTimeOut = 300000;
    private int MAGIPORT = 5038;
    private transient SleeEndpoint sleeEndpoint;
    private transient Object eventObj;
    private transient Object activityObj;
    private transient Address address;
    private transient EventLookupFacility eventLookup;
    private transient BootstrapContext bootstrapContext;
    private transient ManagerConnectionFactory factory;
    private transient AsteriskRASbbInterfaceImpl sbbInterface;
    private transient AsteriskActivityContextInterfaceFactory acif;
    private transient HashMap AsteriskToSleeEvent = new HashMap();

    public void entityCreated(BootstrapContext ctx) throws ResourceException {
        this.init(ctx);
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        try {
            try {
                this.configure(null);
            }
            catch (InvalidStateException e1) {
                e1.printStackTrace();
            }
            this.start();
        }
        catch (ResourceException e) {
            e.printStackTrace();
            throw new ResourceException("Failed to Activate Resource Adaptor!", (Throwable)e);
        }
    }

    public void entityDeactivating() {
        this.stopping();
    }

    public void entityDeactivated() {
        this.stop();
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, Object arg1, int arg2, Address arg3, int arg4, FailureReason arg5) {
    }

    public void activityEnded(ActivityHandle arg0) {
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void queryLiveness(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle handle) {
        return this.activities.get(handle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String arg0) {
        return this.sbbInterface;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String arg0, int[] arg1, String[] arg2) {
    }

    public void serviceUninstalled(String arg0) {
    }

    public void serviceActivated(String arg0) {
    }

    public void serviceDeactivated(String arg0) {
    }

    public void init(BootstrapContext bootstrapContext) throws ResourceException {
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
        this.factory = new ManagerConnectionFactory(this.MAGIIP, this.MAGILogin, this.MAGIPassword);
        this.state = ResourceAdaptorState.UNCONFIGURED;
    }

    public void configure(Properties properties) throws InvalidStateException {
        if (this.state != ResourceAdaptorState.UNCONFIGURED) {
            throw new InvalidStateException("Cannot configure RA wrong state: " + this.state);
        }
        log.debug((Object)"Configure routine - Going to load properties");
        this.properties = this.loadProperties(this.bootstrapContext);
        this.MAGIIP = this.properties.getProperty("MAGIIP", "0.0.0.0");
        this.MAGILogin = this.properties.getProperty("MAGILogin", "manager");
        this.MAGIPassword = this.properties.getProperty("MAGIPassword", "secret");
        try {
            this.MAGIPORT = Integer.valueOf(this.properties.getProperty("MAGIPORT", "5038"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.responseTimeOut = Integer.parseInt(this.properties.getProperty("responseTimeout", "300000"));
        log.debug((Object)("Configure routine - Loaded properties => " + this.properties));
        this.factory = new ManagerConnectionFactory(this.MAGIIP, this.MAGIPORT, this.MAGILogin, this.MAGIPassword);
        try {
            this.managerConnection = this.factory.createManagerConnection();
            this.managerConnection.addEventListener((ManagerEventListener)this);
            this.state = ResourceAdaptorState.CONFIGURED;
        }
        catch (Exception ex) {
            log.error((Object)"Couldn't create the Asterisk Connection Factory");
            System.exit(0);
        }
    }

    public void start() throws ResourceException {
        try {
            log.info((Object)("Login to " + this.MAGIIP + " with " + this.MAGILogin + " " + this.MAGIPassword));
            this.managerConnection.login();
            log.debug((Object)"Asterisk Resource Adaptor started.");
            this.initializeNamingContext();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ResourceException(ex.getMessage());
        }
        this.sbbInterface = new AsteriskRASbbInterfaceImpl();
        this.activities = new HashMap();
        this.state = ResourceAdaptorState.ACTIVE;
    }

    public void stop() {
        try {
            this.managerConnection.logoff();
        }
        catch (Exception tiex) {
            log.error((Object)("Exception: " + tiex));
        }
        try {
            this.cleanNamingContext();
        }
        catch (NamingException e) {
            log.error((Object)"Can't unbind naming context");
        }
        this.sbbInterface = null;
        this.factory = null;
        log.debug((Object)"Asterisk Resource Adaptor stopped.");
    }

    public void stopping() {
        this.state = ResourceAdaptorState.STOPPING;
    }

    public Object getFactoryInterface() {
        return this.factory;
    }

    public Object getActivityContextInterfaceFactory() {
        return this.acif;
    }

    public void setResourceAdaptorEntity(ResourceAdaptorEntity resourceAdaptorEntity) {
    }

    private Properties loadProperties(BootstrapContext bootstrapContext) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("asteriskra.properties"));
            log.info((Object)"loadProperties asteriskra.properties");
        }
        catch (IOException ex) {
            log.error((Object)"Couldn't load properties");
        }
        return properties;
    }

    public void onManagerEvent(ManagerEvent event) {
        log.info((Object)("Event Handler: " + event));
        if (event.getClass().getName().equals("org.asteriskjava.manager.event.ConnectEvent")) {
            log.info((Object)"ConnectEvent Temporary anti-Exception measure");
            return;
        }
        this.processEvent(event);
    }

    public void handleResponse(ManagerResponse event) {
        log.info((Object)("Response Handler: " + event));
        this.processEvent(event);
    }

    public void handleTimeout(TimeoutException event) {
        log.info((Object)("TimeoutHandler: " + (Object)((Object)event)));
        this.processEvent((Object)event);
    }

    public void processEvent(Object event) {
        int eventID;
        log.debug((Object)"------------------ NEW ASTERISK-RA EVENT -----------------------");
        log.debug((Object)("Processing event: " + event.getClass().getName()));
        ComponentKey key = (ComponentKey)this.AsteriskToSleeEvent.get(event.getClass().getName());
        if (key == null) {
            key = new ComponentKey(event.getClass().getName(), "org.asteriskjava", "1.0");
            this.AsteriskToSleeEvent.put(event.getClass().getName(), key);
        }
        log.debug((Object)event.getClass().getName());
        log.debug((Object)key);
        this.eventObj = event;
        Address address = new Address(AddressPlan.IP, this.MAGIIP);
        AsteriskManagerMessage actobj = new AsteriskManagerMessage(event, (Object)this.managerConnection);
        AsteriskActivityHandle handle = new AsteriskActivityHandle(actobj.MessageID());
        this.activities.put(handle, actobj);
        log.debug((Object)("event lookup for " + key.getName() + " vendor = " + key.getVendor() + " version = " + key.getVersion()));
        try {
            eventID = this.eventLookup.getEventID(key.getName(), key.getVendor(), key.getVersion());
        }
        catch (FacilityException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup event!", e2);
        }
        catch (UnrecognizedEventException e2) {
            e2.printStackTrace();
            throw new RuntimeException("Failed to lookup event!", e2);
        }
        if (eventID == -1) {
            log.debug((Object)"event lookup -- could not find event mapping -- check xml/slee-events.xml");
            return;
        }
        try {
            log.info((Object)("Resource adaptor delivering event:\n" + eventID + "\n" + address));
            this.sleeEndpoint.fireEvent((ActivityHandle)new AsteriskActivityHandle(actobj.MessageID()), this.eventObj, eventID, address);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (ActivityIsEndingException e) {
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
        try {
            this.sleeEndpoint.activityEnding((ActivityHandle)handle);
        }
        catch (Exception e) {
            log.error((Object)("Could not end activity: " + actobj));
        }
    }

    private void cleanNamingContext() throws NamingException {
    }

    public HashMap getActivities() {
        return this.activities;
    }

    private void initializeNamingContext() throws NamingException {
        SleeContainer container = SleeContainer.lookupFromJndi();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(this.bootstrapContext.getEntityName());
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new AsteriskActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), this.bootstrapContext.getEntityName());
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        resourceAdaptorEntity.getServiceContainer();
        SleeContainer.registerWithJndi((String)"slee/resources", (String)"asteriskacif", (Object)this.acif);
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public void setSleeEndpoint(SleeEndpoint sleeEndpoint) {
        this.sleeEndpoint = sleeEndpoint;
    }

    public class AsteriskRASbbInterfaceImpl
    implements AsteriskResourceAdaptorSbbInterface {
        public void sendAction(ManagerAction action) {
            try {
                ManagerResponse managerResponse = AsteriskResourceAdaptor.this.managerConnection.sendAction(action, (long)AsteriskResourceAdaptor.this.responseTimeOut);
                AsteriskResourceAdaptor.this.handleResponse(managerResponse);
            }
            catch (TimeoutException ex) {
                AsteriskResourceAdaptor.this.handleTimeout(ex);
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
        }
    }
}

