/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.UnrecognizedEventException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.FacilityException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.http.HttpServletRaActivityContextInterfaceFactory;
import net.java.slee.resource.http.HttpSessionActivity;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.http.HttpServletRaActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.http.HttpServletRaSbbInterfaceImpl;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPoint;
import org.mobicents.slee.resource.http.HttpSessionActivityHandle;
import org.mobicents.slee.resource.http.HttpSessionActivityImpl;
import org.mobicents.slee.resource.http.RequestLock;
import org.mobicents.slee.resource.http.events.HttpServletRequestEventImpl;

public class HttpServletResourceAdaptor
implements ResourceAdaptor {
    private static transient Logger logger = Logger.getLogger((String)HttpServletResourceAdaptor.class.getName());
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient ConcurrentHashMap<ActivityHandle, HttpSessionActivity> activities = null;
    private transient RequestLock requestLock = null;
    private transient HttpServletRaActivityContextInterfaceFactory acif = null;
    private HttpServletResourceEntryPoint resourceEntryPoint;
    private HttpServletRaSbbInterfaceImpl httpRaSbbinterface;

    public HttpServletResourceAdaptor() {
        logger.debug((Object)"============== CREATED HttpServletResourceAdaptor ENTITY ===============");
    }

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        logger.info((Object)"RAFrameResourceAdaptor.entityCreated() called.");
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityRemoved() {
        logger.info((Object)"=================== HttpServletResourceAdaptor entityRemoved METHOD CALLED ===================");
    }

    public void entityActivated() throws ResourceException {
        logger.debug((Object)"RAFrameResourceAdaptor.entityActivated() called.");
        try {
            logger.debug((Object)"=============== ACTIVATING HttpServletResourceAdaptor ENTITY ====================");
            this.initializeNamingContextBindings();
            logger.debug((Object)"=============== CREATING RA SBB INTERFACE ====================");
            this.httpRaSbbinterface = new HttpServletRaSbbInterfaceImpl();
            this.activities = new ConcurrentHashMap();
            this.requestLock = new RequestLock();
        }
        catch (NamingException e) {
            throw new ResourceException("============================== HttpServletResourceadaptor.entityActivated(): Failed to activate HttpServlet RA! ============================", (Throwable)e);
        }
    }

    public void entityDeactivated() {
        logger.debug((Object)"======================== HttpServlet RA entityDeactivated METHOD CALLED ===================");
        logger.debug((Object)"======================== HttpServlet RA ending all activities ===================");
        for (ActivityHandle handle : this.activities.keySet()) {
            try {
                this.sleeEndpoint.activityEnding(handle);
            }
            catch (UnrecognizedActivityException uae) {
                logger.error((Object)"==== GOT UnrecognizedActivityException ==== ", (Throwable)uae);
            }
        }
        this.activities.clear();
        this.activities = null;
        logger.info((Object)"======================== HttpServlet RA cleaning naming context ===================");
        try {
            this.cleanNamingContextBindings();
        }
        catch (NamingException e) {
            logger.error((Object)"^^^ HttpServlet RA Cannot unbind naming context ^^^");
        }
        logger.debug((Object)"========================== HttpServlet RA stopped. ========================");
    }

    public void entityDeactivating() {
        logger.debug((Object)"================== HttpServlet RA entityDeactivating() METHOD CALLED ===================");
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object event, int param, Address address, int flags) {
        logger.debug((Object)" ===================== HttpServlet RA eventProcessingSuccessful METHOD CALLED ===================");
        if (event instanceof HttpServletRequestEvent) {
            this.releaseHttpRequest((HttpServletRequestEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseHttpRequest(HttpServletRequestEvent hreqEvent) {
        logger.debug((Object)"releaseHttpRequest() enter");
        Object lock = this.requestLock.getLock(hreqEvent);
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            this.requestLock.removeLock(hreqEvent);
        }
        logger.debug((Object)"releaseHttpRequest() exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockHttpRequest(HttpServletRequestEvent hreqEvent) {
        try {
            Object lock;
            logger.debug((Object)"blockRequest() enter");
            Object object = lock = this.requestLock.getLock(hreqEvent);
            synchronized (object) {
                lock.wait(20000L);
            }
            logger.debug((Object)"blockRequest() exit");
        }
        catch (InterruptedException e) {
            logger.warn((Object)"blockRequest() interrupted", (Throwable)e);
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object event, int param, Address address, int flags, FailureReason failureReason) {
        logger.debug((Object)" ===================== HttpServlet RA eventProcessingFailed METHOD CALLED ===================");
        if (event instanceof HttpServletRequestEvent) {
            this.releaseHttpRequest((HttpServletRequestEvent)event);
        }
    }

    public void activityEnded(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        logger.debug((Object)" ===================== HttpServlet RA activityEnded METHOD CALLED ===================");
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        logger.debug((Object)" ===================== HttpServlet RA activityUnreferenced METHOD CALLED ===================");
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        logger.debug((Object)" ===================== HttpServlet RA queryLiveness METHOD CALLED ===================");
    }

    public Object getActivity(ActivityHandle activityHandle) {
        HttpSessionActivity act = this.activities.get(activityHandle);
        logger.debug((Object)" ===================== HttpServlet RA getActivity METHOD CALLED ===================");
        return act;
    }

    public ActivityHandle getActivityHandle(Object obj) {
        logger.debug((Object)" ===================== HttpServlet RA getActivityHandle METHOD CALLED ===================");
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        logger.debug((Object)(" ===================== HttpServlet RA getSBBResourceAdaptorInterface METHOD CALLED: " + str + " ==================="));
        return this.httpRaSbbinterface;
    }

    public Marshaler getMarshaler() {
        logger.debug((Object)" ===================== HttpServlet RA getMarshaler METHOD CALLED ===================");
        return null;
    }

    public void serviceInstalled(String str, int[] values, String[] str2) {
        logger.debug((Object)" ===================== HttpServlet RA serviceInstalled METHOD CALLED ===================");
    }

    public void serviceUninstalled(String str) {
        logger.debug((Object)(" ===================== HttpServlet RA serviceUninstalled METHOD CALLED: " + str + " ==================="));
    }

    public void serviceActivated(String str) {
        logger.debug((Object)(" ===================== HttpServlet RA serviceActivated METHOD CALLED: " + str + " ==================="));
    }

    public void serviceDeactivated(String str) {
        logger.debug((Object)(" ===================== HttpServlet RA serviceDeactivated METHOD CALLED: " + str + "==================="));
    }

    private void initializeNamingContextBindings() throws NamingException {
        String name;
        String prefix;
        int toind;
        int begind;
        String jndiName;
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new HttpServletRaActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                jndiName = this.acif.getJndiName();
                begind = jndiName.indexOf(58);
                toind = jndiName.lastIndexOf(47);
                prefix = jndiName.substring(begind + 1, toind);
                name = jndiName.substring(toind + 1);
                logger.debug((Object)("========================== jndiName prefix =" + prefix + "; jndiName = " + name + " ; ACIF: " + this.acif + "========================="));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.resourceEntryPoint = new HttpServletResourceEntryPoint(entityName, this);
        try {
            if (this.resourceEntryPoint != null) {
                jndiName = this.resourceEntryPoint.getJndiName();
                begind = jndiName.indexOf(58);
                toind = jndiName.lastIndexOf(47);
                prefix = jndiName.substring(begind + 1, toind);
                name = jndiName.substring(toind + 1);
                logger.debug((Object)("========================== jndiName prefix =" + prefix + "; jndiName = " + name + " ; Resource Entry Point: " + this.resourceEntryPoint + "========================="));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.resourceEntryPoint);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void cleanNamingContextBindings() throws NamingException {
        try {
            String javaJNDIName;
            int begind;
            String jndiName;
            if (this.acif != null) {
                jndiName = this.acif.getJndiName();
                begind = jndiName.indexOf(58);
                javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("=================== JNDI name to unregister: " + javaJNDIName + " ===================="));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"====================== JNDI name unregistered.==========================");
            }
            if (this.resourceEntryPoint != null) {
                jndiName = this.resourceEntryPoint.getJndiName();
                begind = jndiName.indexOf(58);
                javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("=================== JNDI name to unregister: " + javaJNDIName + " ===================="));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"====================== JNDI name unregistered.==========================");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSessionActivityHandle ah = null;
        HttpSession session = request.getSession();
        HttpSessionActivityImpl incomingRequest = new HttpSessionActivityImpl(this, session.getId());
        ah = new HttpSessionActivityHandle(incomingRequest.getSessionId());
        String pathInfo = "/mobicents" + request.getPathInfo();
        logger.debug((Object)("Path Info = " + pathInfo));
        if (this.activities.get(ah) == null) {
            this.activities.put(ah, incomingRequest);
        }
        HttpServletRequestEventImpl hreqEvent = new HttpServletRequestEventImpl(request, response, (Object)this);
        logger.debug((Object)(">->->->  HttpServletRA.onRequest: " + request.getRequestURL()));
        this.fireEventToSLEE((HttpServletRequestEvent)hreqEvent, request.getMethod(), pathInfo, ah);
        this.blockHttpRequest((HttpServletRequestEvent)hreqEvent);
    }

    public void endHttpSessionActivity(String sessionId) {
        HttpSessionActivityHandle ah = new HttpSessionActivityHandle(sessionId);
        if (this.activities.get(ah) != null) {
            try {
                this.sleeEndpoint.activityEnding((ActivityHandle)ah);
            }
            catch (UnrecognizedActivityException uae) {
                logger.error((Object)"==== GOT UnrecognizedActivityException ==== ", (Throwable)uae);
                throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", uae);
            }
        }
    }

    protected void fireEventToSLEE(HttpServletRequestEvent event, String method, String servletPath, ActivityHandle ah) {
        int eventID = -1;
        try {
            eventID = this.eventLookup.getEventID("net.java.slee.resource.http.events.incoming." + method, "net.java.slee", "1.0");
            if (eventID == -1) {
                logger.info((Object)("===== COULDNT FIND EVENT REGISTRATOIN for: (" + HttpServletRequestEvent.class.getName() + ", net.java.slee, 1.0"));
                return;
            }
            Address address = new Address(AddressPlan.URI, servletPath);
            logger.debug((Object)("==== FIRING HTTPREQUEST EVENT TO LOCAL SLEE, Event: " + event + " ===="));
            this.sleeEndpoint.fireEvent(ah, (Object)event, eventID, address);
        }
        catch (FacilityException fe) {
            logger.error((Object)"===== GOT FACILITY EXCEPTION: ======", (Throwable)fe);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", fe);
        }
        catch (UnrecognizedEventException uee) {
            logger.error((Object)"==== GOT UnrecognizedEventException ==== ", (Throwable)uee);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", uee);
        }
        catch (ActivityIsEndingException aiee) {
            logger.error((Object)"==== GOT ActivityIsEndingException ==== ", (Throwable)aiee);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA  <><><>", aiee);
        }
        catch (NullPointerException npe) {
            logger.error((Object)"==== GOT NullPointerException ==== ", (Throwable)npe);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA  <><><>", npe);
        }
        catch (IllegalArgumentException iae) {
            logger.error((Object)"==== GOT IllegalArgumentException ==== ", (Throwable)iae);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", iae);
        }
        catch (IllegalStateException ise) {
            logger.error((Object)"==== GOT IllegalStateException ==== ", (Throwable)ise);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", ise);
        }
        catch (UnrecognizedActivityException uae) {
            logger.error((Object)"==== GOT UnrecognizedActivityException ==== ", (Throwable)uae);
            throw new RuntimeException("<><><> EXCPETION IN Http Servlet RA <><><>", uae);
        }
    }
}

