/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EventIDFilter {
    private Map<String, int[]> eventIDsOfServicesInstalled = new ConcurrentHashMap<String, int[]>(31);
    private Map<Integer, Set<String>> eventID2serviceIDs = new ConcurrentHashMap<Integer, Set<String>>(31);

    public boolean filterEvent(int eventID) {
        return !this.eventID2serviceIDs.containsKey(eventID);
    }

    public void serviceInstalled(String serviceID, int[] eventIDs) {
        this.eventIDsOfServicesInstalled.put(serviceID, eventIDs);
    }

    public void serviceUninstalled(String serviceID) {
        this.eventIDsOfServicesInstalled.remove(serviceID);
    }

    public synchronized void serviceActivated(String serviceID) {
        int[] eventIDs = this.eventIDsOfServicesInstalled.get(serviceID);
        if (eventIDs != null) {
            for (int eventID : eventIDs) {
                Set<String> serviceIDs = this.eventID2serviceIDs.get(eventID);
                if (serviceIDs == null) {
                    serviceIDs = new HashSet<String>();
                    this.eventID2serviceIDs.put(eventID, serviceIDs);
                }
                serviceIDs.add(serviceID);
            }
        }
    }

    public synchronized void serviceDeactivated(String serviceID) {
        int[] eventIDs = this.eventIDsOfServicesInstalled.get(serviceID);
        if (eventIDs != null) {
            for (int eventID : eventIDs) {
                Set<String> serviceIDs = this.eventID2serviceIDs.get(eventID);
                if (serviceIDs == null) continue;
                serviceIDs.remove(serviceID);
                if (!serviceIDs.isEmpty()) continue;
                this.eventID2serviceIDs.remove(eventID);
            }
        }
    }
}

