/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.BootstrapContext;
import javax.slee.resource.CouldNotStartActivityException;
import javax.slee.resource.FailureReason;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceException;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.http.HttpServletRaActivityContextInterfaceFactory;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.apache.log4j.Logger;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.resource.ResourceAdaptorEntity;
import org.mobicents.slee.resource.ResourceAdaptorTypeIDImpl;
import org.mobicents.slee.resource.http.EventIDCache;
import org.mobicents.slee.resource.http.EventIDFilter;
import org.mobicents.slee.resource.http.HttpServletActivityHandle;
import org.mobicents.slee.resource.http.HttpServletRaActivityContextInterfaceFactoryImpl;
import org.mobicents.slee.resource.http.HttpServletRaSbbInterfaceImpl;
import org.mobicents.slee.resource.http.HttpServletRequestActivityImpl;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPoint;
import org.mobicents.slee.resource.http.HttpSessionActivityImpl;
import org.mobicents.slee.resource.http.RequestLock;
import org.mobicents.slee.resource.http.events.HttpServletRequestEventImpl;

public class HttpServletResourceAdaptor
implements ResourceAdaptor {
    private static transient Logger logger = Logger.getLogger((String)HttpServletResourceAdaptor.class.getName());
    private transient BootstrapContext bootstrapContext = null;
    private transient SleeEndpoint sleeEndpoint = null;
    private transient EventLookupFacility eventLookup = null;
    private transient ConcurrentHashMap<ActivityHandle, Object> activities = null;
    private transient RequestLock requestLock = null;
    private transient HttpServletRaActivityContextInterfaceFactory acif = null;
    private HttpServletResourceEntryPoint resourceEntryPoint;
    private HttpServletRaSbbInterfaceImpl httpRaSbbinterface;
    private static final transient EventIDCache eventIdCache = new EventIDCache();
    private static final transient EventIDFilter eventIDFilter = new EventIDFilter();

    public void entityCreated(BootstrapContext bootstrapContext) throws ResourceException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"entityCreated()");
        }
        this.bootstrapContext = bootstrapContext;
        this.sleeEndpoint = bootstrapContext.getSleeEndpoint();
        this.eventLookup = bootstrapContext.getEventLookupFacility();
    }

    public void entityRemoved() {
    }

    public void entityActivated() throws ResourceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"entityActivated() ");
        }
        try {
            this.initializeNamingContextBindings();
            this.httpRaSbbinterface = new HttpServletRaSbbInterfaceImpl(this);
            this.activities = new ConcurrentHashMap();
            this.requestLock = new RequestLock();
        }
        catch (NamingException e) {
            throw new ResourceException("entityActivated(): Failed to activate HttpServlet RA", (Throwable)e);
        }
    }

    public void entityDeactivated() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"entityDeactivated(): ending all activities");
        }
        for (ActivityHandle handle : this.activities.keySet()) {
            try {
                this.sleeEndpoint.activityEnding(handle);
            }
            catch (UnrecognizedActivityException uae) {
                logger.error((Object)"failed to indicate activity has ended", (Throwable)uae);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"entityDeactivated(): cleaning naming context");
        }
        try {
            this.cleanNamingContextBindings();
        }
        catch (NamingException e) {
            logger.error((Object)"failed to clean naming context", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"entityDeactivated() completed");
        }
    }

    public void entityDeactivating() {
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, Object event, int param, Address address, int flags) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("eventProcessingSuccessful: activityHandle=" + activityHandle + ", event=" + event));
        }
        if (event instanceof HttpServletRequestEvent) {
            this.releaseHttpRequest((HttpServletRequestEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseHttpRequest(HttpServletRequestEvent hreqEvent) {
        Object lock;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"releaseHttpRequest() enter");
        }
        if ((lock = this.requestLock.removeLock(hreqEvent)) != null) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        } else {
            logger.warn((Object)("unable to wake up blocked servlet thread, did not found the lock for event " + hreqEvent));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"releaseHttpRequest() exit");
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, Object event, int param, Address address, int flags, FailureReason failureReason) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("eventProcessingFailed: activityHandle=" + activityHandle + ", event=" + event));
        }
        if (event instanceof HttpServletRequestEvent) {
            this.releaseHttpRequest((HttpServletRequestEvent)event);
        }
    }

    public void activityEnded(ActivityHandle activityHandle) {
        this.activities.remove(activityHandle);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("activityEnded: activityHandle=" + activityHandle));
        }
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (activityHandle instanceof HttpServletActivityHandle && !this.activities.containsKey(activityHandle)) {
            try {
                this.sleeEndpoint.activityEnding(activityHandle);
            }
            catch (UnrecognizedActivityException uae) {
                logger.error((Object)"Failed to end a leaked activity", (Throwable)uae);
            }
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object object) {
        if (object instanceof HttpSessionActivityImpl) {
            HttpServletActivityHandle ah = new HttpServletActivityHandle(((HttpSessionActivityImpl)object).getSessionId());
            if (this.activities.containsKey(ah)) {
                return ah;
            }
            return null;
        }
        if (object instanceof HttpServletRequestActivityImpl) {
            HttpServletActivityHandle ah = new HttpServletActivityHandle(((HttpServletRequestActivityImpl)object).getRequestID());
            if (this.activities.containsKey(ah)) {
                return ah;
            }
            return null;
        }
        return null;
    }

    public Object getSBBResourceAdaptorInterface(String str) {
        return this.httpRaSbbinterface;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void serviceInstalled(String serviceID, int[] eventIDs, String[] resourceOptions) {
        eventIDFilter.serviceInstalled(serviceID, eventIDs);
    }

    public void serviceUninstalled(String serviceID) {
        eventIDFilter.serviceUninstalled(serviceID);
    }

    public void serviceActivated(String serviceID) {
        eventIDFilter.serviceActivated(serviceID);
    }

    public void serviceDeactivated(String serviceID) {
        eventIDFilter.serviceDeactivated(serviceID);
    }

    private void initializeNamingContextBindings() throws NamingException {
        String name;
        String prefix;
        int toind;
        int begind;
        String jndiName;
        SleeContainer container = SleeContainer.lookupFromJndi();
        String entityName = this.bootstrapContext.getEntityName();
        ResourceAdaptorEntity resourceAdaptorEntity = container.getResourceAdaptorEnitity(entityName);
        ResourceAdaptorTypeIDImpl raTypeId = resourceAdaptorEntity.getInstalledResourceAdaptor().getRaType().getResourceAdaptorTypeID();
        this.acif = new HttpServletRaActivityContextInterfaceFactoryImpl(resourceAdaptorEntity.getServiceContainer(), entityName, this);
        resourceAdaptorEntity.getServiceContainer().getActivityContextInterfaceFactories().put(raTypeId, this.acif);
        try {
            if (this.acif != null) {
                jndiName = this.acif.getJndiName();
                begind = jndiName.indexOf(58);
                toind = jndiName.lastIndexOf(47);
                prefix = jndiName.substring(begind + 1, toind);
                name = jndiName.substring(toind + 1);
                logger.debug((Object)("========================== jndiName prefix =" + prefix + "; jndiName = " + name + " ; ACIF: " + this.acif + "========================="));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.acif);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        this.resourceEntryPoint = new HttpServletResourceEntryPoint(entityName, this);
        try {
            if (this.resourceEntryPoint != null) {
                jndiName = this.resourceEntryPoint.getJndiName();
                begind = jndiName.indexOf(58);
                toind = jndiName.lastIndexOf(47);
                prefix = jndiName.substring(begind + 1, toind);
                name = jndiName.substring(toind + 1);
                logger.debug((Object)("========================== jndiName prefix =" + prefix + "; jndiName = " + name + " ; Resource Entry Point: " + this.resourceEntryPoint + "========================="));
                SleeContainer.registerWithJndi((String)prefix, (String)name, (Object)this.resourceEntryPoint);
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void cleanNamingContextBindings() throws NamingException {
        try {
            String javaJNDIName;
            int begind;
            String jndiName;
            if (this.acif != null) {
                jndiName = this.acif.getJndiName();
                begind = jndiName.indexOf(58);
                javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("=================== JNDI name to unregister: " + javaJNDIName + " ===================="));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"====================== JNDI name unregistered.==========================");
            }
            if (this.resourceEntryPoint != null) {
                jndiName = this.resourceEntryPoint.getJndiName();
                begind = jndiName.indexOf(58);
                javaJNDIName = jndiName.substring(begind + 1);
                logger.debug((Object)("=================== JNDI name to unregister: " + javaJNDIName + " ===================="));
                SleeContainer.unregisterWithJndi((String)javaJNDIName);
                logger.debug((Object)"====================== JNDI name unregistered.==========================");
            }
        }
        catch (IndexOutOfBoundsException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpServletActivityHandle ah = null;
        HttpSession session = request.getSession(false);
        Object activity = null;
        boolean addedActivity = true;
        if (session == null) {
            HttpServletRequestActivityImpl httpServletRequestActivityImpl = new HttpServletRequestActivityImpl();
            ah = new HttpServletActivityHandle(httpServletRequestActivityImpl.getRequestID());
            this.activities.put(ah, httpServletRequestActivityImpl);
            activity = httpServletRequestActivityImpl;
        } else {
            activity = new HttpSessionActivityImpl(session.getId());
            ah = new HttpServletActivityHandle(session.getId());
            if (this.activities.putIfAbsent(ah, activity) == null) {
                session.setAttribute("ra-entry-point-jndi-name", (Object)this.resourceEntryPoint);
            } else {
                addedActivity = false;
            }
        }
        String pathInfo = "/mobicents" + request.getPathInfo();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Path Info = " + pathInfo));
        }
        HttpServletRequestEventImpl hreqEvent = new HttpServletRequestEventImpl(request, response, (Object)this);
        int eventID = -1;
        try {
            Object lock;
            eventID = eventIdCache.getEventId(this.eventLookup, (HttpServletRequestEvent)hreqEvent, session);
            if (eventID == -1) {
                logger.warn((Object)("Unable to get ID for event " + eventIdCache.getEventName((HttpServletRequestEvent)hreqEvent, session) + "#" + "net.java.slee" + "#" + "1.0"));
                return;
            }
            if (eventIDFilter.filterEvent(eventID)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Filtering event: " + hreqEvent));
                }
                if (addedActivity) {
                    this.activities.remove(ah);
                }
                return;
            }
            Address address = new Address(AddressPlan.URI, pathInfo);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Firing event: " + hreqEvent));
            }
            Object object = lock = this.requestLock.getLock((HttpServletRequestEvent)hreqEvent);
            synchronized (object) {
                this.sleeEndpoint.fireEvent((ActivityHandle)ah, (Object)hreqEvent, eventID, address);
                if (session == null) {
                    this.sleeEndpoint.activityEnding((ActivityHandle)ah);
                }
                lock.wait(20000L);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to fire event into SLEE", (Throwable)e);
        }
    }

    public void endHttpSessionActivity(String sessionId) {
        HttpServletActivityHandle ah;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("endHttpSessionActivity(sessionId=" + sessionId + ")"));
        }
        if (this.activities.containsKey(ah = new HttpServletActivityHandle(sessionId))) {
            try {
                this.sleeEndpoint.activityEnding((ActivityHandle)ah);
            }
            catch (UnrecognizedActivityException uae) {
                logger.error((Object)"Failed to end the HttpSession activity", (Throwable)uae);
            }
        }
    }

    protected HttpSessionActivityImpl getHttpSessionActivityImpl(HttpSession httpSession) throws NullPointerException, IllegalStateException, ActivityAlreadyExistsException, CouldNotStartActivityException {
        HttpSessionActivityImpl activity = new HttpSessionActivityImpl(httpSession.getId());
        HttpServletActivityHandle ah = new HttpServletActivityHandle(httpSession.getId());
        Object anotherActivity = this.activities.putIfAbsent(ah, activity);
        if (anotherActivity == null) {
            this.sleeEndpoint.activityStarted((ActivityHandle)ah);
            httpSession.setAttribute("ra-entry-point-jndi-name", (Object)this.resourceEntryPoint);
            return activity;
        }
        return (HttpSessionActivityImpl)anotherActivity;
    }
}

