/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.slee.facilities.EventLookupFacility;
import net.java.slee.resource.http.events.HttpServletRequestEvent;

public class EventIDCache {
    private static final String EVENT_PREFIX_SESSION = "net.java.slee.resource.http.events.incoming.session.";
    private static final String EVENT_PREFIX_REQUEST = "net.java.slee.resource.http.events.incoming.request.";
    public static final String VENDOR = "net.java.slee";
    public static final String VERSION = "1.0";
    private ConcurrentHashMap<String, Integer> eventIds = new ConcurrentHashMap();

    public String getEventName(HttpServletRequestEvent event, HttpSession httpSession) {
        if (httpSession == null) {
            return EVENT_PREFIX_REQUEST + event.getRequest().getMethod();
        }
        return EVENT_PREFIX_SESSION + event.getRequest().getMethod();
    }

    public int getEventId(EventLookupFacility eventLookupFacility, HttpServletRequestEvent event, HttpSession httpSession) {
        String eventName = this.getEventName(event, httpSession);
        Integer integer = this.eventIds.get(eventName);
        if (integer == null) {
            try {
                integer = eventLookupFacility.getEventID(eventName, VENDOR, VERSION);
            }
            catch (Exception e) {
                integer = -1;
            }
            this.eventIds.put(eventName, integer);
        }
        return integer;
    }
}

