/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.ServiceID;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.ReceivableService;

public class EventIDFilter {
    private final ConcurrentHashMap<EventTypeID, Set<ServiceID>> eventID2serviceIDs = new ConcurrentHashMap(31);

    public boolean filterEvent(FireableEventType eventType) {
        return !this.eventID2serviceIDs.containsKey(eventType.getEventType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceActive(ReceivableService receivableService) {
        for (ReceivableService.ReceivableEvent receivableEvent : receivableService.getReceivableEvents()) {
            Set<ServiceID> servicesReceivingEvent = this.eventID2serviceIDs.get(receivableEvent.getEventType());
            if (servicesReceivingEvent == null) {
                servicesReceivingEvent = new HashSet<ServiceID>();
                Set<ServiceID> anotherSet = this.eventID2serviceIDs.putIfAbsent(receivableEvent.getEventType(), servicesReceivingEvent);
                if (anotherSet != null) {
                    servicesReceivingEvent = anotherSet;
                }
            }
            Set<ServiceID> set = servicesReceivingEvent;
            synchronized (set) {
                servicesReceivingEvent.add(receivableService.getService());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceInactive(ReceivableService receivableService) {
        for (ReceivableService.ReceivableEvent receivableEvent : receivableService.getReceivableEvents()) {
            Set<ServiceID> servicesReceivingEvent = this.eventID2serviceIDs.get(receivableEvent.getEventType());
            if (servicesReceivingEvent == null) continue;
            Set<ServiceID> set = servicesReceivingEvent;
            synchronized (set) {
                servicesReceivingEvent.remove(receivableService.getService());
            }
        }
    }

    public void serviceStopping(ReceivableService receivableService) {
    }
}

