/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.FireableEventType;
import net.java.slee.resource.http.events.HttpServletRequestEvent;

public class EventIDCache {
    private static final String EVENT_PREFIX_SESSION = "net.java.slee.resource.http.events.incoming.session.";
    private static final String EVENT_PREFIX_REQUEST = "net.java.slee.resource.http.events.incoming.request.";
    public static final String VENDOR = "net.java.slee";
    public static final String VERSION = "1.0";
    private ConcurrentHashMap<String, FireableEventType> eventTypes = new ConcurrentHashMap();
    private final Tracer tracer;

    public EventIDCache(Tracer tracer) {
        this.tracer = tracer;
    }

    public String getEventName(HttpServletRequestEvent event, HttpSession httpSession) {
        if (httpSession == null) {
            return EVENT_PREFIX_REQUEST + event.getRequest().getMethod();
        }
        return EVENT_PREFIX_SESSION + event.getRequest().getMethod();
    }

    public FireableEventType getEventType(EventLookupFacility eventLookupFacility, HttpServletRequestEvent event, HttpSession httpSession) {
        String eventName = this.getEventName(event, httpSession);
        FireableEventType eventType = this.eventTypes.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                this.tracer.severe("Failed to obtain fireable event type for event with name " + eventName, e);
                return null;
            }
            this.eventTypes.put(eventName, eventType);
        }
        return eventType;
    }
}

