/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.mobicents.slee.resource.http.AbstractHttpServletActivity;
import org.mobicents.slee.resource.http.EventIDCache;
import org.mobicents.slee.resource.http.EventIDFilter;
import org.mobicents.slee.resource.http.HttpServletRaSbbInterfaceImpl;
import org.mobicents.slee.resource.http.HttpServletRequestActivityImpl;
import org.mobicents.slee.resource.http.HttpServletRequestWrapper;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPoint;
import org.mobicents.slee.resource.http.HttpServletResourceEntryPointManager;
import org.mobicents.slee.resource.http.HttpSessionActivityImpl;
import org.mobicents.slee.resource.http.HttpSessionWrapper;
import org.mobicents.slee.resource.http.RequestLock;
import org.mobicents.slee.resource.http.events.HttpServletRequestEventImpl;

public class HttpServletResourceAdaptor
implements ResourceAdaptor,
HttpServletResourceEntryPoint {
    private Tracer logger;
    private ResourceAdaptorContext resourceAdaptorContext;
    private SleeEndpoint sleeEndpoint;
    private EventLookupFacility eventLookup;
    private RequestLock requestLock;
    private HttpServletRaSbbInterfaceImpl httpRaSbbinterface;
    private EventIDCache eventIdCache;
    private EventIDFilter eventIDFilter;
    private String name;
    private static final String NAME_CONFIG_PROPERTY = "name";

    public ResourceAdaptorContext getResourceAdaptorContext() {
        return this.resourceAdaptorContext;
    }

    public SleeEndpoint getSleeEndpoint() {
        return this.sleeEndpoint;
    }

    public String getName() {
        return this.name;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext arg0) {
        this.resourceAdaptorContext = arg0;
        this.logger = arg0.getTracer(HttpServletResourceAdaptor.class.getSimpleName());
        this.eventIdCache = new EventIDCache(arg0.getTracer(EventIDCache.class.getSimpleName()));
        this.eventIDFilter = new EventIDFilter();
        this.sleeEndpoint = arg0.getSleeEndpoint();
        this.eventLookup = arg0.getEventLookupFacility();
        this.requestLock = new RequestLock();
        this.httpRaSbbinterface = new HttpServletRaSbbInterfaceImpl(this);
    }

    public void raConfigure(ConfigProperties arg0) {
        this.name = (String)arg0.getProperty(NAME_CONFIG_PROPERTY).getValue();
    }

    public void raActive() {
        HttpServletResourceEntryPointManager.putResourceEntryPoint((String)this.name, (HttpServletResourceEntryPoint)this);
    }

    public void raStopping() {
    }

    public void raInactive() {
        HttpServletResourceEntryPointManager.removeResourceEntryPoint((String)this.name);
    }

    public void raUnconfigure() {
        this.name = null;
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
        this.logger = null;
        this.eventIdCache = null;
        this.eventIDFilter = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.requestLock = null;
        this.httpRaSbbinterface = null;
    }

    public void raVerifyConfiguration(ConfigProperties arg0) throws InvalidConfigurationException {
        ConfigProperties.Property property = arg0.getProperty(NAME_CONFIG_PROPERTY);
        if (property == null) {
            throw new InvalidConfigurationException("name property not found");
        }
        if (!property.getType().equals(String.class.getName())) {
            throw new InvalidConfigurationException("name property must be of type java.lang.String");
        }
        if (property.getValue() == null) {
            throw new InvalidConfigurationException("name property must not have a null value");
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
        throw new UnsupportedOperationException();
    }

    public void serviceActive(ReceivableService arg0) {
        this.eventIDFilter.serviceActive(arg0);
    }

    public void serviceStopping(ReceivableService arg0) {
        this.eventIDFilter.serviceStopping(arg0);
    }

    public void serviceInactive(ReceivableService arg0) {
        this.eventIDFilter.serviceInactive(arg0);
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return activityHandle;
    }

    public ActivityHandle getActivityHandle(Object object) {
        return (ActivityHandle)object;
    }

    public void activityEnded(ActivityHandle arg0) {
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object event, Address arg3, ReceivableService arg4, int arg5) {
        this.releaseHttpRequest((HttpServletRequestEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseHttpRequest(HttpServletRequestEvent hreqEvent) {
        Object lock;
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("releaseHttpRequest() enter");
        }
        if ((lock = this.requestLock.removeLock(hreqEvent)) != null) {
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("released lock for http request " + hreqEvent.getId());
        }
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Activity " + activityHandle + " is idle in the container, terminating.");
        }
        this.endActivity((AbstractHttpServletActivity)activityHandle);
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.httpRaSbbinterface;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequest(HttpServletRequest request, HttpServletResponse response) {
        Object lock;
        AbstractHttpServletActivity activity = null;
        HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper(request);
        HttpServletRequestEventImpl event = new HttpServletRequestEventImpl((HttpServletRequest)wrapper, response, (Object)this);
        HttpSessionWrapper session = (HttpSessionWrapper)wrapper.getSession(false);
        FireableEventType eventType = this.eventIdCache.getEventType(this.eventLookup, (HttpServletRequestEvent)event, (HttpSession)session);
        if (this.eventIDFilter.filterEvent(eventType)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Event filtered: " + event);
            }
            return;
        }
        boolean createActivity = true;
        if (session == null) {
            activity = new HttpServletRequestActivityImpl();
        } else {
            activity = new HttpSessionActivityImpl(session.getId());
            if (session.getResourceEntryPoint() != null) {
                createActivity = false;
            }
        }
        if (createActivity) {
            try {
                if (session != null) {
                    session.setResourceEntryPoint(this.name);
                }
                this.sleeEndpoint.startActivity((ActivityHandle)activity, (Object)activity);
            }
            catch (ActivityAlreadyExistsException e) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Failed to add activity " + activity, (Throwable)e);
                }
            }
            catch (Throwable e) {
                this.logger.severe("Failed to add activity " + activity, e);
                return;
            }
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Firing event " + event + " in activity " + activity);
        }
        Object object = lock = this.requestLock.getLock((HttpServletRequestEvent)event);
        synchronized (object) {
            try {
                this.sleeEndpoint.fireEvent((ActivityHandle)activity, eventType, (Object)event, null, null, 128);
                lock.wait(15000L);
                if (session == null) {
                    this.endActivity(activity);
                }
            }
            catch (Throwable e) {
                this.logger.severe("Failure while firing event " + event + " on activity " + activity, e);
            }
        }
    }

    private void endActivity(AbstractHttpServletActivity activity) {
        if (this.logger.isInfoEnabled()) {
            this.logger.fine("Ending activity " + activity);
        }
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)activity);
        }
        catch (Throwable e) {
            this.logger.severe("Failed to end activity " + activity, e);
        }
    }

    public void onSessionTerminated(String sessionId) {
        this.endActivity(new HttpSessionActivityImpl(sessionId));
    }
}

