/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.jcc.inap;

import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.csapi.cc.jcc.EventFilter;
import javax.csapi.cc.jcc.InvalidArgumentException;
import javax.csapi.cc.jcc.InvalidStateException;
import javax.csapi.cc.jcc.JccAddress;
import javax.csapi.cc.jcc.JccCall;
import javax.csapi.cc.jcc.JccConnection;
import javax.csapi.cc.jcc.JccConnectionEvent;
import javax.csapi.cc.jcc.JccConnectionListener;
import javax.csapi.cc.jcc.JccEvent;
import javax.csapi.cc.jcc.PrivilegeViolationException;
import javax.csapi.cc.jcc.ResourceUnavailableException;
import org.apache.log4j.Logger;
import org.mobicents.jcc.inap.ConnectionID;
import org.mobicents.jcc.inap.EventProducer;
import org.mobicents.jcc.inap.JccCallImpl;
import org.mobicents.jcc.inap.JccConnectionEventImpl;
import org.mobicents.jcc.inap.address.JccCalledPartyNumber;
import org.mobicents.jcc.inap.protocol.Connect;
import org.mobicents.jcc.inap.protocol.tcap.Components;
import org.mobicents.jcc.inap.protocol.tcap.DialoguePortion;
import org.mobicents.jcc.inap.protocol.tcap.Invoke;
import org.mobicents.jcc.inap.protocol.tcap.TCContinue;
import org.mobicents.jcc.inap.protocol.tcap.TCEnd;
import org.mobicents.ss7.sccp.SccpAddress;
import org.mobicents.util.LocalTimer;

public abstract class AbstractConnection
implements JccConnection {
    public static final int IDLE_TIMEOUT = 5;
    public static final int AUTH_TIMEOUT = 5;
    public static final int ADDRESS_ANALYZE_TIMEOUT = 5;
    public static final int CALL_DELIVERY_TIMEOUT = 65;
    public static final int ALERTING_TIMEOUT = 65;
    public static final int CONNECTED_TIMEOUT = 1805;
    protected ConnectionID connectionID;
    protected boolean isBlocked = false;
    protected JccAddress address;
    protected JccCallImpl call;
    protected int state;
    protected int cause;
    protected LocalTimer timer = new LocalTimer();
    protected Semaphore semaphore = new Semaphore(0L);
    private QueuedExecutor applicationEventQueue = new QueuedExecutor();
    private QueuedExecutor signalingEventQueue = new QueuedExecutor();
    protected Logger logger;
    private static final HashMap states = new HashMap();
    private static final HashMap causes = new HashMap();
    private boolean released = false;
    private String callID;

    public AbstractConnection(ConnectionID connectionID, JccCallImpl call, JccAddress address) {
        this.connectionID = connectionID;
        this.call = call;
        this.address = address;
        this.state = 1;
        this.callID = call.callID;
    }

    public ConnectionID getID() {
        return this.connectionID;
    }

    public JccAddress getAddress() {
        return this.address;
    }

    public JccCall getCall() {
        return this.call;
    }

    public int getState() {
        return this.state;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }

    public void release(int causeCode) throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException, InvalidArgumentException {
        this.released = true;
        JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this, 115);
        this.queueEvent((JccEvent)evt);
        if (this.isBlocked()) {
            this.resume();
        }
        JccCalledPartyNumber cpn = null;
        switch (causeCode) {
            case 115: {
                cpn = new JccCalledPartyNumber(this.call.provider, "9999");
            }
        }
        cpn = new JccCalledPartyNumber(this.call.provider, "9999");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "release(): connecting to " + cpn.getRouteAddress()));
        }
        Connect connect = new Connect(cpn.getRouteAddress());
        Components components = new Components();
        components.add(new Invoke(1, connect));
        TCContinue message = new TCContinue(this.connectionID.getId());
        message.setDialogue(new DialoguePortion());
        message.setComponents(components);
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
        }
        catch (IOException e) {
            evt = new JccConnectionEventImpl(108, this, 116);
            this.queueEvent((JccEvent)evt);
        }
    }

    public synchronized void continueProcessing() throws PrivilegeViolationException, ResourceUnavailableException, InvalidStateException {
        this.resume();
    }

    public synchronized void queueEvent(JccEvent event) {
        if (event.getID() == 108) {
            this.logger.debug((Object)(this + "restarting signaling queue"));
            this.signalingEventQueue.shutdownNow();
            this.signalingEventQueue = new QueuedExecutor();
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(this + "queue event " + event));
            }
            this.signalingEventQueue.execute((Runnable)event);
            Thread.currentThread();
            Thread.yield();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void block() {
        block4: {
            this.isBlocked = true;
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this + "blocking processing in state=" + AbstractConnection.getStateName(this.state)));
                }
                this.semaphore.acquire();
                this.isBlocked = false;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this + "resuming processing in state=" + AbstractConnection.getStateName(this.state)));
                }
            }
            catch (InterruptedException e) {
                this.isBlocked = false;
                if (!this.logger.isDebugEnabled()) break block4;
                this.logger.debug((Object)(this + "interrupted block in state=" + AbstractConnection.getStateName(this.state)));
            }
        }
    }

    protected void resume() {
        if (this.isBlocked) {
            this.semaphore.release();
        }
    }

    public void onConnectionCreated() {
        this.logger.info((Object)(this + "CONNECTION_CREATED, " + AbstractConnection.getCauseName(this.cause)));
        this.call.append(this);
        this.timer.schedule(new CancelTimeoutTask(this), 5);
    }

    public abstract void onAuthorizeCallAttempt();

    public abstract void onAddressCollect();

    public abstract void onAddressAnalyze(JccConnectionEventImpl var1);

    public abstract void onCallDelivery();

    public abstract void onAlerting();

    public abstract void onConnected();

    public void onFailed() {
        this.logger.info((Object)(this + "FAILED, " + AbstractConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onFailed(): disable timer"));
        }
        this.timer.stop();
        JccConnectionEventImpl event = new JccConnectionEventImpl(107, this, this.cause);
        this.queueEvent((JccEvent)event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onFailed(): release all blocks"));
        }
        this.resume();
    }

    public void onDisconnected() {
        this.logger.info((Object)(this + "DISCONNECTING, " + AbstractConnection.getCauseName(this.cause)));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): disable timer"));
        }
        this.timer.stop();
        this.timer = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): release all blocks"));
        }
        if (this.isBlocked()) {
            this.resume();
        }
        this.semaphore = null;
        if (this.released) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): ending TCAP dialogue"));
        }
        TCEnd message = new TCEnd(this.connectionID.getId());
        SccpAddress calledPartyAddress = this.connectionID.getCallingPartyAddress();
        SccpAddress callingPartyAddress = this.connectionID.getCalledPartyAddress();
        try {
            this.call.provider.send(calledPartyAddress, callingPartyAddress, message);
        }
        catch (IOException e) {
            this.logger.error((Object)"Network error", (Throwable)e);
        }
    }

    protected void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): removing connection reference"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): shutdown application event queue"));
        }
        this.applicationEventQueue.shutdownNow();
        this.applicationEventQueue = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this + "onDisconnected(): shutdown signaling event queue"));
        }
        this.signalingEventQueue.shutdownNow();
        this.signalingEventQueue = null;
        this.call.remove(this);
        this.call = null;
    }

    protected void fireConnectionEvent(JccConnectionEvent event) {
        this.fireConnectionEvent(this.call.connectionListeners, event);
        this.fireConnectionEvent(this.call.provider.connectionListeners, event);
    }

    private void fireConnectionEvent(ArrayList listeners, JccConnectionEvent event) {
        AbstractConnection connection = (AbstractConnection)event.getConnection();
        int count = listeners.size();
        block9: for (int i = 0; i < count; ++i) {
            Object[] ls = (Object[])listeners.get(i);
            JccConnectionListener listener = (JccConnectionListener)ls[0];
            EventFilter filter = (EventFilter)ls[1];
            int disposition = filter.getEventDisposition((JccEvent)event);
            if (disposition == 2 && event.getID() == 107) {
                disposition = 1;
            }
            switch (disposition) {
                case 0: {
                    if (!this.logger.isDebugEnabled()) continue block9;
                    this.logger.debug((Object)(this + "fire event " + event + ", disposition=event_discard"));
                    continue block9;
                }
                case 2: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(this + "fire event " + event + ", disposition=event_block"));
                    }
                    try {
                        this.applicationEventQueue.execute((Runnable)new EventProducer(listener, event));
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.block();
                    continue block9;
                }
                case 1: {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)(this + "fire event " + event + ", disposition=event_notify"));
                    }
                    try {
                        this.applicationEventQueue.execute((Runnable)new EventProducer(listener, event));
                        continue block9;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static synchronized String getStateName(int state) {
        return (String)states.get(new Integer(state));
    }

    public static synchronized String getCauseName(int cause) {
        return (String)causes.get(new Integer(cause));
    }

    public String toString() {
        return "(call_id=" + this.callID + ", address=" + this.address.getName() + ") ";
    }

    static {
        states.put(new Integer(1), "IDLE");
        states.put(new Integer(4), "ADDRESS_ANALYZE");
        states.put(new Integer(3), "ADDRESS_COLLECT");
        states.put(new Integer(6), "ALERTING");
        states.put(new Integer(2), "AUTHORIZE_CALL_ATTEMPT");
        states.put(new Integer(5), "CALL_DELIVERY");
        states.put(new Integer(7), "CONNECTED");
        states.put(new Integer(0), "DISCONNECTED");
        states.put(new Integer(9), "FAILED");
        causes.put(new Integer(113), "CAUSE_BUSY");
        causes.put(new Integer(102), "CAUSE_CALL_CANCELED");
        causes.put(new Integer(115), "CAUSE_CALL_RESTRICTED");
        causes.put(new Integer(103), "CAUSE_DEST_NOT_OBTAINABLE");
        causes.put(new Integer(116), "CAUSE_GENERAL_FAILURE");
        causes.put(new Integer(104), "CAUSE_INCOMPATIBLE_DESTINATION");
        causes.put(new Integer(112), "CAUSE_MORE_DIGITS_NEEDED");
        causes.put(new Integer(108), "CAUSE_NETWORK_CONGESTION");
        causes.put(new Integer(109), "CAUSE_NETWORK_NOT_OBTAINABLE");
        causes.put(new Integer(106), "CAUSE_NEW_CALL");
        causes.put(new Integer(100), "CAUSE_NORMAL");
        causes.put(new Integer(114), "CAUSE_NO_ANSWER");
        causes.put(new Integer(111), "CAUSE_REDIRECTED");
        causes.put(new Integer(107), "CAUSE_RESOURCES_NOT_AVAILABLE");
        causes.put(new Integer(110), "CAUSE_SNAPSHOT");
        causes.put(new Integer(117), "CAUSE_TIMER_EXPIRY");
        causes.put(new Integer(101), "CAUSE_UNKNOWN");
        causes.put(new Integer(118), "CAUSE_USER_NOT_AVAILABLE");
    }

    private class CancelTimeoutTask
    implements Runnable {
        private JccConnection connection;

        public CancelTimeoutTask(JccConnection connection) {
            this.connection = connection;
        }

        public void run() {
            AbstractConnection.this.logger.debug((Object)("Timer expired. state=" + AbstractConnection.getStateName(AbstractConnection.this.state) + ", Cancel call"));
            if (AbstractConnection.this.isBlocked()) {
                AbstractConnection.this.resume();
            }
            JccConnectionEventImpl evt = new JccConnectionEventImpl(108, this.connection, 117);
            AbstractConnection.this.queueEvent((JccEvent)evt);
        }
    }
}

